/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Bug27224Test
extends CalDAVTest {
    public Bug27224Test(String name) {
        super(name);
    }

    public void testChangetransparency() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = Bug27224Test.randomUID();
        String summary = "Bug27224Test";
        String location = "da";
        Date start = TimeTools.D("next friday at 02:00");
        Date end = TimeTools.D("next friday at 04:00");
        Appointment appointment = Bug27224Test.generateAppointment(start, end, uid, summary, location);
        appointment.setShownAs(1);
        super.rememberForCleanUp(super.create(appointment));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Bug27224Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug27224Test.assertContains(uid, calendarData);
        Bug27224Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug27224Test.assertEquals((String)"SUMMARY wrong", (String)summary, (String)iCalResource.getVEvent().getSummary());
        Bug27224Test.assertEquals((String)"LOCATION wrong", (String)location, (String)iCalResource.getVEvent().getLocation());
        if (null != iCalResource.getVEvent().getTransp()) {
            Bug27224Test.assertEquals((String)"TRANSP wrong", (String)"OPAQUE", (String)iCalResource.getVEvent().getTransp());
        }
        iCalResource.getVEvent().setTransp("TRANSPARENT");
        Bug27224Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(uid);
        Bug27224Test.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Bug27224Test.assertEquals((String)"shown as wrong", (int)4, (int)appointment.getShownAs());
        iCalResource = super.get(uid, iCalResource.getETag());
        Bug27224Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug27224Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug27224Test.assertEquals((String)"TRANSP wrong", (String)"TRANSPARENT", (String)iCalResource.getVEvent().getTransp());
    }
}

