/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.user.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.user.actions.AbstractUserRequest;
import com.openexchange.ajax.user.actions.SetAttributeParser;
import com.openexchange.ajax.user.actions.SetAttributeResponse;
import org.json.JSONException;
import org.json.JSONObject;

public final class SetAttributeRequest
extends AbstractUserRequest<SetAttributeResponse> {
    private final int userId;
    private final String name;
    private final Object value;
    private final boolean setIfAbsent;
    private final boolean failOnError;

    public SetAttributeRequest(int userId, String name, Object value, boolean setIfAbsent) {
        this(userId, name, value, setIfAbsent, true);
    }

    public SetAttributeRequest(int userId, String name, Object value, boolean setIfAbsent, boolean failOnError) {
        this.userId = userId;
        this.name = name;
        this.value = value;
        this.setIfAbsent = setIfAbsent;
        this.failOnError = failOnError;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.URLParameter("action", "setAttribute"), new AJAXRequest.URLParameter("id", this.userId), new AJAXRequest.URLParameter("setIfAbsent", this.setIfAbsent)};
    }

    public SetAttributeParser getParser() {
        return new SetAttributeParser(this.failOnError);
    }

    @Override
    public Object getBody() throws JSONException {
        JSONObject body = new JSONObject();
        body.put("name", (Object)this.name);
        if (null != this.value) {
            body.put("value", this.value);
        }
        return body;
    }
}

