/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Test;
import org.xml.sax.SAXException;

public class Bug11190Test
extends AbstractAJAXSession {
    public Bug11190Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSwitchingBetweenMonthlyRecurrencePatternsShouldNotBreakRecurrence() throws OXException, IOException, SAXException, JSONException, OXException {
        AJAXClient ajaxClient = this.getClient();
        TimeZone timezone = ajaxClient.getValues().getTimeZone();
        int folderId = ajaxClient.getValues().getPrivateTaskFolder();
        Task taskWithRecurrence = new Task();
        taskWithRecurrence.setTitle("Reproducing bug 11190");
        taskWithRecurrence.setParentFolderID(folderId);
        taskWithRecurrence.setStartDate(new Date());
        taskWithRecurrence.setEndDate(new Date());
        taskWithRecurrence.setRecurrenceType(3);
        taskWithRecurrence.setInterval(3);
        taskWithRecurrence.setDays(2);
        taskWithRecurrence.setDayInMonth(2);
        InsertRequest insertRequest = new InsertRequest(taskWithRecurrence, timezone);
        InsertResponse insertResponse = ajaxClient.execute(insertRequest);
        taskWithRecurrence.setLastModified(insertResponse.getTimestamp());
        try {
            insertResponse.fillTask(taskWithRecurrence);
            taskWithRecurrence.setRecurrenceType(3);
            taskWithRecurrence.setInterval(2);
            taskWithRecurrence.setDayInMonth(12);
            taskWithRecurrence.removeDays();
            IntToNullSettingUpdateRequest updateRequest = new IntToNullSettingUpdateRequest(taskWithRecurrence, timezone);
            UpdateResponse updateResponse = ajaxClient.execute(updateRequest);
            taskWithRecurrence.setLastModified(updateResponse.getTimestamp());
            GetRequest getRequest = new GetRequest(folderId, taskWithRecurrence.getObjectID());
            GetResponse getResponse = ajaxClient.execute(getRequest);
            Task resultingTask = getResponse.getTask(timezone);
            Bug11190Test.assertEquals((String)"Recurrence type does not match", (int)3, (int)resultingTask.getRecurrenceType());
            Bug11190Test.assertEquals((String)"Recurrence interval does not match", (int)2, (int)resultingTask.getInterval());
            Bug11190Test.assertEquals((String)"Recurring day in month does not match", (int)12, (int)resultingTask.getDayInMonth());
            Bug11190Test.assertEquals((String)"Recurring days should not be set anymore", (boolean)false, (boolean)resultingTask.containsDays());
        }
        finally {
            DeleteRequest cleanUp = new DeleteRequest(taskWithRecurrence);
            ajaxClient.execute(cleanUp);
        }
    }

    private class IntToNullSettingUpdateRequest
    extends UpdateRequest {
        public IntToNullSettingUpdateRequest(Task task, TimeZone timeZone) {
            super(task, timeZone);
        }

        @Override
        public JSONObject getBody() throws JSONException {
            JSONObject obj = super.getBody();
            if (!this.getTask().containsDays() && this.getTask().containsDayInMonth()) {
                obj.put("days", JSONObject.NULL);
            }
            return obj;
        }
    }
}

