/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailTestManager;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.exception.OXException;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class CopyMailTest
extends AbstractMailTest {
    private UserValues values;

    public CopyMailTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    protected void tearDown() throws Exception {
        this.clearFolder(this.values.getSentFolder());
        this.clearFolder(this.values.getInboxFolder());
        this.clearFolder(this.values.getDraftsFolder());
        super.tearDown();
    }

    public void testShouldCopyFromSentToDrafts() throws OXException, IOException, SAXException, JSONException {
        MailTestManager manager = new MailTestManager(this.client, false);
        String eml = "Date: Mon, 19 Nov 2012 21:36:51 +0100 (CET)\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Message-ID: <1508703313.17483.1353357411049>\n" + "Subject: Copy a mail\n" + "MIME-Version: 1.0\n" + "Content-Type: multipart/alternative; \n" + "    boundary=\"----=_Part_17482_1388684087.1353357411002\"\n" + "\n" + "------=_Part_17482_1388684087.1353357411002\n" + "MIME-Version: 1.0\n" + "Content-Type: text/plain; charset=UTF-8\n" + "Content-Transfer-Encoding: 7bit\n" + "\n" + "Copy from sent to drafts\n" + "------=_Part_17482_1388684087.1353357411002\n" + "MIME-Version: 1.0\n" + "Content-Type: text/html; charset=UTF-8\n" + "Content-Transfer-Encoding: 7bit\n" + "\n" + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\">" + " <head>\n" + "    <meta content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\"/>\n" + " </head><body style=\"font-family: verdana,geneva; font-size: 10pt; \">\n" + " \n" + "  <div>\n" + "   Copy from sent to drafts\n" + "  </div>\n" + " \n" + "</body></html>\n" + "------=_Part_17482_1388684087.1353357411002--\n";
        this.getClient().execute(new NewMailRequest(this.getInboxFolder(), eml, -1, true));
        String origin = this.values.getInboxFolder();
        String destination = this.values.getDraftsFolder();
        TestMail myMail = new TestMail(this.getFirstMailInFolder(origin));
        myMail.getId();
        TestMail copiedMail = manager.copy(myMail, destination);
        String newID = copiedMail.getId();
        manager.get(destination, newID);
        CopyMailTest.assertTrue((String)"Should produce no errors when getting copied e-mail", (!manager.getLastResponse().hasError() ? 1 : 0) != 0);
        CopyMailTest.assertTrue((String)"Should produce no conflicts when getting copied e-mail", (!manager.getLastResponse().hasConflicts() ? 1 : 0) != 0);
    }
}

