/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AbstractInsertParser;
import org.json.JSONObject;

class InsertParser
extends AbstractInsertParser<InsertResponse> {
    public InsertParser(boolean failOnError) {
        super(failOnError);
    }

    @Override
    protected InsertResponse instantiateResponse(Response response) {
        return new InsertResponse(response);
    }

    @Override
    protected InsertResponse createResponse(Response response) {
        InsertResponse retval = this.instantiateResponse(response);
        if (JSONObject.NULL == retval.getData()) {
            InsertParser.fail((String)("Problem while inserting folder: " + response.getErrorMessage()));
        }
        try {
            int folderId = Integer.parseInt((String)retval.getData());
            retval.setId(folderId);
            if (this.isFailOnError()) {
                InsertParser.assertTrue((String)"Problem while inserting folder.", (folderId > 0 ? 1 : 0) != 0);
            }
        }
        catch (NumberFormatException e) {
            retval.setMailFolderID((String)retval.getData());
        }
        return retval;
    }
}

