/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.drive;

import com.openexchange.ajax.find.AbstractFindTest;
import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.find.actions.AutocompleteRequest;
import com.openexchange.ajax.find.actions.AutocompleteResponse;
import com.openexchange.ajax.find.actions.QueryRequest;
import com.openexchange.ajax.find.actions.QueryResponse;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.ajax.infostore.actions.ListInfostoreRequest;
import com.openexchange.ajax.infostore.actions.ListInfostoreResponse;
import com.openexchange.ajax.infostore.actions.SearchInfostoreRequest;
import com.openexchange.ajax.infostore.actions.SearchInfostoreResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.file.storage.File;
import com.openexchange.find.Document;
import com.openexchange.find.FindExceptionCode;
import com.openexchange.find.Module;
import com.openexchange.find.SearchResult;
import com.openexchange.find.basic.drive.FileSize;
import com.openexchange.find.common.CommonFacetType;
import com.openexchange.find.common.FolderType;
import com.openexchange.find.drive.DriveFacetType;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.DefaultFacet;
import com.openexchange.find.facet.ExclusiveFacet;
import com.openexchange.find.facet.Facet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.find.facet.Filter;
import com.openexchange.find.facet.SimpleFacet;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class BasicDriveTest
extends AbstractFindTest {
    private DocumentMetadata metadata;
    private FolderObject testFolder;
    private InfostoreTestManager manager;
    private static final String SEARCH = "BasicDriveTest";

    public BasicDriveTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = new AJAXClient(AJAXClient.User.User1);
        MailConfig.init();
        String testDataDir = MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR);
        File file = new File(testDataDir, "BasicDriveTest.tmp");
        String folderName = "findApiDriveTestFolder_" + System.currentTimeMillis();
        this.testFolder = this.folderManager.generatePrivateFolder(folderName, 8, this.client.getValues().getPrivateInfostoreFolder(), this.client.getValues().getUserId());
        this.testFolder = this.folderManager.insertFolderOnServer(this.testFolder);
        this.manager = new InfostoreTestManager(this.client);
        this.metadata = new DocumentMetadataImpl();
        this.metadata.setFileName(file.getName());
        this.metadata.setTitle(file.getName());
        this.metadata.setDescription("Test file for testing new find api");
        this.metadata.setFolderId((long)this.testFolder.getObjectID());
        this.metadata.setMeta(Collections.singletonMap("key", "value"));
        this.manager.newAction(this.metadata, file);
    }

    @Override
    public void tearDown() throws Exception {
        this.manager.cleanUp();
        super.tearDown();
    }

    public void testSearch() throws Exception {
        this.verifyDocumentExists();
        ActiveFacet fileNameFacet = new ActiveFacet((FacetType)CommonFacetType.GLOBAL, "global", new Filter(Collections.singletonList("filename"), SEARCH));
        QueryRequest request = new QueryRequest(0, 10, Collections.singletonList(fileNameFacet), Module.DRIVE.getIdentifier());
        QueryResponse response = this.client.execute(request);
        SearchResult result = response.getSearchResult();
        BasicDriveTest.assertTrue((String)"Nothing found in BasicDriveTest", (result.getSize() > 0 ? 1 : 0) != 0);
    }

    public void testSizeFacet() throws Exception {
        this.verifyDocumentExists();
        ActiveFacet fileSizeFacet = new ActiveFacet((FacetType)DriveFacetType.FILE_SIZE, FileSize.MB1.getSize(), new Filter(Collections.singletonList("file_size"), FileSize.MB1.getSize()));
        QueryRequest request = new QueryRequest(0, 10, Collections.singletonList(fileSizeFacet), Module.DRIVE.getIdentifier());
        QueryResponse response = this.client.execute(request);
        SearchResult result = response.getSearchResult();
        BasicDriveTest.assertNotNull((String)"No search result", (Object)result);
        BasicDriveTest.assertTrue((String)"Nothing found in file size test", (result.getSize() > 0 ? 1 : 0) != 0);
        for (Document d : result.getDocuments()) {
            PropDocument file = (PropDocument)d;
            BasicDriveTest.assertTrue((String)"File is too small", ((Integer)file.getProps().get("file_size") >= 0x100000 ? 1 : 0) != 0);
        }
    }

    private void verifyDocumentExists() throws Exception {
        int[] columns = new int[]{1, 20, 700};
        SearchInfostoreResponse verificationResponse = this.client.execute(new SearchInfostoreRequest(this.testFolder.getObjectID(), this.metadata.getTitle(), columns));
        JSONArray foundFiles = (JSONArray)verificationResponse.getData();
        BasicDriveTest.assertEquals((String)"Wrong number of documents found via conventional search", (int)1, (int)foundFiles.length());
        JSONArray desiredFile = foundFiles.getJSONArray(0);
        BasicDriveTest.assertEquals((String)"Wrong id for file found via conventional search", (int)this.metadata.getId(), (int)Integer.parseInt(desiredFile.get(0).toString()));
        BasicDriveTest.assertEquals((String)"Wrong folder for file found via conventional search", (int)this.testFolder.getObjectID(), (int)Integer.parseInt(desiredFile.get(1).toString()));
        BasicDriveTest.assertEquals((String)"Wrong title for file found via conventional search", (String)this.metadata.getTitle(), (String)desiredFile.get(2).toString());
    }

    public void testExclusiveFacetValues() throws Exception {
        List<Facet> facets = this.autocomplete("");
        Facet folderTypeFacet = BasicDriveTest.findByType((FacetType)CommonFacetType.FOLDER_TYPE, facets);
        BasicDriveTest.assertNotNull((String)"Missing folder type facet", (Object)folderTypeFacet);
        BasicDriveTest.assertEquals((String)"Expected all 3 folder types", (int)3, (int)((ExclusiveFacet)folderTypeFacet).getValues().size());
        FacetValue chosenType = (FacetValue)((ExclusiveFacet)folderTypeFacet).getValues().get(0);
        facets = this.autocomplete("", Collections.singletonList(BasicDriveTest.createFolderTypeFacet(FolderType.getByIdentifier((String)chosenType.getId()))));
        BasicDriveTest.assertNull((String)"Folder type facet was returned", (Object)BasicDriveTest.findByType((FacetType)CommonFacetType.FOLDER_TYPE, facets));
    }

    public void testExclusiveFacets() throws Exception {
        List<Facet> facets = this.autocomplete("");
        Facet folderTypeFacet = BasicDriveTest.findByType((FacetType)CommonFacetType.FOLDER_TYPE, facets);
        BasicDriveTest.assertNotNull((String)"Missing folder type facet", (Object)folderTypeFacet);
        BasicDriveTest.assertEquals((String)"Expected all 3 folder types", (int)3, (int)((ExclusiveFacet)folderTypeFacet).getValues().size());
        facets = this.autocomplete("", Collections.singletonList(BasicDriveTest.createActiveFacet((FacetType)CommonFacetType.FOLDER, this.testFolder.getObjectID(), Filter.NO_FILTER)));
        BasicDriveTest.assertNull((String)"Folder type facet was returned", (Object)BasicDriveTest.findByType((FacetType)CommonFacetType.FOLDER_TYPE, facets));
    }

    public void testConflictsFolderFlag() throws Exception {
        List<Facet> facets = this.autocomplete("");
        Facet folderTypeFacet = BasicDriveTest.findByType((FacetType)CommonFacetType.FOLDER_TYPE, facets);
        BasicDriveTest.assertNotNull((String)"Missing folder type facet", (Object)folderTypeFacet);
        boolean found = false;
        String prefix = "conflicts:";
        for (String flag : folderTypeFacet.getFlags()) {
            int index = flag.indexOf(prefix);
            if (index <= -1 || !CommonFacetType.FOLDER.getId().equals(flag.substring(index + prefix.length()))) continue;
            found = true;
            break;
        }
        BasicDriveTest.assertTrue((String)"Flag not found", (boolean)found);
    }

    public void testDefaultColumnsAreEquivalentToListRequest() throws Exception {
        File.Field[] fields = new File.Field[]{File.Field.FOLDER_ID, File.Field.META, File.Field.ID, File.Field.LAST_MODIFIED, File.Field.TITLE, File.Field.FILENAME, File.Field.FILE_MIMETYPE, File.Field.FILE_SIZE, File.Field.LOCKED_UNTIL, File.Field.MODIFIED_BY};
        this.testWithFields(fields, false);
    }

    public void testWithExplicitColumns1() throws Exception {
        File.Field[] fields = new File.Field[]{File.Field.FOLDER_ID, File.Field.META, File.Field.ID, File.Field.LAST_MODIFIED, File.Field.TITLE, File.Field.FILENAME, File.Field.FILE_MIMETYPE, File.Field.FILE_SIZE, File.Field.LOCKED_UNTIL, File.Field.MODIFIED_BY};
        this.testWithFields(fields, true);
    }

    public void testWithExplicitColumns2() throws Exception {
        File.Field[] fields = new File.Field[]{File.Field.FOLDER_ID, File.Field.ID, File.Field.META, File.Field.LAST_MODIFIED, File.Field.TITLE, File.Field.FILENAME};
        this.testWithFields(fields, true);
    }

    private void testWithFields(File.Field[] fields, boolean withColumns) throws Exception {
        int[] columns = new int[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            columns[i] = fields[i].getNumber();
        }
        ListInfostoreRequest listRequest = new ListInfostoreRequest(columns);
        listRequest.addItem(new ListInfostoreRequest.ListItem(this.metadata));
        ListInfostoreResponse listResponse = this.client.execute(listRequest);
        Object[] listDocument = listResponse.getArray()[0];
        LinkedList<ActiveFacet> facets = new LinkedList<ActiveFacet>();
        facets.add(BasicDriveTest.createActiveFieldFacet((FacetType)DriveFacetType.FILE_NAME, "filename", SEARCH));
        facets.add(BasicDriveTest.createActiveFacet((FacetType)CommonFacetType.FOLDER, this.testFolder.getObjectID(), Filter.NO_FILTER));
        QueryRequest queryRequest = withColumns ? new QueryRequest(true, 0, 10, facets, null, Module.DRIVE.getIdentifier(), columns) : new QueryRequest(0, 10, facets, Module.DRIVE.getIdentifier());
        QueryResponse queryResponse = this.client.execute(queryRequest);
        PropDocument queryDocument = (PropDocument)queryResponse.getSearchResult().getDocuments().get(0);
        for (int i = 0; i < fields.length; ++i) {
            File.Field field = fields[i];
            Object listValue = listDocument[i];
            if (field == File.Field.META) {
                Map asMap = ((JSONObject)listValue).asMap();
                BasicDriveTest.assertTrue((boolean)asMap.equals(queryDocument.getProps().get(field.getName())));
                continue;
            }
            BasicDriveTest.assertEquals((String)("Unexpected value for field " + field.getName()), (Object)listValue, (Object)queryDocument.getProps().get(field.getName()));
        }
    }

    public void testConflictingFacetsCauseException() throws Exception {
        LinkedList<ActiveFacet> facets = new LinkedList<ActiveFacet>();
        facets.add(BasicDriveTest.createActiveFacet((FacetType)CommonFacetType.FOLDER, this.testFolder.getObjectID(), Filter.NO_FILTER));
        facets.add(BasicDriveTest.createFolderTypeFacet(FolderType.PRIVATE));
        AutocompleteRequest autocompleteRequest = new AutocompleteRequest("", Module.DRIVE.getIdentifier(), facets, null, false);
        AutocompleteResponse resp = this.client.execute(autocompleteRequest);
        BasicDriveTest.assertTrue((String)"Wrong exception", (boolean)FindExceptionCode.FACET_CONFLICT.equals(resp.getException()));
    }

    public void testTokenizedQuery() throws Exception {
        SimpleFacet globalFacet = (SimpleFacet)BasicDriveTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.DRIVE, "Test api"));
        List<PropDocument> documents = this.query(Module.DRIVE, Collections.singletonList(BasicDriveTest.createActiveFacet(globalFacet)));
        BasicDriveTest.assertTrue((String)"no document found", (0 < documents.size() ? 1 : 0) != 0);
        BasicDriveTest.assertNotNull((String)"document not found", (Object)BasicDriveTest.findByProperty(documents, "id", Integer.toString(this.metadata.getId())));
        globalFacet = (SimpleFacet)BasicDriveTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.DRIVE, "\"Test file for\""));
        documents = this.query(Module.DRIVE, Collections.singletonList(BasicDriveTest.createActiveFacet(globalFacet)));
        BasicDriveTest.assertTrue((String)"no document found", (0 < documents.size() ? 1 : 0) != 0);
        BasicDriveTest.assertNotNull((String)"document not found", (Object)BasicDriveTest.findByProperty(documents, "id", Integer.toString(this.metadata.getId())));
        globalFacet = (SimpleFacet)BasicDriveTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.DRIVE, "\"Test file murks\""));
        documents = this.query(Module.DRIVE, Collections.singletonList(BasicDriveTest.createActiveFacet(globalFacet)));
        BasicDriveTest.assertTrue((String)"document found", (0 == documents.size() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFolderTypeFacet() throws Exception {
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        try {
            FolderType[] typesInOrder = new FolderType[]{FolderType.PRIVATE, FolderType.PUBLIC, FolderType.SHARED};
            AJAXClient[] clients = new AJAXClient[]{this.client, this.client, client2};
            FolderObject[] folders = new FolderObject[]{this.folderManager.insertFolderOnServer(this.folderManager.generatePrivateFolder(BasicDriveTest.randomUID(), 8, this.client.getValues().getPrivateInfostoreFolder(), this.client.getValues().getUserId())), this.folderManager.insertFolderOnServer(this.folderManager.generatePublicFolder(BasicDriveTest.randomUID(), 8, 15, this.client.getValues().getUserId())), this.folderManager.insertFolderOnServer(this.folderManager.generateSharedFolder(BasicDriveTest.randomUID(), 8, this.client.getValues().getPrivateInfostoreFolder(), this.client.getValues().getUserId(), client2.getValues().getUserId()))};
            DocumentMetadata[] documents = new DocumentMetadata[3];
            documents[0] = new DocumentMetadataImpl(this.metadata);
            documents[0].setTitle(BasicDriveTest.randomUID());
            documents[0].setFolderId((long)folders[0].getObjectID());
            documents[1] = new DocumentMetadataImpl(this.metadata);
            documents[1].setTitle(BasicDriveTest.randomUID());
            documents[1].setFolderId((long)folders[1].getObjectID());
            documents[2] = new DocumentMetadataImpl(this.metadata);
            documents[2].setTitle(BasicDriveTest.randomUID());
            documents[2].setFolderId((long)folders[2].getObjectID());
            this.manager.newAction(documents[0]);
            this.manager.newAction(documents[1]);
            this.manager.newAction(documents[2]);
            block8: for (int i = 0; i < 3; ++i) {
                FolderType folderType = typesInOrder[i];
                List<Facet> facets = this.autocomplete(clients[i], "");
                ExclusiveFacet folderTypeFacet = (ExclusiveFacet)BasicDriveTest.findByType((FacetType)CommonFacetType.FOLDER_TYPE, facets);
                FacetValue typeValue = BasicDriveTest.findByValueId(folderType.getIdentifier(), (DefaultFacet)folderTypeFacet);
                List<PropDocument> docs = this.query(clients[i], Collections.singletonList(BasicDriveTest.createActiveFacet((DefaultFacet)folderTypeFacet, typeValue)));
                PropDocument[] foundDocs = new PropDocument[3];
                for (PropDocument doc : docs) {
                    Map<String, Object> props = doc.getProps();
                    if (documents[0].getTitle().equals(props.get("title"))) {
                        foundDocs[0] = doc;
                        continue;
                    }
                    if (documents[1].getTitle().equals(props.get("title"))) {
                        foundDocs[1] = doc;
                        continue;
                    }
                    if (!documents[2].getTitle().equals(props.get("title"))) continue;
                    foundDocs[2] = doc;
                }
                switch (folderType) {
                    case PRIVATE: {
                        BasicDriveTest.assertNotNull((String)"Private document not found", (Object)foundDocs[0]);
                        BasicDriveTest.assertNull((String)"Public document found but should not", (Object)foundDocs[1]);
                        BasicDriveTest.assertNotNull((String)"Shared document not found", (Object)foundDocs[2]);
                        continue block8;
                    }
                    case PUBLIC: {
                        BasicDriveTest.assertNull((String)"Private document found but should not", (Object)foundDocs[0]);
                        BasicDriveTest.assertNotNull((String)"Public document not found", (Object)foundDocs[1]);
                        BasicDriveTest.assertNull((String)"Shared document found but should not", (Object)foundDocs[2]);
                        continue block8;
                    }
                    case SHARED: {
                        BasicDriveTest.assertNull((String)"Private document found but should not", (Object)foundDocs[0]);
                        BasicDriveTest.assertNull((String)"Public document found but should not", (Object)foundDocs[1]);
                        BasicDriveTest.assertNotNull((String)"Shared document not found", (Object)foundDocs[2]);
                    }
                }
            }
        }
        finally {
            client2.logout();
        }
    }

    public void testDeletedFilesAreIgnored() throws Exception {
        FolderObject deletedFolder = this.folderManager.insertFolderOnServer(this.folderManager.generatePrivateFolder(BasicDriveTest.randomUID(), 8, this.client.getValues().getPrivateInfostoreFolder(), this.client.getValues().getUserId()));
        DocumentMetadataImpl deletedDocument = new DocumentMetadataImpl(this.metadata);
        deletedDocument.setTitle(BasicDriveTest.randomUID());
        deletedDocument.setFolderId((long)deletedFolder.getObjectID());
        this.manager.newAction((DocumentMetadata)deletedDocument);
        this.folderManager.deleteFolderOnServer(deletedFolder);
        FolderObject reloadedFolder = this.client.execute(new GetRequest((API)EnumAPI.OX_NEW, deletedFolder.getObjectID())).getFolder();
        FolderObject trashFolder = this.client.execute(new GetRequest((API)EnumAPI.OX_NEW, reloadedFolder.getParentFolderID())).getFolder();
        BasicDriveTest.assertEquals((String)"Wrong type", (int)16, (int)trashFolder.getType());
        List<Facet> autocompleteResponse = this.autocomplete(deletedDocument.getTitle());
        DefaultFacet folderTypeFacet = (DefaultFacet)BasicDriveTest.findByType((FacetType)CommonFacetType.FOLDER_TYPE, autocompleteResponse);
        ActiveFacet[] folderTypeFacets = new ActiveFacet[]{BasicDriveTest.createActiveFacet(folderTypeFacet, BasicDriveTest.findByValueId(FolderType.PRIVATE.getIdentifier(), folderTypeFacet)), BasicDriveTest.createActiveFacet(folderTypeFacet, BasicDriveTest.findByValueId(FolderType.PUBLIC.getIdentifier(), folderTypeFacet)), BasicDriveTest.createActiveFacet(folderTypeFacet, BasicDriveTest.findByValueId(FolderType.SHARED.getIdentifier(), folderTypeFacet))};
        ActiveFacet fileNameFacet = BasicDriveTest.createActiveFacet((SimpleFacet)BasicDriveTest.findByType((FacetType)DriveFacetType.FILE_NAME, autocompleteResponse));
        LinkedList<ActiveFacet> facets = new LinkedList<ActiveFacet>();
        facets.add(fileNameFacet);
        facets.add(BasicDriveTest.createActiveFacet((FacetType)CommonFacetType.FOLDER, reloadedFolder.getObjectID(), Filter.NO_FILTER));
        List<PropDocument> documents = this.query(this.client, facets);
        BasicDriveTest.assertEquals((String)"Wrong number of documents", (int)1, (int)documents.size());
        BasicDriveTest.assertEquals((String)"Wrong document", (String)deletedDocument.getTitle(), (String)((String)documents.get(0).getProps().get("title")));
        facets.clear();
        facets.add(fileNameFacet);
        documents = this.query(this.client, facets);
        BasicDriveTest.assertEquals((String)"Wrong number of documents", (int)0, (int)documents.size());
        for (int i = 0; i < 3; ++i) {
            facets.clear();
            facets.add(fileNameFacet);
            facets.add(folderTypeFacets[i]);
            documents = this.query(this.client, facets);
            BasicDriveTest.assertEquals((String)("Wrong number of documents. Document found in " + folderTypeFacets[i].getValueId() + " folder."), (int)0, (int)documents.size());
        }
    }

    protected List<Facet> autocomplete(AJAXClient client, String prefix) throws Exception {
        AutocompleteRequest autocompleteRequest = new AutocompleteRequest(prefix, Module.DRIVE.getIdentifier());
        AutocompleteResponse autocompleteResponse = client.execute(autocompleteRequest);
        return autocompleteResponse.getFacets();
    }

    protected List<PropDocument> query(AJAXClient client, List<ActiveFacet> facets) throws Exception {
        QueryRequest queryRequest = new QueryRequest(0, Integer.MAX_VALUE, facets, Module.DRIVE.getIdentifier());
        QueryResponse queryResponse = client.execute(queryRequest);
        SearchResult result = queryResponse.getSearchResult();
        ArrayList<PropDocument> propDocuments = new ArrayList<PropDocument>();
        List documents = result.getDocuments();
        for (Document document : documents) {
            propDocuments.add((PropDocument)document);
        }
        return propDocuments;
    }

    protected List<Facet> autocomplete(String prefix) throws Exception {
        return this.autocomplete(Module.DRIVE, prefix);
    }

    protected List<Facet> autocomplete(String prefix, List<ActiveFacet> facets) throws Exception {
        return this.autocomplete(Module.DRIVE, prefix, facets);
    }
}

