/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.find.actions.AbstractFindRequest;
import com.openexchange.ajax.find.actions.QueryResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.find.SearchResult;
import com.openexchange.find.facet.ActiveFacet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QueryRequest
extends AbstractFindRequest<QueryResponse> {
    private final boolean failOnError;
    private final int start;
    private final int size;
    private final List<ActiveFacet> activeFacets;
    private final String module;
    private final int[] columns;

    public QueryRequest(int start, int size, List<ActiveFacet> activeFacets, String module) {
        this(true, start, size, activeFacets, null, module, null);
    }

    public QueryRequest(int start, int size, List<ActiveFacet> activeFacets, String module, int[] columns) {
        this(true, start, size, activeFacets, null, module, columns);
    }

    public QueryRequest(boolean failOnError, int start, int size, List<ActiveFacet> activeFacets, Map<String, String> options, String module, int[] columns) {
        super(options);
        this.failOnError = failOnError;
        this.start = start;
        this.size = size;
        this.activeFacets = activeFacets;
        this.module = module;
        this.columns = columns;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        LinkedList<AJAXRequest.Parameter> list = new LinkedList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.Parameter("action", "query"));
        list.add(new AJAXRequest.Parameter("module", this.module));
        if (this.columns != null) {
            list.add(new AJAXRequest.Parameter("columns", this.columns));
        }
        return list.toArray(new AJAXRequest.Parameter[0]);
    }

    @Override
    public AbstractAJAXParser<? extends QueryResponse> getParser() {
        return new QueryParser(this.failOnError);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        JSONObject jBody = new JSONObject(3);
        this.addFacets(jBody, this.activeFacets);
        this.addOptions(jBody);
        if (0 < this.start) {
            jBody.put("start", this.start);
        }
        if (0 < this.size) {
            jBody.put("size", this.size);
        }
        return jBody;
    }

    private static class QueryParser
    extends AbstractAJAXParser<QueryResponse> {
        protected QueryParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected QueryResponse createResponse(Response response) throws JSONException {
            JSONObject jResponse = (JSONObject)response.getData();
            int numFound = jResponse.optInt("numFound", -1);
            int from = jResponse.optInt("from", -1);
            JSONArray jDocuments = jResponse.getJSONArray("results");
            int len = jDocuments.length();
            ArrayList<PropDocument> documents = new ArrayList<PropDocument>(len);
            for (int i = 0; i < len; ++i) {
                documents.add(new PropDocument(jDocuments.getJSONObject(i).asMap()));
            }
            return new QueryResponse(response, new SearchResult(numFound, from, documents, Collections.emptyList()));
        }
    }
}

