/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe;

import com.openexchange.subscribe.Asserts;
import com.openexchange.subscribe.SimSubscribeService;
import com.openexchange.subscribe.SubscribeService;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceCollector;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import java.util.List;
import junit.framework.TestCase;

public class SubscriptionSourceCollectorTest
extends TestCase {
    private SubscriptionSourceCollector collector;
    private List<SubscriptionSource> sources;
    private SubscribeService testService1;

    public void setUp() {
        this.collector = new SubscriptionSourceCollector();
        this.testService1 = this.service("com.openexchange.subscription.test1");
        this.collector.addSubscribeService(this.testService1);
        this.collector.addSubscribeService(this.service("com.openexchange.subscription.test2"));
        this.collector.addSubscribeService(this.serviceWithPriority("com.openexchange.subscription.test3", 2));
        this.collector.addSubscribeService(this.service("com.openexchange.subscription.test3"));
        this.collector.addSubscribeService(this.serviceHandlingNothing("com.openexchange.subscription.testHandlesNoFolder"));
    }

    public void testGetSources() {
        this.sources = this.collector.getSources(2);
        SubscriptionSourceCollectorTest.assertNotNull((String)"Sources was null!", this.sources);
        Asserts.assertSources(this.sources, "com.openexchange.subscription.test1", "com.openexchange.subscription.test2", "com.openexchange.subscription.test3");
        Asserts.assertPriority(this.sources, "com.openexchange.subscription.test3", 2);
    }

    public void testKnows() {
        Asserts.assertKnows((SubscriptionSourceDiscoveryService)this.collector, "com.openexchange.subscription.test1");
        Asserts.assertKnows((SubscriptionSourceDiscoveryService)this.collector, "com.openexchange.subscription.test2");
        Asserts.assertKnows((SubscriptionSourceDiscoveryService)this.collector, "com.openexchange.subscription.test3");
        Asserts.assertKnows((SubscriptionSourceDiscoveryService)this.collector, "com.openexchange.subscription.testHandlesNoFolder");
        Asserts.assertDoesNotKnow((SubscriptionSourceDiscoveryService)this.collector, "unknown");
    }

    public void testGet() {
        SubscriptionSourceCollectorTest.assertNotNull((String)"Missing com.openexchange.susbscription.test1", (Object)this.collector.getSource("com.openexchange.subscription.test1"));
        SubscriptionSourceCollectorTest.assertNotNull((String)"Missing com.openexchange.susbscription.test2", (Object)this.collector.getSource("com.openexchange.subscription.test2"));
        SubscriptionSourceCollectorTest.assertNotNull((String)"Missing com.openexchange.susbscription.test3", (Object)this.collector.getSource("com.openexchange.subscription.test3"));
        SubscriptionSourceCollectorTest.assertNotNull((String)"Missing com.openexchange.susbscription.testHandlesNoFolder", (Object)this.collector.getSource("com.openexchange.subscription.testHandlesNoFolder"));
        SubscriptionSourceCollectorTest.assertEquals((String)"Didn't remember subscribe service", (Object)this.testService1, (Object)this.collector.getSource("com.openexchange.subscription.test1").getSubscribeService());
        SubscriptionSourceCollectorTest.assertNull((String)"Got unknown?!?", (Object)this.collector.getSource("unknown"));
        Asserts.assertPriority(this.collector.getSource("com.openexchange.subscription.test3"), 2);
    }

    public void testRemove() {
        this.collector.removeSubscribeService("com.openexchange.subscription.test1");
        this.sources = this.collector.getSources(2);
        SubscriptionSourceCollectorTest.assertNotNull((String)"Sources was null!", this.sources);
        Asserts.assertSources(this.sources, "com.openexchange.subscription.test2", "com.openexchange.subscription.test3");
        Asserts.assertDoesNotKnow((SubscriptionSourceDiscoveryService)this.collector, "com.openexchange.subscription.test1");
        SubscriptionSourceCollectorTest.assertNull((String)"Didn't expect a source", (Object)this.collector.getSource("com.openexchange.subscription.test1"));
    }

    private SubscribeService serviceWithPriority(String string, int i) {
        SubscribeService service = this.service(string);
        service.getSubscriptionSource().setPriority(i);
        return service;
    }

    private SubscribeService service(String string) {
        SubscriptionSource source = new SubscriptionSource();
        source.setId(string);
        SimSubscribeService service = new SimSubscribeService();
        service.setSubscriptionSource(source);
        source.setSubscribeService((SubscribeService)service);
        return service;
    }

    private SubscribeService serviceHandlingNothing(String string) {
        SubscriptionSource source = new SubscriptionSource();
        source.setId(string);
        SimSubscribeService service = new SimSubscribeService(){

            @Override
            public boolean handles(int folderModule) {
                return false;
            }
        };
        service.setSubscriptionSource(source);
        return service;
    }
}

