/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.session;

import com.openexchange.annotation.NonNull;
import com.openexchange.annotation.Nullable;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.PutIfAbsent;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.tools.session.ServerSession;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSessionAdapter
implements ServerSession,
PutIfAbsent {
    private static final Logger LOG = LoggerFactory.getLogger(ServerSessionAdapter.class);
    private final Session session;
    private final ServerSession serverSession;
    private final Context context;
    private final User overwriteUser;
    private final UserConfiguration overwriteUserConfiguration;
    private final UserPermissionBits overwritePermissionBits;

    public static ServerSession valueOf(Session session) throws OXException {
        if (ServerSession.class.isInstance(session)) {
            return (ServerSession)session;
        }
        return null == session ? null : new ServerSessionAdapter(session);
    }

    public static ServerSession valueOf(Session session, Context context) {
        if (ServerSession.class.isInstance(session)) {
            return (ServerSession)session;
        }
        return null == session ? null : new ServerSessionAdapter(session, context);
    }

    public static ServerSession valueOf(Session session, Context context, User user) {
        if (ServerSession.class.isInstance(session)) {
            return (ServerSession)session;
        }
        return null == session ? null : new ServerSessionAdapter(session, context, user);
    }

    public static ServerSession valueOf(Session session, Context context, User user, UserConfiguration userConfiguration) {
        if (ServerSession.class.isInstance(session)) {
            return (ServerSession)session;
        }
        return null == session ? null : new ServerSessionAdapter(session, context, user, userConfiguration);
    }

    public static ServerSession valueOf(int userId, int contextId) throws OXException {
        return new ServerSessionAdapter(userId, contextId);
    }

    public ServerSessionAdapter(final int userId, final int contextId) throws OXException {
        this.context = contextId > 0 ? ContextStorage.getStorageContext(contextId) : null;
        this.overwriteUser = null;
        this.overwriteUserConfiguration = null;
        this.overwritePermissionBits = null;
        this.session = new SessionObject("synthetic"){

            @Override
            public int getUserId() {
                return userId;
            }

            @Override
            public int getContextId() {
                return contextId;
            }
        };
        this.serverSession = null;
    }

    public ServerSessionAdapter(Session session) throws OXException {
        Validate.notNull((Object)session, (String)"Session is null.");
        this.context = ContextStorage.getStorageContext(session.getContextId());
        this.overwriteUser = null;
        this.overwriteUserConfiguration = null;
        this.overwritePermissionBits = null;
        if (ServerSession.class.isInstance(session)) {
            this.serverSession = (ServerSession)session;
            this.session = null;
        } else {
            this.serverSession = null;
            this.session = session;
        }
    }

    public ServerSessionAdapter(Session session, Context ctx) {
        Validate.notNull((Object)session, (String)"Session is null.");
        Validate.notNull((Object)ctx, (String)"Context is null.");
        this.context = ctx;
        this.overwriteUser = null;
        this.overwriteUserConfiguration = null;
        this.overwritePermissionBits = null;
        if (ServerSession.class.isInstance(session)) {
            this.serverSession = (ServerSession)session;
            this.session = null;
        } else {
            this.serverSession = null;
            this.session = session;
        }
    }

    public ServerSessionAdapter(@NonNull Session session, @NonNull Context ctx, @Nullable User user) {
        Validate.notNull((Object)session, (String)"Session is null.");
        Validate.notNull((Object)ctx, (String)"Context is null.");
        this.context = ctx;
        this.overwriteUser = user;
        this.overwriteUserConfiguration = null;
        this.overwritePermissionBits = null;
        if (ServerSession.class.isInstance(session)) {
            this.serverSession = (ServerSession)session;
            this.session = null;
        } else {
            this.serverSession = null;
            this.session = session;
        }
    }

    public ServerSessionAdapter(@NonNull Session session, @NonNull Context ctx, @Nullable User user, @Nullable UserConfiguration userConfiguration) {
        Validate.notNull((Object)session, (String)"Session is null.");
        Validate.notNull((Object)ctx, (String)"Context is null.");
        this.context = ctx;
        this.overwriteUser = user;
        this.overwriteUserConfiguration = userConfiguration;
        this.overwritePermissionBits = null;
        if (ServerSession.class.isInstance(session)) {
            this.serverSession = (ServerSession)session;
            this.session = null;
        } else {
            this.serverSession = null;
            this.session = session;
        }
    }

    public ServerSessionAdapter(@NonNull Session session, @NonNull Context ctx, @Nullable User user, @Nullable UserConfiguration userConfiguration, @Nullable UserPermissionBits permissionBits) {
        Validate.notNull((Object)session, (String)"Session is null.");
        Validate.notNull((Object)ctx, (String)"Context is null.");
        this.context = ctx;
        this.overwriteUser = user;
        this.overwriteUserConfiguration = userConfiguration;
        this.overwritePermissionBits = permissionBits;
        if (ServerSession.class.isInstance(session)) {
            this.serverSession = (ServerSession)session;
            this.session = null;
        } else {
            this.serverSession = null;
            this.session = session;
        }
    }

    public int getContextId() {
        return this.session().getContextId();
    }

    public String getLocalIp() {
        return this.session().getLocalIp();
    }

    public void setLocalIp(String ip) {
        this.session().setLocalIp(ip);
    }

    public String getLoginName() {
        return this.session().getLoginName();
    }

    public boolean containsParameter(String name) {
        return this.session().containsParameter(name);
    }

    public Object getParameter(String name) {
        return this.session().getParameter(name);
    }

    public String getPassword() {
        return this.session().getPassword();
    }

    public String getRandomToken() {
        return this.session().getRandomToken();
    }

    public String getSecret() {
        return this.session().getSecret();
    }

    public String getSessionID() {
        return this.session().getSessionID();
    }

    public int getUserId() {
        return this.session().getUserId();
    }

    public String getUserlogin() {
        return this.session().getUserlogin();
    }

    public void setParameter(String name, Object value) {
        this.session().setParameter(name, value);
    }

    public Object setParameterIfAbsent(String name, Object value) {
        Session session = this.session();
        if (session instanceof PutIfAbsent) {
            return ((PutIfAbsent)session).setParameterIfAbsent(name, value);
        }
        Object prev = session.getParameter(name);
        if (null == prev) {
            session.setParameter(name, value);
            return null;
        }
        return prev;
    }

    public String getAuthId() {
        return this.session().getAuthId();
    }

    public String getLogin() {
        return this.session().getLogin();
    }

    public String getHash() {
        return this.session().getHash();
    }

    public String getClient() {
        return this.session().getClient();
    }

    public void setClient(String client) {
        this.session().setClient(client);
    }

    @Override
    public Context getContext() {
        if (this.serverSession != null) {
            return this.serverSession.getContext();
        }
        return this.context;
    }

    @Override
    public User getUser() {
        if (this.serverSession != null) {
            return this.serverSession.getUser();
        }
        if (null != this.overwriteUser) {
            return this.overwriteUser;
        }
        int userId = this.session.getUserId();
        if (userId <= 0) {
            return null;
        }
        try {
            return UserStorage.getInstance().getUser(userId, this.context);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public UserPermissionBits getUserPermissionBits() {
        int userId;
        if (this.serverSession != null) {
            return this.serverSession.getUserPermissionBits();
        }
        if (null != this.overwritePermissionBits) {
            return this.overwritePermissionBits;
        }
        int n = userId = null == this.overwriteUser ? this.session.getUserId() : this.overwriteUser.getId();
        if (userId <= 0) {
            return null;
        }
        try {
            return UserPermissionBitsStorage.getInstance().getUserPermissionBits(userId, this.context);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public UserConfiguration getUserConfiguration() {
        int userId;
        if (this.serverSession != null) {
            return this.serverSession.getUserConfiguration();
        }
        if (null != this.overwriteUserConfiguration) {
            return this.overwriteUserConfiguration;
        }
        int n = userId = null == this.overwriteUser ? this.session.getUserId() : this.overwriteUser.getId();
        if (userId <= 0) {
            return null;
        }
        try {
            return UserConfigurationStorage.getInstance().getUserConfiguration(userId, this.context);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public UserSettingMail getUserSettingMail() {
        int userId;
        if (this.serverSession != null) {
            return this.serverSession.getUserSettingMail();
        }
        int n = userId = null == this.overwriteUser ? this.session.getUserId() : this.overwriteUser.getId();
        if (userId <= 0) {
            return null;
        }
        return UserSettingMailStorage.getInstance().getUserSettingMail(userId, this.context);
    }

    private Session session() {
        return this.serverSession == null ? this.session : this.serverSession;
    }

    public void setHash(String hash) {
        this.session().setHash(hash);
    }

    @Override
    public boolean isAnonymous() {
        return this.session().getUserId() <= 0;
    }

    public String toString() {
        return this.session().toString();
    }

    public boolean isTransient() {
        return this.session().isTransient();
    }

    public int hashCode() {
        return this.session().hashCode();
    }

    public Set<String> getParameterNames() {
        return this.session().getParameterNames();
    }
}

