/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file;

import com.openexchange.exception.OXException;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.FileStreamAction;
import com.openexchange.tools.file.QuotaFileStorage;
import java.io.InputStream;

public class AppendFileAction
extends FileStreamAction {
    private final String fileStorageID;
    private final long offset;
    private long fileSize;

    public AppendFileAction(FileStorage storage, InputStream data, String fileStorageID, long sizeHint, long offset) {
        super(storage, data, sizeHint, false);
        this.fileStorageID = fileStorageID;
        this.offset = offset;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public String getFileStorageID() {
        return this.fileStorageID;
    }

    @Override
    protected void store(FileStorage storage, InputStream stream) throws OXException {
        this.fileSize = storage.appendToFile(stream, this.fileStorageID, this.offset);
    }

    @Override
    protected void store(QuotaFileStorage storage, InputStream stream, long sizeHint) throws OXException {
        this.fileSize = storage.appendToFile(stream, this.fileStorageID, this.offset, sizeHint);
    }

    @Override
    protected void undo(FileStorage storage) throws OXException {
        storage.setFileLength(this.offset, this.fileStorageID);
    }
}

