/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.java.Strings;
import com.openexchange.jslob.JSlobExceptionCodes;
import com.openexchange.jslob.storage.JSlobStorage;
import com.openexchange.jslob.storage.registry.JSlobStorageRegistry;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.api.MailProvider;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.utils.ProviderUtility;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.Tools;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.secret.SecretService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.net.URIParser;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMailAccountAction
implements AJAXActionService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMailAccountAction.class);
    public static final String JSLOB_SERVICE_ID = "com.openexchange.mailaccount";
    private static final AtomicReference<JSlobStorageRegistry> STORAGE_REGISTRY = new AtomicReference();
    private static final Pattern PAT = Pattern.compile(" *, *");

    protected AbstractMailAccountAction() {
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        try {
            Object data = requestData.getData();
            if (data instanceof JSONValue) {
                JSONValue jBody = (JSONValue)data;
                return this.innerPerform(requestData, session, jBody);
            }
            return this.innerPerform(requestData, session, null);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }

    protected abstract AJAXRequestResult innerPerform(AJAXRequestData var1, ServerSession var2, JSONValue var3) throws OXException, JSONException;

    public static void setJSlobStorageRegistry(JSlobStorageRegistry storageRegistry) {
        STORAGE_REGISTRY.set(storageRegistry);
    }

    public static JSlobStorage getStorage() throws OXException {
        JSlobStorageRegistry storageRegistry = STORAGE_REGISTRY.get();
        String storageId = "io.ox.wd.jslob.storage.db";
        JSlobStorage storage = storageRegistry.getJSlobStorage("io.ox.wd.jslob.storage.db");
        if (null == storage) {
            throw JSlobExceptionCodes.NOT_FOUND.create(new Object[]{"io.ox.wd.jslob.storage.db"});
        }
        return storage;
    }

    protected static String getDefaultTreeIdentifier() {
        return FolderStorage.REAL_TREE_ID;
    }

    protected static List<ContentType> getDefaultAllowedModules() {
        return Collections.emptyList();
    }

    protected static int parseIntParameter(String parameterName, AJAXRequestData request) throws OXException {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(parameterName);
        }
        return Tools.getUnsignedInteger(tmp);
    }

    protected static int[] parseIntArrayParameter(String parameterName, AJAXRequestData request) throws OXException {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(parameterName);
        }
        String[] sa = PAT.split(tmp, 0);
        int[] columns = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            columns[i] = Tools.getUnsignedInteger(sa[i]);
        }
        return columns;
    }

    protected static int[] parseOptionalIntArrayParameter(String parameterName, AJAXRequestData request) {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            return new int[0];
        }
        String[] sa = PAT.split(tmp, 0);
        int[] columns = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            columns[i] = Tools.getUnsignedInteger(sa[i]);
        }
        return columns;
    }

    protected static boolean isUnifiedINBOXAccount(MailAccount mailAccount) {
        return AbstractMailAccountAction.isUnifiedINBOXAccount(mailAccount.getMailProtocol());
    }

    protected static boolean isUnifiedINBOXAccount(String mailProtocol) {
        return UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(mailProtocol);
    }

    protected static void checkNeededFields(MailAccountDescription accountDescription) throws OXException {
        if (AbstractMailAccountAction.isEmpty(accountDescription.getMailServer())) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("mail_url");
        }
        if (AbstractMailAccountAction.isEmpty(accountDescription.getLogin())) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("login");
        }
        if (AbstractMailAccountAction.isEmpty(accountDescription.getPassword())) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("password");
        }
    }

    protected static String getSecret(ServerSession session) throws OXException {
        return ServerServiceRegistry.getInstance().getService(SecretService.class, true).getSecret((Session)session);
    }

    protected static boolean isDefaultMailAccount(MailAccount mailAccount) {
        return mailAccount.isDefaultAccount() || 0 == mailAccount.getId();
    }

    protected static boolean isDefaultMailAccount(MailAccountDescription mailAccount) {
        return 0 == mailAccount.getId();
    }

    protected static List<Attribute> getColumns(String colString) {
        LinkedList<Attribute> attributes = null;
        if (colString != null && !"".equals(colString.trim())) {
            attributes = new LinkedList<Attribute>();
            for (String col : colString.split("\\s*,\\s*")) {
                if ("".equals(col)) continue;
                attributes.add(Attribute.getById(Integer.parseInt(col)));
            }
            return attributes;
        }
        return Arrays.asList(Attribute.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> getMailAccess(MailAccountDescription accountDescription, ServerSession session, List<OXException> warnings) throws OXException {
        String mailServerURL = accountDescription.generateMailServerURL();
        MailProvider mailProvider = AbstractMailAccountAction.getMailProviderByURL(mailServerURL);
        if (null == mailProvider) {
            LOG.debug("Validating mail account failed. No mail provider found for URL: {}", (Object)mailServerURL);
            return null;
        }
        session.setParameter("mail-account.request", "validate");
        MailConfig mailConfig = null;
        try {
            URI uri;
            int accountId = accountDescription.getId();
            MailAccess<Object, Object> mailAccess = accountId >= 0 ? mailProvider.createNewMailAccess(session, accountId) : mailProvider.createNewMailAccess(session);
            mailConfig = mailAccess.getMailConfig();
            mailConfig.setLogin(accountDescription.getLogin());
            mailConfig.setPassword(accountDescription.getPassword());
            try {
                uri = URIParser.parse(mailServerURL, URIDefaults.IMAP);
            }
            catch (URISyntaxException e) {
                throw MailExceptionCode.URI_PARSE_FAILED.create(e, mailServerURL);
            }
            if (null != uri) {
                mailConfig.setServer(uri.getHost());
                mailConfig.setPort(uri.getPort());
            }
            mailConfig.setSecure(accountDescription.isMailSecure());
            mailAccess.setCacheable(false);
            MailAccess<Object, Object> mailAccess2 = mailAccess;
            return mailAccess2;
        }
        catch (OXException e) {
            if (null != mailConfig) {
                Throwable cause;
                for (cause = e.getCause(); null != cause && cause instanceof OXException; cause = cause.getCause()) {
                }
                if (null != cause) {
                    warnings.add(MailAccountExceptionCodes.VALIDATE_FAILED_TRANSPORT.create(cause, mailConfig.getServer(), mailConfig.getLogin()));
                }
            } else {
                e.setCategory(Category.CATEGORY_WARNING);
                warnings.add(e);
            }
        }
        finally {
            session.setParameter("mail-account.request", null);
        }
        return null;
    }

    private static MailProvider getMailProviderByURL(String serverUrl) {
        return MailProviderRegistry.getRealMailProvider(ProviderUtility.extractProtocol(serverUrl, MailProperties.getInstance().getDefaultMailProvider()));
    }

    protected static MailAccount checkFullNames(MailAccount account, MailAccountStorageService storageService, ServerSession session) throws OXException {
        return AbstractMailAccountAction.checkFullNames(account, storageService, session, null);
    }

    public static MailAccount checkFullNames(MailAccount account, MailAccountStorageService storageService, ServerSession session, Connection con) throws OXException {
        return Tools.checkFullNames(account, storageService, session, con);
    }

    protected static boolean isEmpty(String string) {
        return Strings.isEmpty((String)string);
    }
}

