/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.parser.handlers;

import com.openexchange.exception.OXException;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.parser.MailMessageHandler;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.uuencode.UUEncodedPart;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InlineContentHandler
implements MailMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(InlineContentHandler.class);
    private final int size;
    private final List<String> cids;
    private final Map<String, MailPart> inlineContents;
    private static final String IMAGE = "image/";

    public InlineContentHandler(List<String> cids) {
        this.size = cids.size();
        this.cids = cids;
        this.inlineContents = new HashMap<String, MailPart>(this.size);
    }

    private InlineContentHandler(List<String> cids, Map<String, MailPart> inlineContents) {
        this.size = cids.size();
        this.cids = cids;
        this.inlineContents = inlineContents;
    }

    public Map<String, MailPart> getInlineContents() {
        return this.inlineContents;
    }

    @Override
    public boolean handleMultipartEnd(MailPart mp, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleAttachment(MailPart part, boolean isInline, String baseContentType, String fileName, String id) throws OXException {
        if (part.getContentType().startsWith(IMAGE)) {
            String partCid = part.getContentId();
            if (partCid == null || partCid.length() == 0) {
                partCid = part.getFirstHeader(MessageHeaders.HDR_CONTENT_ID);
            }
            partCid = partCid == null ? "" : partCid;
            String realFilename = MimeMessageUtility.getRealFilename(part);
            String string = realFilename = realFilename == null ? "" : realFilename;
            if (partCid.length() == 0 && realFilename.length() == 0) {
                return true;
            }
            for (int i = 0; i < this.size; ++i) {
                String cid = this.cids.get(i);
                if (MimeMessageUtility.equalsCID(cid, partCid)) {
                    this.inlineContents.put(cid, part);
                    continue;
                }
                if (!MimeMessageUtility.equalsCID(cid, realFilename)) continue;
                this.inlineContents.put(cid, part);
            }
            if (this.inlineContents.size() >= this.size) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean handleBccRecipient(InternetAddress[] recipientAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleCcRecipient(InternetAddress[] recipientAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleColorLabel(int colorLabel) throws OXException {
        return true;
    }

    @Override
    public boolean handleContentId(String contentId) throws OXException {
        return true;
    }

    @Override
    public boolean handleDispositionNotification(InternetAddress dispositionNotificationTo, boolean seen) throws OXException {
        return true;
    }

    @Override
    public boolean handleFrom(InternetAddress[] fromAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleHeaders(int size, Iterator<Map.Entry<String, String>> iter) throws OXException {
        return true;
    }

    @Override
    public boolean handleImagePart(MailPart part, String imageCIDArg, String baseContentType, boolean isInline, String fileName, String id) throws OXException {
        String realFilename;
        String imageCID = imageCIDArg;
        if (imageCID == null) {
            imageCID = "";
        }
        String string = realFilename = (realFilename = MimeMessageUtility.getRealFilename(part)) == null ? "" : realFilename;
        if (imageCID.length() == 0 && realFilename.length() == 0) {
            return true;
        }
        for (int i = 0; i < this.size; ++i) {
            String cid = this.cids.get(i);
            if (MimeMessageUtility.equalsCID(cid, imageCID)) {
                this.inlineContents.put(cid, part);
                continue;
            }
            if (!MimeMessageUtility.equalsCID(cid, realFilename)) continue;
            this.inlineContents.put(cid, part);
        }
        return this.inlineContents.size() < this.size;
    }

    @Override
    public boolean handleInlineHtml(String htmlContent, ContentType contentType, long size, String fileName, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleInlinePlainText(String plainTextContent, ContentType contentType, long size, String fileName, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleInlineUUEncodedAttachment(UUEncodedPart part, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleInlineUUEncodedPlainText(String decodedTextContent, ContentType contentType, int size, String fileName, String id) throws OXException {
        return true;
    }

    @Override
    public void handleMessageEnd(MailMessage mail) throws OXException {
    }

    @Override
    public boolean handleMsgRef(String msgRef) throws OXException {
        return true;
    }

    @Override
    public boolean handleMultipart(MailPart mp, int bodyPartCount, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleNestedMessage(MailPart mailPart, String id) throws OXException {
        MailMessage nestedMail;
        Object content = mailPart.getContent();
        if (content instanceof MailMessage) {
            nestedMail = (MailMessage)content;
        } else if (content instanceof InputStream) {
            try {
                nestedMail = MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)content));
            }
            catch (MessagingException e) {
                throw MimeMailException.handleMessagingException(e);
            }
        } else {
            LOG.error("Ignoring nested message. Cannot handle part's content which should be a RFC822 message according to its content type: {}", (Object)(null == content ? "null" : content.getClass().getSimpleName()));
            return true;
        }
        InlineContentHandler handler = new InlineContentHandler(this.cids, this.inlineContents);
        new MailMessageParser().parseMailMessage(nestedMail, handler, id);
        return this.inlineContents.size() < this.size;
    }

    @Override
    public boolean handlePriority(int priority) throws OXException {
        return true;
    }

    @Override
    public boolean handleReceivedDate(Date receivedDate) throws OXException {
        return true;
    }

    @Override
    public boolean handleSentDate(Date sentDate) throws OXException {
        return true;
    }

    @Override
    public boolean handleSpecialPart(MailPart part, String baseContentType, String fileName, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleSubject(String subject) throws OXException {
        return true;
    }

    @Override
    public boolean handleSystemFlags(int flags) throws OXException {
        return true;
    }

    @Override
    public boolean handleToRecipient(InternetAddress[] recipientAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleUserFlags(String[] userFlags) throws OXException {
        return true;
    }
}

