/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.configuration.SystemConfig;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.config.MailReloadable;
import com.openexchange.mail.mime.MimeTypeFileLineParser;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MimeType2ExtMap {
    private static final Logger LOG = LoggerFactory.getLogger(MimeType2ExtMap.class);
    private static volatile ConcurrentMap<String, String> typeMap;
    private static volatile ConcurrentMap<String, List<String>> extMap;
    private static final String MIME_APPL_OCTET = "application/octet-stream";
    private static final String DEFAULT_EXT = "dat";
    private static final List<String> DEFAULT_EXTENSIONS;

    private MimeType2ExtMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void reset() {
        if (null == typeMap) return;
        Class<MimeType2ExtMap> clazz = MimeType2ExtMap.class;
        synchronized (MimeType2ExtMap.class) {
            if (null == typeMap) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            typeMap = null;
            extMap = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (null != typeMap) return;
        Class<MimeType2ExtMap> clazz = MimeType2ExtMap.class;
        synchronized (MimeType2ExtMap.class) {
            if (null != typeMap) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                ConfigurationService service;
                File file;
                URL url;
                String javaHome;
                File file2;
                typeMap = new ConcurrentHashMap<String, String>(1024);
                extMap = new ConcurrentHashMap<String, List<String>>(1024);
                StringBuilder sb = new StringBuilder(128);
                boolean debugEnabled = LOG.isDebugEnabled();
                String homeDir = System.getProperty("user.home");
                if (homeDir != null && (file2 = new File(sb.append(homeDir).append(File.separatorChar).append(".mime.types").toString())).exists()) {
                    if (debugEnabled) {
                        sb.setLength(0);
                        LOG.debug(sb.append("Loading MIME type file \"").append(file2.getPath()).append('\"').toString());
                    }
                    MimeType2ExtMap.loadInternal(file2);
                }
                if ((javaHome = System.getProperty("java.home")) != null) {
                    sb.setLength(0);
                    file2 = new File(sb.append(javaHome).append(File.separatorChar).append("lib").append(File.separator).append("mime.types").toString());
                    if (file2.exists()) {
                        if (debugEnabled) {
                            sb.setLength(0);
                            LOG.debug(sb.append("Loading MIME type file \"").append(file2.getPath()).append('\"').toString());
                        }
                        MimeType2ExtMap.loadInternal(file2);
                    }
                }
                Enumeration<URL> e = ClassLoader.getSystemResources("META-INF/mime.types");
                while (e.hasMoreElements()) {
                    url = e.nextElement();
                    if (debugEnabled) {
                        sb.setLength(0);
                        LOG.debug(sb.append("Loading MIME type file \"").append(url.getFile()).append('\"').toString());
                    }
                    MimeType2ExtMap.loadInternal(url);
                }
                e = ClassLoader.getSystemResources("META-INF/mimetypes.default");
                while (e.hasMoreElements()) {
                    url = e.nextElement();
                    if (debugEnabled) {
                        sb.setLength(0);
                        LOG.debug(sb.append("Loading MIME type file \"").append(url.getFile()).append('\"').toString());
                    }
                    MimeType2ExtMap.loadInternal(url);
                }
                String mimeTypesFileName = SystemConfig.getProperty(SystemConfig.Property.MimeTypeFileName);
                if (mimeTypesFileName != null && (mimeTypesFileName = mimeTypesFileName.trim()).length() > 0 && (file = (service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class)).getFileByName(mimeTypesFileName)).exists()) {
                    if (debugEnabled) {
                        sb.setLength(0);
                        LOG.debug(sb.append("Loading MIME type file \"").append(file.getPath()).append('\"').toString());
                    }
                    MimeType2ExtMap.loadInternal(file);
                }
                LOG.debug("MIMEType2ExtMap successfully initialized");
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
            }
            return;
        }
    }

    public static void addMimeType(String mimeType, String fileExtension) {
        MimeType2ExtMap.addMimeType(mimeType, Collections.singletonList(fileExtension));
    }

    public static void addMimeType(String mimeType, List<String> fileExtensions) {
        CopyOnWriteArrayList<String> nl;
        MimeType2ExtMap.init();
        ConcurrentMap<String, String> tm = typeMap;
        for (String ext : fileExtensions) {
            tm.put(ext, mimeType);
        }
        ConcurrentMap<String, List<String>> em = extMap;
        CopyOnWriteArrayList<String> list = (CopyOnWriteArrayList<String>)em.get(mimeType);
        if (null == list && null == (list = (List)em.putIfAbsent(mimeType, nl = new CopyOnWriteArrayList<String>()))) {
            list = nl;
        }
        list.add(mimeType);
    }

    public static String getContentType(File file) {
        return MimeType2ExtMap.getContentType(file.getName(), MIME_APPL_OCTET);
    }

    public static String getContentType(File file, String fallBack) {
        return MimeType2ExtMap.getContentType(file.getName(), fallBack);
    }

    public static String getContentType(String fileName) {
        return MimeType2ExtMap.getContentType(fileName, MIME_APPL_OCTET);
    }

    public static String getContentType(String fileName, String fallBack) {
        MimeType2ExtMap.init();
        if (Strings.isEmpty((String)fileName)) {
            return fallBack;
        }
        String fn = Strings.unquote((String)fileName);
        int pos = fn.lastIndexOf(46);
        if (pos < 0) {
            return fallBack;
        }
        String s1 = fn.substring(pos + 1);
        if (s1.length() == 0) {
            return fallBack;
        }
        String type = (String)typeMap.get(Strings.toLowerCase((CharSequence)s1));
        return null == type ? fallBack : type;
    }

    public static String getContentTypeByExtension(String extension) {
        return MimeType2ExtMap.getContentTypeByExtension(extension, MIME_APPL_OCTET);
    }

    public static String getContentTypeByExtension(String extension, String fallBack) {
        MimeType2ExtMap.init();
        if (Strings.isEmpty((String)extension)) {
            return fallBack;
        }
        String type = (String)typeMap.get(Strings.toLowerCase((CharSequence)extension));
        return null == type ? fallBack : type;
    }

    public static List<String> getFileExtensions(String mimeType) {
        MimeType2ExtMap.init();
        if (Strings.isEmpty((String)mimeType)) {
            return DEFAULT_EXTENSIONS;
        }
        if (!extMap.containsKey(Strings.toLowerCase((CharSequence)mimeType))) {
            return DEFAULT_EXTENSIONS;
        }
        List list = (List)extMap.get(mimeType);
        return null == list ? DEFAULT_EXTENSIONS : Collections.unmodifiableList(list);
    }

    public static String getFileExtension(String mimeType) {
        return MimeType2ExtMap.getFileExtension(mimeType, DEFAULT_EXT);
    }

    public static String getFileExtension(String mimeType, String defaultExt) {
        MimeType2ExtMap.init();
        if (Strings.isEmpty((String)mimeType)) {
            return defaultExt;
        }
        if (!extMap.containsKey(Strings.toLowerCase((CharSequence)mimeType))) {
            return defaultExt;
        }
        List list = (List)extMap.get(mimeType);
        return null == list || list.isEmpty() ? defaultExt : (String)list.get(0);
    }

    public static void load(String fileStr) {
        MimeType2ExtMap.init();
        MimeType2ExtMap.load(new File(fileStr));
    }

    public static void load(File file) {
        MimeType2ExtMap.init();
        MimeType2ExtMap.loadInternal(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadInternal(File file) {
        FileInputStream stream = null;
        BufferedReader reader = null;
        try {
            stream = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader((InputStream)stream, Charsets.ISO_8859_1));
            MimeType2ExtMap.parse(reader);
        }
        catch (Exception e) {
            try {
                LOG.error("", (Throwable)e);
            }
            catch (Throwable throwable) {
                Streams.close((Closeable[])new Closeable[]{reader, stream});
                throw throwable;
            }
            Streams.close((Closeable[])new Closeable[]{reader, stream});
        }
        Streams.close((Closeable[])new Closeable[]{reader, stream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadInternal(URL url) {
        InputStream stream = null;
        BufferedReader reader = null;
        try {
            stream = url.openStream();
            reader = new BufferedReader(new InputStreamReader(stream, Charsets.ISO_8859_1));
            MimeType2ExtMap.parse(reader);
        }
        catch (Exception e) {
            try {
                LOG.error("", (Throwable)e);
            }
            catch (Throwable throwable) {
                Streams.close((Closeable[])new Closeable[]{reader, stream});
                throw throwable;
            }
            Streams.close((Closeable[])new Closeable[]{reader, stream});
        }
        Streams.close((Closeable[])new Closeable[]{reader, stream});
    }

    private static void parse(BufferedReader reader) throws IOException {
        String line = null;
        StringBuilder strBuilder = new StringBuilder(64);
        while ((line = reader.readLine()) != null) {
            int i = strBuilder.length();
            strBuilder.append(line);
            if (i > 0 && strBuilder.charAt(i - 1) == '\\') {
                strBuilder.delete(0, i - 1);
                continue;
            }
            MimeType2ExtMap.parseEntry(strBuilder.toString().trim());
            strBuilder.setLength(0);
        }
        if (strBuilder.length() > 0) {
            MimeType2ExtMap.parseEntry(strBuilder.toString().trim());
        }
    }

    private static void parseEntry(String entry) {
        if (entry.length() == 0) {
            return;
        }
        if (entry.charAt(0) == '#') {
            return;
        }
        ConcurrentMap<String, List<String>> extMap = MimeType2ExtMap.extMap;
        ConcurrentMap<String, String> typeMap = MimeType2ExtMap.typeMap;
        if (entry.indexOf(61) > 0) {
            MimeTypeFileLineParser parser = new MimeTypeFileLineParser(entry);
            String type = parser.getType();
            List<String> exts = parser.getExtensions();
            if (type != null && exts != null) {
                for (String ext : exts) {
                    typeMap.put(ext, type);
                }
                if (extMap.containsKey(type)) {
                    ((List)extMap.get(type)).addAll(exts);
                } else {
                    extMap.put(type, exts);
                }
            }
        } else {
            String[] tokens = entry.split("[ \t\n\r\f]+");
            if (tokens.length > 1) {
                String type = Strings.toLowerCase((CharSequence)tokens[0]);
                CopyOnWriteArrayList<String> set = new CopyOnWriteArrayList<String>();
                for (int i = 1; i < tokens.length; ++i) {
                    String ext = Strings.toLowerCase((CharSequence)tokens[i]);
                    set.add(ext);
                    typeMap.put(ext, type);
                }
                if (extMap.containsKey(type)) {
                    ((List)extMap.get(type)).addAll(set);
                } else {
                    extMap.put(type, set);
                }
            }
        }
    }

    static {
        MailReloadable.getInstance().addReloadable(new Reloadable(){

            public void reloadConfiguration(ConfigurationService configService) {
                MimeType2ExtMap.reset();
                MimeType2ExtMap.init();
            }

            public Map<String, String[]> getConfigFileNames() {
                return null;
            }
        });
        DEFAULT_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(DEFAULT_EXT));
    }
}

