/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.osgi;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXResultDecorator;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.osgiservice.AJAXModuleActivator;
import com.openexchange.capabilities.CapabilityChecker;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.config.Reloadable;
import com.openexchange.contact.ContactService;
import com.openexchange.contact.SortOptions;
import com.openexchange.contact.storage.ContactStorage;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.datasource.ContactImageDataSource;
import com.openexchange.groupware.contact.datasource.UserImageDataSource;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.image.ImageLocation;
import com.openexchange.mail.attachment.storage.DefaultMailAttachmentStorage;
import com.openexchange.mail.attachment.storage.DefaultMailAttachmentStorageRegistry;
import com.openexchange.mail.attachment.storage.MailAttachmentStorage;
import com.openexchange.mail.attachment.storage.MailAttachmentStorageRegistry;
import com.openexchange.mail.compose.CompositionSpace;
import com.openexchange.mail.config.MailReloadable;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailActionFactory;
import com.openexchange.mail.json.converters.MailConverter;
import com.openexchange.mail.json.converters.MailJSONConverter;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mail.transport.config.TransportReloadable;
import com.openexchange.server.ExceptionOnAbsenceServiceLookup;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.mail.internet.InternetAddress;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailJSONActivator
extends AJAXModuleActivator {
    protected static final Logger LOG = LoggerFactory.getLogger(MailJSONActivator.class);
    public static final AtomicReference<ServiceLookup> SERVICES = new AtomicReference();

    protected Class<?>[] getNeededServices() {
        return new Class[]{ContactService.class, ContactStorage.class};
    }

    protected void startBundle() throws Exception {
        ExceptionOnAbsenceServiceLookup serviceLookup = new ExceptionOnAbsenceServiceLookup((ServiceLookup)this);
        SERVICES.set((ServiceLookup)serviceLookup);
        final BundleContext context = this.context;
        this.track(CapabilityService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<CapabilityService, CapabilityService>(){
            private volatile ServiceRegistration<CapabilityChecker> serviceRegistration;

            public CapabilityService addingService(ServiceReference<CapabilityService> reference) {
                CapabilityService service = (CapabilityService)context.getService(reference);
                String sCapability = "publish_mail_attachments";
                Hashtable<String, String> properties = new Hashtable<String, String>(2);
                ((Dictionary)properties).put("capabilities", "publish_mail_attachments");
                CapabilityChecker capabilityChecker = new CapabilityChecker(){

                    public boolean isEnabled(String capability, Session ses) throws OXException {
                        if ("publish_mail_attachments".equals(capability)) {
                            ServerSession session = ServerSessionAdapter.valueOf(ses);
                            if (session.isAnonymous()) {
                                return false;
                            }
                            return TransportProperties.getInstance().isPublishOnExceededQuota();
                        }
                        return true;
                    }
                };
                this.serviceRegistration = context.registerService(CapabilityChecker.class, (Object)capabilityChecker, properties);
                service.declareCapability("publish_mail_attachments");
                return service;
            }

            public void modifiedService(ServiceReference<CapabilityService> reference, CapabilityService service) {
            }

            public void removedService(ServiceReference<CapabilityService> reference, CapabilityService service) {
                ServiceRegistration<CapabilityChecker> serviceRegistration = this.serviceRegistration;
                if (null != serviceRegistration) {
                    serviceRegistration.unregister();
                    this.serviceRegistration = null;
                }
                context.ungetService(reference);
            }
        });
        this.openTrackers();
        DefaultMailAttachmentStorageRegistry.initInstance(context);
        this.registerService(MailAttachmentStorageRegistry.class, DefaultMailAttachmentStorageRegistry.getInstance());
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>(2);
        ((Dictionary)properties).put("service.ranking", 0);
        this.registerService(MailAttachmentStorage.class, new DefaultMailAttachmentStorage(), properties);
        String topicRemoveSession = "com/openexchange/sessiond/remove/session";
        String topicRemoveContainer = "com/openexchange/sessiond/remove/container";
        String topicRemoveData = "com/openexchange/sessiond/remove/data";
        EventHandler eventHandler = new EventHandler(){

            public void handleEvent(Event event) {
                String topic = event.getTopic();
                if ("com/openexchange/sessiond/remove/session".equals(topic)) {
                    this.handleSession((Session)event.getProperty("com.openexchange.sessiond.session"));
                } else if ("com/openexchange/sessiond/remove/container".equals(topic) || "com/openexchange/sessiond/remove/data".equals(topic)) {
                    Map sessions = (Map)event.getProperty("com.openexchange.sessiond.container");
                    for (Session session : sessions.values()) {
                        this.handleSession(session);
                    }
                }
            }

            private void handleSession(Session session) {
                CompositionSpace.dropCompositionSpaces(session);
            }
        };
        Hashtable<String, String[]> props = new Hashtable<String, String[]>(2);
        ((Dictionary)props).put("event.topics", new String[]{"com/openexchange/sessiond/remove/session", "com/openexchange/sessiond/remove/container", "com/openexchange/sessiond/remove/data"});
        this.registerService(EventHandler.class, eventHandler, props);
        this.registerModule(new MailActionFactory((ServiceLookup)serviceLookup), "mail");
        MailConverter converter = MailConverter.getInstance();
        this.registerService(ResultConverter.class, converter);
        this.registerService(ResultConverter.class, new MailJSONConverter(converter));
        this.registerService(Reloadable.class, MailReloadable.getInstance());
        this.registerService(Reloadable.class, TransportReloadable.getInstance());
        ContactField[] fields = new ContactField[]{ContactField.OBJECT_ID, ContactField.INTERNAL_USERID, ContactField.FOLDER_ID, ContactField.NUMBER_OF_IMAGES};
        this.registerService(AJAXResultDecorator.class, new DecoratorImpl(converter, fields));
    }

    protected void stopBundle() throws Exception {
        super.stopBundle();
        DefaultMailAttachmentStorageRegistry.dropInstance();
        SERVICES.set(null);
    }

    private final class DecoratorImpl
    implements AJAXResultDecorator {
        private final MailConverter converter;
        private final ContactField[] fields;

        protected DecoratorImpl(MailConverter converter, ContactField[] fields) {
            this.converter = converter;
            this.fields = fields;
        }

        @Override
        public String getIdentifier() {
            return "mail.senderImageUrl";
        }

        @Override
        public String getFormat() {
            return "mail";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void decorate(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException {
            Object resultObject = result.getResultObject();
            if (null == resultObject) {
                LOG.warn("Result object is null.");
                result.setResultObject(JSONObject.NULL, "json");
                return;
            }
            String action = requestData.getAction();
            if ("get".equals(action) && resultObject instanceof MailMessage) {
                try {
                    MailMessage mailMessage = (MailMessage)resultObject;
                    InternetAddress[] from = mailMessage.getFrom();
                    if (null == from || 0 == from.length) {
                        return;
                    }
                    SearchIterator<Contact> searchIterator = null;
                    String imageURL = null;
                    try {
                        searchIterator = ((ContactService)MailJSONActivator.this.getService(ContactService.class)).searchContacts((Session)session, this.createContactSearchObject(from[0]), this.fields, new SortOptions(ContactField.FOLDER_ID, Order.ASCENDING));
                        if (null != searchIterator) {
                            while (null == imageURL && searchIterator.hasNext()) {
                                Contact contact = (Contact)searchIterator.next();
                                imageURL = this.getImageURL(session, contact);
                            }
                        }
                    }
                    finally {
                        if (null != searchIterator) {
                            searchIterator.close();
                        }
                    }
                    this.converter.convert2JSON(requestData, result, session);
                    JSONArray fromImageURLs = new JSONArray();
                    if (null != imageURL) {
                        fromImageURLs.put((Object)imageURL);
                    }
                    ((JSONObject)result.getResultObject()).put("from_image_urls", (Object)fromImageURLs);
                }
                catch (JSONException e) {
                    throw OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]);
                }
            }
        }

        private String getImageURL(ServerSession session, Contact contact) {
            if (0 < contact.getNumberOfImages() || contact.containsImage1() && null != contact.getImage1()) {
                String timestamp = null != contact.getLastModified() ? String.valueOf(contact.getLastModified().getTime()) : null;
                try {
                    if (6 == contact.getParentFolderID() && contact.containsInternalUserId()) {
                        ImageLocation imageLocation = new ImageLocation.Builder().id(String.valueOf(contact.getInternalUserId())).timestamp(timestamp).build();
                        return UserImageDataSource.getInstance().generateUrl(imageLocation, session);
                    }
                    ImageLocation imageLocation = new ImageLocation.Builder().folder(String.valueOf(contact.getParentFolderID())).id(String.valueOf(contact.getObjectID())).timestamp(timestamp).build();
                    return ContactImageDataSource.getInstance().generateUrl(imageLocation, session);
                }
                catch (OXException e) {
                    LOG.warn("Error generating contact image URL", (Throwable)e);
                }
            }
            return null;
        }

        private ContactSearchObject createContactSearchObject(InternetAddress from) {
            ContactSearchObject searchObject = new ContactSearchObject();
            searchObject.setOrSearch(true);
            String address = from.getAddress();
            searchObject.setEmail1(address);
            searchObject.setEmail2(address);
            searchObject.setEmail3(address);
            return searchObject;
        }
    }
}

