/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.event;

import com.openexchange.concurrent.Blocker;
import com.openexchange.concurrent.ConcurrentBlocker;
import com.openexchange.exception.OXException;
import com.openexchange.mail.event.PooledEvent;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventPool
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(EventPool.class);
    static final long MSEC_DELAY = 10000L;
    private static final long MIN_TASK_DELAY = 5000L;
    private static volatile EventPool instance;
    private final Blocker blocker;
    private volatile ScheduledTimerTask timerTask;
    private final ConcurrentMap<PooledEvent, PooledEvent> map = new ConcurrentHashMap<PooledEvent, PooledEvent>(1024);
    private final DelayQueue<PooledEvent> queue = new DelayQueue();
    private final EventAdmin eventAdmin;
    private static final Set<String> RESERVED_NAMES;

    public static synchronized void initInstance() {
        if (null == instance) {
            try {
                instance = new EventPool();
                instance.startup();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    public static synchronized void releaseInstance() {
        if (null != instance) {
            instance.shutdown();
            instance = null;
        }
    }

    public static EventPool getInstance() {
        return instance;
    }

    private EventPool() throws OXException {
        this.blocker = new ConcurrentBlocker();
        this.eventAdmin = ServerServiceRegistry.getInstance().getService(EventAdmin.class, true);
    }

    private void startup() {
        if (null == this.timerTask) {
            TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
            if (null == timer) {
                this.timerTask = null;
            } else {
                long calDelay = 2000L;
                this.timerTask = timer.scheduleWithFixedDelay((Runnable)this, 1000L, 5000L);
            }
        }
    }

    private void shutdown() {
        ScheduledTimerTask timerTask = this.timerTask;
        if (null != timerTask) {
            timerTask.cancel(false);
            this.timerTask = null;
            this.map.clear();
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByUser(int userId, int contextId) {
        this.blocker.acquire();
        try {
            Iterator<PooledEvent> queueIter = this.queue.iterator();
            while (queueIter.hasNext()) {
                PooledEvent pooledEvent = queueIter.next();
                if (!pooledEvent.equalsByUser(userId, contextId)) continue;
                this.map.remove(pooledEvent);
                queueIter.remove();
            }
        }
        finally {
            this.blocker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(PooledEvent pooledEvent) {
        if (null == this.timerTask || 0L >= pooledEvent.getDelay(TimeUnit.MILLISECONDS)) {
            this.broadcastEvent(pooledEvent);
        } else {
            this.blocker.acquire();
            try {
                PooledEvent prev = this.map.putIfAbsent(pooledEvent, pooledEvent);
                if (null == prev) {
                    this.queue.offer(pooledEvent);
                } else {
                    prev.touch();
                }
            }
            finally {
                this.blocker.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.blocker.acquire();
        try {
            this.queue.clear();
            this.map.clear();
        }
        finally {
            this.blocker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.blocker.block();
        try {
            PooledEvent pooledEvent = (PooledEvent)this.queue.poll();
            if (pooledEvent != null) {
                do {
                    this.map.remove(pooledEvent);
                    this.broadcastEvent(pooledEvent);
                } while ((pooledEvent = (PooledEvent)this.queue.poll()) != null);
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(EventPool.class).error("", t);
        }
        finally {
            this.blocker.unblock();
        }
    }

    private void broadcastEvent(PooledEvent pooledEvent) {
        String topic;
        Map<String, Object> moreProps;
        Hashtable<String, Object> properties = new Hashtable<String, Object>(6);
        ((Dictionary)properties).put("com.openexchange.push.context", pooledEvent.getContextId());
        ((Dictionary)properties).put("com.openexchange.push.user", pooledEvent.getUserId());
        ((Dictionary)properties).put("com.openexchange.push.session", pooledEvent.getSession());
        ((Dictionary)properties).put("com.openexchange.push.folder", MailFolderUtility.prepareFullname(pooledEvent.getAccountId(), pooledEvent.getFullname()));
        ((Dictionary)properties).put("com.openexchange.push.content-related", pooledEvent.isContentRelated());
        if (pooledEvent.isRemote()) {
            ((Dictionary)properties).put("__publishRemote", Boolean.TRUE);
        }
        if (null != (moreProps = pooledEvent.getProperties()) && !moreProps.isEmpty()) {
            Set<String> reservedNames = RESERVED_NAMES;
            for (Map.Entry<String, Object> entry : moreProps.entrySet()) {
                String name = entry.getKey();
                if (reservedNames.contains(name)) continue;
                ((Dictionary)properties).put(name, entry.getValue());
            }
        }
        Event event = new Event(null == (topic = pooledEvent.getTopic()) ? "com/openexchange/push" : topic, properties);
        if (pooledEvent.isAsync()) {
            this.eventAdmin.postEvent(event);
        } else {
            this.eventAdmin.sendEvent(event);
        }
        LOG.debug("{}Notified {}-wise changed folder \"{}\" in account {} of user {} in context {}", new Object[]{pooledEvent.isRemote() ? "(Remotely) " : "", pooledEvent.isContentRelated() ? "content-related" : "hierarchical", pooledEvent.getFullname(), pooledEvent.getAccountId(), pooledEvent.getUserId(), pooledEvent.getContextId()});
    }

    static {
        RESERVED_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("com.openexchange.push.context", "com.openexchange.push.content-related", "com.openexchange.push.folder", "com.openexchange.push.immediately", "com.openexchange.push.session", "com.openexchange.push.user", "__publishRemote")));
    }
}

