/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.api;

import com.openexchange.exception.OXException;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.processing.MimeForward;
import com.openexchange.mail.mime.processing.MimeReply;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.session.Session;

public class MailLogicTools {
    protected final Session session;
    protected final int accountId;

    public MailLogicTools(Session session, int accountId) {
        this.session = session;
        this.accountId = accountId;
    }

    public MailMessage getReplyMessage(MailMessage originalMail, boolean replyAll) throws OXException {
        return this.getReplyMessage(originalMail, replyAll, false);
    }

    public MailMessage getReplyMessage(MailMessage originalMail, boolean replyAll, boolean setFrom) throws OXException {
        return MimeReply.getReplyMail(originalMail, replyAll, this.session, this.accountId, setFrom);
    }

    public MailMessage getReplyMessage(MailMessage originalMail, boolean replyAll, UserSettingMail usm) throws OXException {
        return this.getReplyMessage(originalMail, replyAll, usm, false);
    }

    public MailMessage getReplyMessage(MailMessage originalMail, boolean replyAll, UserSettingMail usm, boolean setFrom) throws OXException {
        return MimeReply.getReplyMail(originalMail, replyAll, this.session, this.accountId, usm, setFrom);
    }

    public MailMessage getFowardMessage(MailMessage[] originalMails) throws OXException {
        return MimeForward.getFowardMail(originalMails, this.session, this.accountId);
    }

    public MailMessage getFowardMessage(MailMessage[] originalMails, UserSettingMail usm) throws OXException {
        return MimeForward.getFowardMail(originalMails, this.session, this.accountId, usm);
    }
}

