/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.api2.MailInterfaceMonitor;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.groupware.importexport.MailImportResult;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailServletInterfaceImpl;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.transport.MtaStatusInfo;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.search.SearchTerm;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;

public abstract class MailServletInterface
implements Closeable {
    public static final int QUOTA_RESOURCE_STORAGE = 1;
    public static final int QUOTA_RESOURCE_MESSAGE = 2;
    public static final MailInterfaceMonitor mailInterfaceMonitor = new MailInterfaceMonitor();

    public static final MailServletInterface getInstance(Session session) throws OXException {
        return new MailServletInterfaceImpl(session);
    }

    public static String saneForFileName(String subject) {
        if (Strings.isEmpty((String)subject)) {
            return subject;
        }
        int len = subject.length();
        StringBuilder sb = new StringBuilder(len);
        char prev = '\u0000';
        block3: for (int i = 0; i < len; ++i) {
            char c = subject.charAt(i);
            if (Strings.isWhitespace((char)c)) {
                if (prev == '_') continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            switch (c) {
                case '\"': 
                case '%': 
                case '*': 
                case '.': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    if (prev == 95) continue block3;
                    prev = '_';
                    sb.append(prev);
                    continue block3;
                }
                default: {
                    prev = '\u0000';
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    protected MailServletInterface() {
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public abstract String getMailIDByMessageID(String var1, String var2) throws OXException;

    public abstract int[] getAllMessageCount(String var1) throws OXException;

    public abstract int getMessageCount(String var1) throws OXException;

    public abstract int getNewMessageCount(String var1) throws OXException;

    public abstract int getUnreadMessageCount(String var1) throws OXException;

    public abstract int getDeletedMessageCount(String var1) throws OXException;

    public abstract long[][] getQuotas(int[] var1) throws OXException;

    public abstract long getQuotaLimit(int var1) throws OXException;

    public abstract long getQuotaUsage(int var1) throws OXException;

    public abstract SearchIterator<MailMessage> getNewMessages(String var1, int var2, int var3, int[] var4, int var5) throws OXException;

    public abstract SearchIterator<MailMessage> getAllMessages(String var1, int var2, int var3, int[] var4, int[] var5, boolean var6) throws OXException;

    public abstract SearchIterator<MailMessage> getMessages(String var1, int[] var2, int var3, int var4, int[] var5, String[] var6, boolean var7, int[] var8, boolean var9) throws OXException;

    public abstract SearchIterator<MailMessage> getMessages(String var1, int[] var2, int var3, int var4, SearchTerm<?> var5, boolean var6, int[] var7, boolean var8) throws OXException;

    public abstract SearchIterator<MailMessage> getAllThreadedMessages(String var1, int var2, int var3, int[] var4, int[] var5) throws OXException;

    public abstract List<List<MailMessage>> getAllSimpleThreadStructuredMessages(String var1, boolean var2, boolean var3, int var4, int var5, int[] var6, int[] var7, long var8) throws OXException;

    public abstract SearchIterator<MailMessage> getThreadedMessages(String var1, int[] var2, int var3, int var4, int[] var5, String[] var6, boolean var7, int[] var8) throws OXException;

    public abstract MailMessage[] getMessageList(String var1, String[] var2, int[] var3, String[] var4) throws OXException;

    public MailMessage getMessage(String folder, String msgUID) throws OXException {
        return this.getMessage(folder, msgUID, true);
    }

    public abstract MailMessage getMessage(String var1, String var2, boolean var3) throws OXException;

    public abstract MailPart getMessageAttachment(String var1, String var2, String var3, boolean var4) throws OXException;

    public abstract List<MailPart> getAllMessageAttachments(String var1, String var2) throws OXException;

    public abstract ManagedFile getMessageAttachments(String var1, String var2, String[] var3) throws OXException;

    public abstract ManagedFile getMessages(String var1, String[] var2) throws OXException;

    public abstract MailPart getMessageImage(String var1, String var2, String var3) throws OXException;

    public abstract MailPath saveDraft(ComposedMailMessage var1, boolean var2, int var3) throws OXException;

    public abstract void sendReceiptAck(String var1, String var2, String var3) throws OXException;

    public abstract void sendFormMail(ComposedMailMessage var1, int var2, int var3) throws OXException;

    public abstract String sendMessage(ComposedMailMessage var1, ComposeType var2, int var3) throws OXException;

    public abstract String sendMessage(ComposedMailMessage var1, ComposeType var2, int var3, UserSettingMail var4) throws OXException;

    public abstract String sendMessage(ComposedMailMessage var1, ComposeType var2, int var3, UserSettingMail var4, MtaStatusInfo var5) throws OXException;

    public abstract String[] appendMessages(String var1, MailMessage[] var2, boolean var3) throws OXException;

    public String[] importMessages(String destFolder, MailMessage[] msgs, boolean force) throws OXException {
        return this.appendMessages(destFolder, msgs, force);
    }

    public abstract MailMessage getReplyMessageForDisplay(String var1, String var2, boolean var3, UserSettingMail var4, boolean var5) throws OXException;

    public abstract MailMessage getForwardMessageForDisplay(String[] var1, String[] var2, UserSettingMail var3) throws OXException;

    public abstract boolean deleteMessages(String var1, String[] var2, boolean var3) throws OXException;

    public abstract boolean expungeFolder(String var1, boolean var2) throws OXException;

    public abstract boolean clearFolder(String var1) throws OXException;

    public abstract boolean clearFolder(String var1, boolean var2) throws OXException;

    public abstract String[] copyMessages(String var1, String var2, String[] var3, boolean var4) throws OXException;

    public abstract void updateMessageColorLabel(String var1, String[] var2, int var3) throws OXException;

    public abstract void updateMessageFlags(String var1, String[] var2, int var3, boolean var4) throws OXException;

    public abstract MailMessage[] getUpdatedMessages(String var1, int[] var2) throws OXException;

    public abstract MailMessage[] getDeletedMessages(String var1, int[] var2) throws OXException;

    public abstract SearchIterator<MailFolder> getRootFolders() throws OXException;

    public abstract SearchIterator<MailFolder> getChildFolders(String var1, boolean var2) throws OXException;

    public abstract MailFolder getFolder(String var1, boolean var2) throws OXException;

    public abstract SearchIterator<MailFolder> getPathToDefaultFolder(String var1) throws OXException;

    @Override
    public void close() {
        try {
            this.close(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void close(boolean var1) throws OXException;

    public abstract String saveFolder(MailFolderDescription var1) throws OXException;

    public abstract String deleteFolder(String var1) throws OXException;

    public abstract String getInboxFolder(int var1) throws OXException;

    public abstract String getDraftsFolder(int var1) throws OXException;

    public abstract String getSentFolder(int var1) throws OXException;

    public abstract String getSpamFolder(int var1) throws OXException;

    public abstract String getTrashFolder(int var1) throws OXException;

    public abstract String getConfirmedSpamFolder(int var1) throws OXException;

    public abstract String getConfirmedHamFolder(int var1) throws OXException;

    public abstract MailConfig getMailConfig() throws OXException;

    public abstract MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> getMailAccess() throws OXException;

    public abstract void openFor(String var1) throws OXException;

    public abstract int getAccountID();

    public abstract Collection<OXException> getWarnings();

    public MailImportResult[] getMailImportResults() {
        return new MailImportResult[0];
    }
}

