/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.exception.OXException;
import com.openexchange.mail.Quota;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.service.MailService;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.quota.AccountQuota;
import com.openexchange.quota.DefaultAccountQuota;
import com.openexchange.quota.QuotaExceptionCodes;
import com.openexchange.quota.QuotaProvider;
import com.openexchange.quota.QuotaType;
import com.openexchange.session.Session;
import java.util.LinkedList;
import java.util.List;

public class MailQuotaProvider
implements QuotaProvider {
    private final MailAccountStorageService mailAccountService;
    private final MailService mailService;

    public MailQuotaProvider(MailAccountStorageService mailAccountService, MailService mailService) {
        this.mailAccountService = mailAccountService;
        this.mailService = mailService;
    }

    public String getModuleID() {
        return "mail";
    }

    public String getDisplayName() {
        return "E-Mail";
    }

    public AccountQuota getFor(Session session, String accountID) throws OXException {
        MailAccount mailAccount;
        try {
            mailAccount = this.mailAccountService.getMailAccount(Integer.parseInt(accountID), session.getUserId(), session.getContextId());
        }
        catch (OXException e) {
            if (MailAccountExceptionCodes.NOT_FOUND.equals(e)) {
                throw QuotaExceptionCodes.UNKNOWN_ACCOUNT.create(new Object[]{accountID, this.getModuleID()});
            }
            throw e;
        }
        catch (NumberFormatException e) {
            throw QuotaExceptionCodes.UNKNOWN_ACCOUNT.create(new Object[]{accountID, this.getModuleID()});
        }
        return this.getForMailAccount(mailAccount, session);
    }

    public List<AccountQuota> getFor(Session session) throws OXException {
        MailAccount[] mailAccounts;
        LinkedList<AccountQuota> quotas = new LinkedList<AccountQuota>();
        for (MailAccount mailAccount : mailAccounts = this.mailAccountService.getUserMailAccounts(session.getUserId(), session.getContextId())) {
            quotas.add(this.getForMailAccount(mailAccount, session));
        }
        return quotas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccountQuota getForMailAccount(MailAccount mailAccount, Session session) throws OXException {
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = this.mailService.getMailAccess(session, mailAccount.getId());
        mailAccess.connect();
        try {
            Quota messageQuota;
            DefaultAccountQuota accountQuota = new DefaultAccountQuota(String.valueOf(mailAccount.getId()), mailAccount.getName());
            IMailFolderStorage folderStorage = mailAccess.getFolderStorage();
            Quota storageQuota = folderStorage.getStorageQuota("INBOX");
            if (storageQuota != null) {
                long limit = storageQuota.getLimit();
                if (limit == -1L) {
                    accountQuota.addQuota(com.openexchange.quota.Quota.UNLIMITED_SIZE);
                } else {
                    accountQuota.addQuota(QuotaType.SIZE, limit, storageQuota.getUsage());
                }
            }
            if ((messageQuota = folderStorage.getMessageQuota("INBOX")) != null) {
                long limit = messageQuota.getLimit();
                if (limit == -1L) {
                    accountQuota.addQuota(com.openexchange.quota.Quota.UNLIMITED_AMOUNT);
                } else {
                    accountQuota.addQuota(QuotaType.AMOUNT, limit, messageQuota.getUsage());
                }
            }
            DefaultAccountQuota defaultAccountQuota = accountQuota;
            return defaultAccountQuota;
        }
        finally {
            mailAccess.close();
        }
    }
}

