/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpamUpdateTask
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(SpamUpdateTask.class);
    private static final String SQL_MODIFY = "ALTER TABLE user_setting_mail ADD COLUMN confirmed_spam VARCHAR(128) character set utf8 collate utf8_unicode_ci NOT NULL, ADD COLUMN confirmed_ham VARCHAR(128) character set utf8 collate utf8_unicode_ci NOT NULL";
    private static final String SQL_UPDATE = "UPDATE user_setting_mail SET confirmed_spam = ?, confirmed_ham = ?";
    private static final String STR_INFO = "Performing update task 'SpamUpdateTask'";
    private static final String CONFIRMED_SPAM = "confirmed_spam";
    private static final String CONFIRMED_HAM = "confirmed_ham";
    private static final String SQL_SELECT_ALL = "SELECT * FROM user_setting_mail";

    @Override
    public int addedWithVersion() {
        return 1;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGHEST.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        if (LOG.isInfoEnabled()) {
            LOG.info(STR_INFO);
        }
        if (SpamUpdateTask.checkExistence(CONFIRMED_SPAM, contextId) && SpamUpdateTask.checkExistence(CONFIRMED_HAM, contextId)) {
            return;
        }
        Connection writeCon = null;
        PreparedStatement stmt = null;
        try {
            writeCon = Database.get(contextId, true);
            try {
                stmt = writeCon.prepareStatement(SQL_MODIFY);
                stmt.executeUpdate();
                stmt.close();
                stmt = writeCon.prepareStatement(SQL_UPDATE);
                stmt.setString(1, MailStrings.CONFIRMED_SPAM);
                stmt.setString(2, MailStrings.CONFIRMED_HAM);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            if (writeCon != null) {
                Database.back(contextId, true, writeCon);
            }
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
        if (writeCon != null) {
            Database.back(contextId, true, writeCon);
        }
    }

    /*
     * Loose catch block
     */
    private static final boolean checkExistence(String colName, int contextId) throws OXException {
        Connection readCon = null;
        Statement stmt = null;
        ResultSet rs = null;
        readCon = Database.get(contextId, false);
        stmt = readCon.createStatement();
        rs = stmt.executeQuery(SQL_SELECT_ALL);
        ResultSetMetaData meta = rs.getMetaData();
        int length = meta.getColumnCount();
        boolean found = false;
        for (int i = 1; i <= length && !found; ++i) {
            found = colName.equals(meta.getColumnName(i));
        }
        boolean bl = found;
        DBUtils.closeSQLStuff(rs, stmt);
        if (readCon != null) {
            Database.back(contextId, false, readCon);
        }
        return bl;
        {
            catch (SQLException e) {
                try {
                    throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    if (readCon != null) {
                        Database.back(contextId, false, readCon);
                    }
                    throw throwable;
                }
            }
        }
    }
}

