/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.MailAccountAddArchiveTask;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckForPresetMessageFormatInJSLob
extends UpdateTaskAdapter {
    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING);
    }

    @Override
    public String[] getDependencies() {
        return new String[]{MailAccountAddArchiveTask.class.getName()};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = dbService.getForUpdateTask(contextID);
        boolean rollback = false;
        try {
            DBUtils.startTransaction(con);
            rollback = true;
            List<Map<String, Object>> messageFormats = this.getMessageFormats(con);
            this.applytMessageFormats(messageFormats, con);
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            dbService.backForUpdateTask(contextID, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applytMessageFormats(List<Map<String, Object>> messageFormats, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE user_setting_mail SET msg_format=? WHERE cid=? AND user=? AND msg_format<>?");
            for (Map<String, Object> messageFormat : messageFormats) {
                String format = (String)messageFormat.get("messageFormat");
                int iFormat = "html".equalsIgnoreCase(format) ? 2 : ("text".equalsIgnoreCase(format) ? 1 : 3);
                stmt.setInt(1, iFormat);
                stmt.setInt(2, (Integer)messageFormat.get("contextId"));
                stmt.setInt(3, (Integer)messageFormat.get("userId"));
                stmt.setInt(4, iFormat);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getMessageFormats(Connection con) throws SQLException {
        LinkedList<Map<String, Object>> linkedList;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT cid, user, data FROM jsonStorage WHERE serviceId=? AND id=? AND data LIKE ?");
            stmt.setString(1, "com.openexchange.jslob.config");
            stmt.setString(2, "io.ox/mail");
            stmt.setString(3, "%\"messageFormat\":%");
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            List<Map<String, Object>> list = Collections.emptyList();
            DBUtils.closeSQLStuff(rs, stmt);
            return list;
        }
        try {
            LinkedList<Map<String, Object>> results = new LinkedList<Map<String, Object>>();
            do {
                try {
                    int contextId = rs.getInt(1);
                    int userId = rs.getInt(2);
                    String format = new JSONObject(rs.getString(3)).getString("messageFormat");
                    HashMap<String, Object> map = new HashMap<String, Object>(5);
                    map.put("contextId", contextId);
                    map.put("userId", userId);
                    map.put("messageFormat", format);
                    results.add(map);
                }
                catch (JSONException e) {
                    // empty catch block
                }
            } while (rs.next());
            linkedList = results;
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return linkedList;
    }
}

