/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.RdbTaskStorage;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskIterator;
import com.openexchange.server.impl.DBPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

public abstract class TaskStorage {
    public static final int[] TOMBSTONE_ATTRS = new int[]{1, 20, 223, 106, 5, 4, 2, 3, 101, 209, 104};
    private static final int[] UPDATE_DUMMY_ATTRS = new int[]{4, 5, 2, 3};
    private static final TaskStorage SINGLETON = new RdbTaskStorage();

    protected TaskStorage() {
    }

    public static TaskStorage getInstance() {
        return SINGLETON;
    }

    public abstract void insertTask(Context var1, Connection var2, Task var3, StorageType var4) throws OXException;

    public abstract void insertTask(Context var1, Connection var2, Task var3, StorageType var4, int[] var5) throws OXException;

    public void insertTask(Context ctx, Connection con, Task task, StorageType type, boolean optional, int[] columns) throws OXException {
        if (optional) {
            boolean exists = this.existsTask(ctx, con, task.getObjectID(), type);
            if (exists) {
                this.updateTask(ctx, con, task, new Date(Long.MAX_VALUE), UPDATE_DUMMY_ATTRS, type);
            } else {
                this.insertTask(ctx, con, task, type, columns);
            }
        } else {
            this.insertTask(ctx, con, task, type, columns);
        }
    }

    public abstract boolean existsTask(Context var1, Connection var2, int var3, StorageType var4) throws OXException;

    public abstract void updateTask(Context var1, Connection var2, Task var3, Date var4, int[] var5, StorageType var6) throws OXException;

    public void delete(Context ctx, Connection con, int taskId, Date lastRead, StorageType type) throws OXException {
        this.delete(ctx, con, taskId, lastRead, type, true);
    }

    public abstract void delete(Context var1, Connection var2, int var3, Date var4, StorageType var5, boolean var6) throws OXException;

    public abstract int countTasks(Context var1, int var2, int var3, boolean var4, boolean var5) throws OXException;

    protected abstract TaskIterator load(Context var1, int[] var2, int[] var3) throws OXException;

    public abstract TaskIterator list(Context var1, int var2, int var3, int var4, int var5, Order var6, int[] var7, boolean var8, int var9, boolean var10) throws OXException;

    public abstract TaskIterator list(Context var1, int var2, int var3, int var4, int var5, Order var6, int[] var7, boolean var8, int var9, boolean var10, Connection var11) throws OXException;

    public abstract TaskIterator search(Context var1, int var2, TaskSearchObject var3, int var4, Order var5, int[] var6, List<Integer> var7, List<Integer> var8, List<Integer> var9) throws OXException;

    public abstract Task selectTask(Context var1, Connection var2, int var3, StorageType var4) throws OXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task selectTask(Context ctx, int taskId, StorageType type) throws OXException {
        Connection con = DBPool.pickup(ctx);
        try {
            Task task = this.selectTask(ctx, con, taskId, type);
            return task;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    public abstract boolean containsNotSelfCreatedTasks(Context var1, Connection var2, int var3, int var4) throws OXException;

    abstract int countTasks(Context var1) throws OXException;

    abstract int countTasks(int var1, Connection var2) throws SQLException, OXException;
}

