/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.mapping.ActualCosts;
import com.openexchange.groupware.tasks.mapping.ActualDuration;
import com.openexchange.groupware.tasks.mapping.Filename;
import com.openexchange.groupware.tasks.mapping.ObjectID;
import com.openexchange.groupware.tasks.mapping.Priority;
import com.openexchange.groupware.tasks.mapping.RecurrenceCount;
import com.openexchange.groupware.tasks.mapping.Status;
import com.openexchange.groupware.tasks.mapping.TargetCosts;
import com.openexchange.groupware.tasks.mapping.TargetDuration;
import com.openexchange.groupware.tasks.mapping.UID;
import gnu.trove.TCollections;
import gnu.trove.TIntCollection;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public final class Mapping {
    public static final Mapper<? extends Object>[] MAPPERS = new Mapper[]{UID.SINGLETON, Filename.SINGLETON, new Mapper<Boolean>(){

        @Override
        public int getId() {
            return 101;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsPrivateFlag();
        }

        @Override
        public String getDBColumnName() {
            return "private";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setBoolean(pos, task.getPrivateFlag());
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            task.setPrivateFlag(result.getBoolean(pos));
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return task1.getPrivateFlag() == task2.getPrivateFlag();
        }

        @Override
        public Boolean get(Task task) {
            return task.getPrivateFlag();
        }

        @Override
        public void set(Task task, Boolean value) {
            task.setPrivateFlag(value);
        }
    }, new Mapper<Date>(){

        @Override
        public int getId() {
            return 4;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsCreationDate();
        }

        @Override
        public String getDBColumnName() {
            return "creating_date";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setTimestamp(pos, new Timestamp(task.getCreationDate().getTime()));
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            task.setCreationDate(result.getTimestamp(pos));
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return Mapping.equals(task1.getCreationDate(), task2.getCreationDate());
        }

        @Override
        public Date get(Task task) {
            return task.getCreationDate();
        }

        @Override
        public void set(Task task, Date value) {
            task.setCreationDate(value);
        }
    }, new Mapper<Date>(){

        @Override
        public int getId() {
            return 5;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsLastModified();
        }

        @Override
        public String getDBColumnName() {
            return "last_modified";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setLong(pos, task.getLastModified().getTime());
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            task.setLastModified(new Date(result.getLong(pos)));
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return Mapping.equals(task1.getLastModified(), task2.getLastModified());
        }

        @Override
        public Date get(Task task) {
            return task.getLastModified();
        }

        @Override
        public void set(Task task, Date value) {
            task.setLastModified(value);
        }
    }, new Mapper<Integer>(){

        @Override
        public int getId() {
            return 2;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsCreatedBy();
        }

        @Override
        public String getDBColumnName() {
            return "created_from";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setInt(pos, task.getCreatedBy());
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            task.setCreatedBy(result.getInt(pos));
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return task1.getCreatedBy() == task2.getCreatedBy();
        }

        @Override
        public Integer get(Task task) {
            return task.getCreatedBy();
        }

        @Override
        public void set(Task task, Integer value) {
            task.setCreatedBy(value);
        }
    }, new Mapper<Integer>(){

        @Override
        public int getId() {
            return 3;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsModifiedBy();
        }

        @Override
        public String getDBColumnName() {
            return "changed_from";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setInt(pos, task.getModifiedBy());
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            int changedBy = result.getInt(pos);
            if (!result.wasNull()) {
                task.setModifiedBy(changedBy);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return task1.getModifiedBy() == task2.getModifiedBy();
        }

        @Override
        public Integer get(Task task) {
            return task.getModifiedBy();
        }

        @Override
        public void set(Task task, Integer value) {
            task.setModifiedBy(value);
        }
    }, new Mapper<Date>(){

        @Override
        public int getId() {
            return 201;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsStartDate();
        }

        @Override
        public String getDBColumnName() {
            return "start";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            if (null == task.getStartDate()) {
                stmt.setNull(pos, 93);
            } else {
                stmt.setTimestamp(pos, new Timestamp(task.getStartDate().getTime()));
            }
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            Timestamp start = result.getTimestamp(pos);
            if (!result.wasNull()) {
                task.setStartDate(start);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return Mapping.equals(task1.getStartDate(), task2.getStartDate());
        }

        @Override
        public Date get(Task task) {
            return task.getStartDate();
        }

        @Override
        public void set(Task task, Date value) {
            task.setStartDate(value);
        }
    }, new Mapper<Date>(){

        @Override
        public int getId() {
            return 202;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsEndDate();
        }

        @Override
        public String getDBColumnName() {
            return "end";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            if (null == task.getEndDate()) {
                stmt.setNull(pos, 93);
            } else {
                stmt.setTimestamp(pos, new Timestamp(task.getEndDate().getTime()));
            }
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            Timestamp end = result.getTimestamp(pos);
            if (!result.wasNull()) {
                task.setEndDate(end);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return Mapping.equals(task1.getEndDate(), task2.getEndDate());
        }

        @Override
        public Date get(Task task) {
            return task.getEndDate();
        }

        @Override
        public void set(Task task, Date value) {
            task.setEndDate(value);
        }
    }, new Mapper<Date>(){

        @Override
        public int getId() {
            return 315;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsDateCompleted();
        }

        @Override
        public String getDBColumnName() {
            return "completed";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            if (null == task.getDateCompleted()) {
                stmt.setNull(pos, 93);
            } else {
                stmt.setTimestamp(pos, new Timestamp(task.getDateCompleted().getTime()));
            }
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            Timestamp completed = result.getTimestamp(pos);
            if (!result.wasNull()) {
                task.setDateCompleted(completed);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return Mapping.equals(task1.getDateCompleted(), task2.getDateCompleted());
        }

        @Override
        public Date get(Task task) {
            return task.getDateCompleted();
        }

        @Override
        public void set(Task task, Date value) {
            task.setDateCompleted(value);
        }
    }, new Mapper<String>(){

        @Override
        public int getId() {
            return 200;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsTitle();
        }

        @Override
        public String getDBColumnName() {
            return "title";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            if (null == task.getTitle()) {
                stmt.setNull(pos, 12);
            } else {
                stmt.setString(pos, task.getTitle());
            }
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            String title = result.getString(pos);
            if (!result.wasNull()) {
                task.setTitle(title);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return Mapping.equals(task1.getTitle(), task2.getTitle());
        }

        @Override
        public String get(Task task) {
            return task.getTitle();
        }

        @Override
        public void set(Task task, String value) {
            task.setTitle(value);
        }
    }, new Mapper<String>(){

        @Override
        public int getId() {
            return 203;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsNote();
        }

        @Override
        public String getDBColumnName() {
            return "description";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            if (null == task.getNote()) {
                stmt.setNull(pos, 12);
            } else {
                stmt.setString(pos, task.getNote());
            }
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            String description = result.getString(pos);
            if (!result.wasNull()) {
                task.setNote(description);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return Mapping.equals(task1.getNote(), task2.getNote());
        }

        @Override
        public String get(Task task) {
            return task.getNote();
        }

        @Override
        public void set(Task task, String value) {
            task.setNote(value);
        }
    }, Status.SINGLETON, Priority.SINGLETON, new Mapper<Integer>(){

        @Override
        public int getId() {
            return 301;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsPercentComplete();
        }

        @Override
        public String getDBColumnName() {
            return "progress";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setInt(pos, task.getPercentComplete());
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            int progress = result.getInt(pos);
            if (!result.wasNull()) {
                task.setPercentComplete(progress);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return task1.getPercentComplete() == task2.getPercentComplete();
        }

        @Override
        public Integer get(Task task) {
            return task.getPercentComplete();
        }

        @Override
        public void set(Task task, Integer value) {
            task.setPercentComplete(value);
        }
    }, new Mapper<String>(){

        @Override
        public int getId() {
            return 100;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsCategories();
        }

        @Override
        public String getDBColumnName() {
            return "categories";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            if (null == task.getCategories()) {
                stmt.setNull(pos, 12);
            } else {
                stmt.setString(pos, task.getCategories());
            }
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            String categories = result.getString(pos);
            if (!result.wasNull()) {
                task.setCategories(categories);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return Mapping.equals(task1.getCategories(), task2.getCategories());
        }

        @Override
        public String get(Task task) {
            return task.getCategories();
        }

        @Override
        public void set(Task task, String value) {
            task.setCategories(value);
        }
    }, new Mapper<Integer>(){

        @Override
        public int getId() {
            return 306;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsProjectID();
        }

        @Override
        public String getDBColumnName() {
            return "project";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setInt(pos, task.getProjectID());
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            int project = result.getInt(pos);
            if (!result.wasNull()) {
                task.setProjectID(project);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return task1.getProjectID() == task2.getProjectID();
        }

        @Override
        public Integer get(Task task) {
            return task.getProjectID();
        }

        @Override
        public void set(Task task, Integer value) {
            task.setProjectID(value);
        }
    }, TargetDuration.SINGLETON, ActualDuration.SINGLETON, TargetCosts.SINGLETON, ActualCosts.SINGLETON, new Mapper<String>(){

        @Override
        public int getId() {
            return 312;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsCurrency();
        }

        @Override
        public String getDBColumnName() {
            return "currency";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            if (null == task.getCurrency()) {
                stmt.setNull(pos, 12);
            } else {
                stmt.setString(pos, task.getCurrency());
            }
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            String currency = result.getString(pos);
            if (!result.wasNull()) {
                task.setCurrency(currency);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return Mapping.equals(task1.getCurrency(), task2.getCurrency());
        }

        @Override
        public String get(Task task) {
            return task.getCurrency();
        }

        @Override
        public void set(Task task, String value) {
            task.setCurrency(value);
        }
    }, new Mapper<String>(){

        @Override
        public int getId() {
            return 313;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsTripMeter();
        }

        @Override
        public String getDBColumnName() {
            return "trip_meter";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            if (null == task.getTripMeter()) {
                stmt.setNull(pos, 12);
            } else {
                stmt.setString(pos, task.getTripMeter());
            }
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            String tripMeter = result.getString(pos);
            if (!result.wasNull()) {
                task.setTripMeter(tripMeter);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return Mapping.equals(task1.getTripMeter(), task2.getTripMeter());
        }

        @Override
        public String get(Task task) {
            return task.getTripMeter();
        }

        @Override
        public void set(Task task, String value) {
            task.setTripMeter(value);
        }
    }, new Mapper<String>(){

        @Override
        public int getId() {
            return 305;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsBillingInformation();
        }

        @Override
        public String getDBColumnName() {
            return "billing";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            if (null == task.getBillingInformation()) {
                stmt.setNull(pos, 12);
            } else {
                stmt.setString(pos, task.getBillingInformation());
            }
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            String billing = result.getString(pos);
            if (!result.wasNull()) {
                task.setBillingInformation(billing);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return Mapping.equals(task1.getBillingInformation(), task2.getBillingInformation());
        }

        @Override
        public String get(Task task) {
            return task.getBillingInformation();
        }

        @Override
        public void set(Task task, String value) {
            task.setBillingInformation(value);
        }
    }, new Mapper<String>(){

        @Override
        public int getId() {
            return 314;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsCompanies();
        }

        @Override
        public String getDBColumnName() {
            return "companies";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            if (null == task.getCompanies()) {
                stmt.setNull(pos, 12);
            } else {
                stmt.setString(pos, task.getCompanies());
            }
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            String companies = result.getString(pos);
            if (!result.wasNull()) {
                task.setCompanies(companies);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return Mapping.equals(task1.getCompanies(), task2.getCompanies());
        }

        @Override
        public String get(Task task) {
            return task.getCompanies();
        }

        @Override
        public void set(Task task, String value) {
            task.setCompanies(value);
        }
    }, new Mapper<Integer>(){

        @Override
        public int getId() {
            return 102;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsLabel();
        }

        @Override
        public String getDBColumnName() {
            return "color_label";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setInt(pos, task.getLabel());
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            int colorLabel = result.getInt(pos);
            if (!result.wasNull()) {
                task.setLabel(colorLabel);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return task1.getLabel() == task2.getLabel();
        }

        @Override
        public Integer get(Task task) {
            return task.getLabel();
        }

        @Override
        public void set(Task task, Integer value) {
            task.setLabel(value);
        }
    }, new Mapper<Integer>(){

        @Override
        public int getId() {
            return 209;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsRecurrenceType();
        }

        @Override
        public String getDBColumnName() {
            return "recurrence_type";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setInt(pos, task.getRecurrenceType());
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            task.setRecurrenceType(result.getInt(pos));
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return task1.getRecurrenceType() == task2.getRecurrenceType();
        }

        @Override
        public Integer get(Task task) {
            return task.getRecurrenceType();
        }

        @Override
        public void set(Task task, Integer value) {
            task.setRecurrenceType(value);
        }
    }, new Mapper<Integer>(){

        @Override
        public int getId() {
            return 215;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsInterval();
        }

        @Override
        public String getDBColumnName() {
            return "recurrence_interval";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setInt(pos, task.getInterval());
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            int interval = result.getInt(pos);
            if (!result.wasNull()) {
                task.setInterval(interval);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return task1.getInterval() == task2.getInterval();
        }

        @Override
        public Integer get(Task task) {
            return task.getInterval();
        }

        @Override
        public void set(Task task, Integer value) {
            task.setInterval(value);
        }
    }, new Mapper<Integer>(){

        @Override
        public int getId() {
            return 212;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsDays();
        }

        @Override
        public String getDBColumnName() {
            return "recurrence_days";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            if (0 == task.getDays()) {
                stmt.setNull(pos, 4);
            } else {
                stmt.setInt(pos, task.getDays());
            }
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            int days = result.getInt(pos);
            if (!result.wasNull()) {
                task.setDays(days);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return task1.getDays() == task2.getDays();
        }

        @Override
        public Integer get(Task task) {
            return task.getDays();
        }

        @Override
        public void set(Task task, Integer value) {
            task.setDays(value);
        }
    }, new Mapper<Integer>(){

        @Override
        public int getId() {
            return 213;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsDayInMonth();
        }

        @Override
        public String getDBColumnName() {
            return "recurrence_dayinmonth";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setInt(pos, task.getDayInMonth());
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            int dayInMonth = result.getInt(pos);
            if (!result.wasNull()) {
                task.setDayInMonth(dayInMonth);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return task1.getDayInMonth() == task2.getDayInMonth();
        }

        @Override
        public Integer get(Task task) {
            return task.getDayInMonth();
        }

        @Override
        public void set(Task task, Integer value) {
            task.setDayInMonth(value);
        }
    }, new Mapper<Integer>(){

        @Override
        public int getId() {
            return 214;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsMonth();
        }

        @Override
        public String getDBColumnName() {
            return "recurrence_month";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setInt(pos, task.getMonth());
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            int month = result.getInt(pos);
            if (!result.wasNull()) {
                task.setMonth(month);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return task1.getMonth() == task2.getMonth();
        }

        @Override
        public Integer get(Task task) {
            return task.getMonth();
        }

        @Override
        public void set(Task task, Integer value) {
            task.setMonth(value);
        }
    }, new Mapper<Date>(){

        @Override
        public int getId() {
            return 216;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsUntil();
        }

        @Override
        public String getDBColumnName() {
            return "recurrence_until";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            if (null == task.getUntil()) {
                stmt.setNull(pos, 93);
            } else {
                stmt.setTimestamp(pos, new Timestamp(task.getUntil().getTime()));
            }
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            Timestamp until = result.getTimestamp(pos);
            if (!result.wasNull()) {
                task.setUntil(until);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return Mapping.equals(task1.getUntil(), task2.getUntil());
        }

        @Override
        public Date get(Task task) {
            return task.getUntil();
        }

        @Override
        public void set(Task task, Date value) {
            task.setUntil(value);
        }
    }, RecurrenceCount.SINGLETON, new Mapper<Integer>(){

        @Override
        public int getId() {
            return 104;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsNumberOfAttachments();
        }

        @Override
        public String getDBColumnName() {
            return "number_of_attachments";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setInt(pos, task.getNumberOfAttachments());
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            int numAttachments = result.getInt(pos);
            if (!result.wasNull()) {
                task.setNumberOfAttachments(numAttachments);
            }
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return task1.getNumberOfAttachments() == task2.getNumberOfAttachments();
        }

        @Override
        public Integer get(Task task) {
            return task.getNumberOfAttachments();
        }

        @Override
        public void set(Task task, Integer value) {
            task.setNumberOfAttachments(value);
        }
    }, new Mapper<Boolean>(){

        @Override
        public int getId() {
            return 401;
        }

        @Override
        public boolean isSet(Task task) {
            return task.containsFullTime();
        }

        @Override
        public String getDBColumnName() {
            return "full_time";
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
            stmt.setBoolean(pos, task.getFullTime());
        }

        @Override
        public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
            task.setFullTime(result.getBoolean(pos));
        }

        @Override
        public boolean equals(Task task1, Task task2) {
            return task1.getFullTime() == task2.getFullTime();
        }

        @Override
        public Boolean get(Task task) {
            return task.getFullTime();
        }

        @Override
        public void set(Task task, Boolean value) {
            task.setFullTime(value);
        }
    }};
    public static final Mapper<String>[] STRING_MAPPERS;
    private static final TIntObjectMap<Mapper<?>> ID_MAPPING;
    private static final TIntSet ALL_ATTRIBUTES;

    private Mapping() {
    }

    public static boolean equals(Object obj1, Object obj2) {
        return null == obj1 ? null == obj2 : obj1.equals(obj2);
    }

    public static Mapper<?> getMapping(int attributeId) {
        return (Mapper)ID_MAPPING.get(attributeId);
    }

    public static Collection<Mapper<?>> getAllFieldMappers() {
        return ID_MAPPING.valueCollection();
    }

    static boolean implemented(int[] attributes) {
        boolean retval = true;
        for (int i = 0; i < attributes.length && retval; ++i) {
            retval = ALL_ATTRIBUTES.contains(attributes[i]);
        }
        return retval;
    }

    static {
        TIntObjectHashMap tmp = new TIntObjectHashMap();
        for (Mapper<? extends Object> mapper : MAPPERS) {
            tmp.put(mapper.getId(), mapper);
        }
        ObjectID identifier = new ObjectID();
        tmp.put(identifier.getId(), (Object)identifier);
        ID_MAPPING = TCollections.unmodifiableMap((TIntObjectMap)tmp);
        TIntHashSet tmp2 = new TIntHashSet();
        tmp2.addAll((TIntCollection)ID_MAPPING.keySet());
        tmp2.add(220);
        tmp2.add(20);
        tmp2.add(204);
        ALL_ATTRIBUTES = TCollections.unmodifiableSet((TIntSet)tmp2);
        ArrayList<Mapper<? extends Object>> tmp3 = new ArrayList<Mapper<? extends Object>>();
        for (Mapper<? extends Object> mapper : MAPPERS) {
            for (Type t : mapper.getClass().getGenericInterfaces()) {
                if (!(t instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)t;
                for (Type u : pt.getActualTypeArguments()) {
                    if (!String.class.equals((Object)u)) continue;
                    tmp3.add(mapper);
                }
            }
        }
        STRING_MAPPERS = tmp3.toArray(new Mapper[tmp3.size()]);
    }
}

