/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum UserExceptionCode implements DisplayableOXExceptionCode
{
    PROPERTY_MISSING("Cannot find property %s.", null, Category.CATEGORY_CONFIGURATION, 1),
    DN_PROBLEM("Cannot build distinguished name from %s.", null, Category.CATEGORY_ERROR, 2),
    CLASS_NOT_FOUND("Class %s can not be loaded.", null, Category.CATEGORY_CONFIGURATION, 3),
    INSTANTIATION_PROBLEM("Cannot instantiate class %s.", null, Category.CATEGORY_CONFIGURATION, 4),
    NO_CONNECTION("Cannot get database connection.", "Error while reading/writing data from/to the database.", Category.CATEGORY_SERVICE_DOWN, 5),
    NOT_CLONEABLE("Cannot clone object %1$s.", "Cannot clone object \"%1$s\".", Category.CATEGORY_ERROR, 6),
    SQL_ERROR("SQL problem: \"%s\".", "Error while reading/writing data from/to the database.", Category.CATEGORY_ERROR, 7),
    HASHING("Hash algorithm %s could not be found.", "Hash algorithm \"%s\" could not be found.", Category.CATEGORY_ERROR, 8),
    UNSUPPORTED_ENCODING("Encoding %s cannot be used.", "Encoding \"%s\" cannot be used.", Category.CATEGORY_ERROR, 9),
    USER_NOT_FOUND("Cannot find user with identifier %1$s in context %2$d.", "Cannot find user with identifier \"%1$s\" in context %2$d.", Category.CATEGORY_ERROR, 10),
    USER_CONFLICT("Two users with same identifier %1$s in context %2$d found.", "Two users with same identifier \"%1$s\" in context %2$d found.", Category.CATEGORY_ERROR, 11),
    CACHE_PROBLEM("Problem putting/removing an object into/from the cache.", "Problem putting/removing an object into/from the cache.", Category.CATEGORY_ERROR, 12),
    PERMISSION("No permission to modify resources in context %1$s", "No permission to modify resources in context \"%1$s\"", Category.CATEGORY_PERMISSION_DENIED, 13),
    MISSING_PASSWORD_MECH("Missing or unknown password mechanism %1$s", "Missing or unknown password mechanism \"%1$s\"", Category.CATEGORY_ERROR, 14),
    INVALID_PASSWORD("New password contains invalid characters", "New password contains invalid characters.", Category.CATEGORY_USER_INPUT, 15),
    ERASED_ATTRIBUTES("Attributes of user %1$d in context %2$d have been erased.", "Attributes of user %1$d in context %2$d have been erased.", Category.CATEGORY_WARNING, 16),
    LOAD_FAILED("Loading one or more users failed.", "Loading one or more users failed.", Category.CATEGORY_ERROR, 17),
    ALIASES_MISSING("Alias entries are missing for user %1$d in context %2$d.", "Alias entries are missing for user %1$d in context %2$d.", Category.CATEGORY_CONFIGURATION, 18),
    UPDATE_ATTRIBUTES_FAILED("Updating attributes failed in context %1$d for user %2$d.", "Updating attributes failed in context %1$d for user %2$d.", Category.CATEGORY_ERROR, 19),
    INVALID_MIN_LENGTH("Invalid password length. The password must have a minimum length of %1$d.", "Invalid password length. The password must have a minimum length of %1$d.", Category.CATEGORY_USER_INPUT, 20),
    INVALID_MAX_LENGTH("Invalid password length. The password must have a maximum length of %1$d.", "Invalid password length. The password must have a maximum length of %1$d.", Category.CATEGORY_USER_INPUT, 21),
    MISSING_PARAMETER("The parameter %s for this user is missing.", "The parameter \"%s\" for this user is missing.", Category.CATEGORY_USER_INPUT, 22),
    INVALID_LOCALE("%s is not a valid locale.", "\"%s\" is not a valid locale.", Category.CATEGORY_USER_INPUT, 23),
    INVALID_TIMEZONE("%s is not a valid timezone.", "\"%s\" is not a valid timezone.", Category.CATEGORY_USER_INPUT, 24),
    LOCKING_NOT_ALLOWED("Locking attributes of multiple users is not allowed. You tried to lock %1$d user's attributes.", "Locking attributes of multiple users is not allowed. You tried to lock %1$d user's attributes.", Category.CATEGORY_ERROR, 25),
    NOT_ALLOWED_PASSWORD("The entered password is illegal and can't be saved. Allowed characters are: %1$s", "The entered password is illegal and can't be saved. Allowed characters are: %1$s", Category.CATEGORY_USER_INPUT, 26),
    INCORRECT_CURRENT_PASSWORD("The current password is incorrect.", "The current password is incorrect. Please enter your correct current password and try again.", Category.CATEGORY_USER_INPUT, 27),
    MISSING_CURRENT_PASSWORD("The current password is missing.", "The current password is missing. Please enter your current password and try again.", Category.CATEGORY_USER_INPUT, 28),
    MISSING_NEW_PASSWORD("The new password is incorrect.", "The new password is missing. Please enter your new password and try again.", Category.CATEGORY_USER_INPUT, 29);

    private static final String PREFIX = "USR";
    private final String message;
    private final String displayMessage;
    private final Category category;
    private final int detailNumber;

    private UserExceptionCode(String message, String displayMessage, Category category, int detailNumber) {
        this.message = message;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
        this.category = category;
        this.detailNumber = detailNumber;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public String getPrefix() {
        return PREFIX;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

