/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import gnu.trove.TCollections;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarFolderObject
implements Serializable {
    private static final TIntSet EMPTY = TCollections.unmodifiableSet((TIntSet)new TIntHashSet(0));
    private static final long serialVersionUID = -2356348744702379243L;
    private final int uid;
    private final int cid;
    private TIntSet privatefolder = EMPTY;
    private TIntSet publicfolder = EMPTY;
    private TIntSet sharedfolder = EMPTY;
    private final boolean fill_shared;
    private static final transient Logger LOG = LoggerFactory.getLogger(CalendarFolderObject.class);
    public static final String IDENTIFIER = "CalendarFolderObject@";
    private TIntSet publicReadableAllSet = EMPTY;
    private TIntSet publicReadableOwnSet = EMPTY;
    private TIntSet privateReadableAllSet = EMPTY;
    private TIntSet privateReadableOwnSet = EMPTY;
    private TIntSet sharedReadableAllSet = EMPTY;
    private TIntSet sharedReadableOwnSet = EMPTY;

    public CalendarFolderObject(int uid, int cid, boolean fill_shared) {
        this.uid = uid;
        this.cid = cid;
        this.fill_shared = fill_shared;
    }

    public void addFolder(boolean readall, boolean readown, boolean shared, int folderid, int type) {
        if (!shared) {
            if (type == 1) {
                if (this.privatefolder == EMPTY) {
                    this.privatefolder = new TIntHashSet(4);
                }
                this.privatefolder.add(folderid);
                if (readall) {
                    if (this.privateReadableAllSet == EMPTY) {
                        this.privateReadableAllSet = new TIntHashSet(4);
                    }
                    this.privateReadableAllSet.add(folderid);
                } else if (readown) {
                    if (this.privateReadableOwnSet == EMPTY) {
                        this.privateReadableOwnSet = new TIntHashSet(4);
                    }
                    this.privateReadableOwnSet.add(folderid);
                }
            } else if (type == 2) {
                if (this.publicfolder == EMPTY) {
                    this.publicfolder = new TIntHashSet(4);
                }
                if (readall) {
                    if (this.publicReadableAllSet == EMPTY) {
                        this.publicReadableAllSet = new TIntHashSet(4);
                    }
                    this.publicReadableAllSet.add(folderid);
                } else if (readown) {
                    if (this.publicReadableOwnSet == EMPTY) {
                        this.publicReadableOwnSet = new TIntHashSet(4);
                    }
                    this.publicReadableOwnSet.add(folderid);
                }
            } else {
                LOG.warn("Got an unknown folder type :{} for folderid {}", (Object)type, (Object)folderid);
            }
        } else if (this.fill_shared) {
            if (this.sharedfolder == EMPTY) {
                this.sharedfolder = new TIntHashSet(4);
            }
            this.sharedfolder.add(folderid);
            if (readall) {
                if (this.sharedReadableAllSet == EMPTY) {
                    this.sharedReadableAllSet = new TIntHashSet(4);
                }
                this.sharedReadableAllSet.add(folderid);
            } else if (readown) {
                if (this.sharedReadableOwnSet == EMPTY) {
                    this.sharedReadableOwnSet = new TIntHashSet(4);
                }
                this.sharedReadableOwnSet.add(folderid);
            }
        }
    }

    public final TIntSet getPrivateFolders() {
        return this.privatefolder;
    }

    public final TIntSet getPublicFolders() {
        return this.publicfolder;
    }

    public final TIntSet getSharedFolderList() {
        return this.sharedfolder;
    }

    public final TIntSet getPrivateReadableAll() {
        return this.privateReadableAllSet;
    }

    public final TIntSet getPrivateReadableOwn() {
        return this.privateReadableOwnSet;
    }

    public final TIntSet getPublicReadableAll() {
        return this.publicReadableAllSet;
    }

    public final TIntSet getPublicReadableOwn() {
        return this.publicReadableOwnSet;
    }

    public final TIntSet getSharedReadableAll() {
        return this.sharedReadableAllSet;
    }

    public final TIntSet getSharedReadableOwn() {
        return this.sharedReadableOwnSet;
    }

    public int hashCode() {
        return this.uid ^ this.cid ^ (this.fill_shared ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalendarFolderObject)) {
            return false;
        }
        CalendarFolderObject oo = (CalendarFolderObject)o;
        return this.uid == oo.uid && this.cid == oo.cid && this.fill_shared == oo.fill_shared;
    }

    public String getObjectKey() {
        StringBuilder key = new StringBuilder(IDENTIFIER);
        key.append('.');
        key.append(this.uid);
        key.append('.');
        key.append(this.cid);
        key.append('.');
        key.append(this.fill_shared);
        return key.toString();
    }

    public String getGroupKey() {
        StringBuilder key = new StringBuilder(IDENTIFIER);
        key.append('.');
        key.append(this.cid);
        return key.toString();
    }

    public static final String createGroupKeyFromContextID(int cid) {
        StringBuilder key = new StringBuilder(IDENTIFIER);
        key.append('.');
        key.append(cid);
        return key.toString();
    }

    public boolean canReadAllInPublicFolder(int fid) {
        return this.publicReadableAllSet.contains(fid);
    }

    public boolean canReadOwnInPublicFolder(int fid) {
        return this.publicReadableOwnSet.contains(fid);
    }

    public boolean canReadAllInPrivateFolder(int fid) {
        return this.privateReadableAllSet.contains(fid);
    }

    public boolean canReadOwnInPrivateFolder(int fid) {
        return this.privateReadableOwnSet.contains(fid);
    }

    public boolean canReadAllInSharedFolder(int fid) {
        return this.sharedReadableAllSet.contains(fid);
    }

    public boolean canReadOwnInSharedFolder(int fid) {
        return this.sharedReadableOwnSet.contains(fid);
    }
}

