/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarFolderObject;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CalendarCache {
    private static volatile CalendarCache instance;
    private static final String CACHE_NAME = "CalendarCache";
    private static final Logger LOG;
    private Cache jcs;

    private CalendarCache() {
        try {
            try {
                this.jcs = ServerServiceRegistry.getInstance().getService(CacheService.class).getCache(CACHE_NAME);
            }
            catch (OXException ce) {
                LOG.error("CalendarCache could not be initialized!", (Throwable)ce);
            }
        }
        catch (Exception e) {
            LOG.error("CalendarCache could not be initialized!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CalendarCache getInstance() {
        if (instance != null) return instance;
        Class<CalendarCache> clazz = CalendarCache.class;
        synchronized (CalendarCache.class) {
            if (instance != null) return instance;
            instance = new CalendarCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void add(Object key, String groupKey, Object o) throws OXException {
        this.jcs.putInGroup((Serializable)key, groupKey, (Serializable)o, false);
    }

    public Object get(Object key, String groupKey) {
        return this.jcs.getFromGroup((Serializable)key, groupKey);
    }

    public void clear() throws OXException {
        this.jcs.clear();
    }

    public void invalidateGroup(int cid) {
        this.jcs.invalidateGroup(CalendarFolderObject.createGroupKeyFromContextID(cid));
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    static {
        LOG = LoggerFactory.getLogger(CalendarCache.class);
    }
}

