/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.impl;

import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.context.ContextService;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.quota.AccountQuota;
import com.openexchange.quota.DefaultAccountQuota;
import com.openexchange.quota.Quota;
import com.openexchange.quota.QuotaExceptionCodes;
import com.openexchange.quota.QuotaProvider;
import com.openexchange.quota.QuotaType;
import com.openexchange.quota.groupware.AmountQuotas;
import com.openexchange.session.Session;
import com.openexchange.tools.file.external.QuotaFileStorage;
import com.openexchange.tools.file.external.QuotaFileStorageFactory;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;

public class AttachmentQuotaProvider
implements QuotaProvider {
    private static final String MODULE_ID = "attachment";
    private final DatabaseService dbService;
    private final ContextService contextService;
    private final ConfigViewFactory viewFactory;
    private final QuotaFileStorageFactory fsFactory;

    public AttachmentQuotaProvider(DatabaseService dbService, ContextService contextService, ConfigViewFactory viewFactory, QuotaFileStorageFactory fsFactory) {
        this.dbService = dbService;
        this.contextService = contextService;
        this.viewFactory = viewFactory;
        this.fsFactory = fsFactory;
    }

    public String getModuleID() {
        return MODULE_ID;
    }

    public String getDisplayName() {
        return "Attachments";
    }

    Quota getAmountQuota(Session session) throws OXException {
        Quota quota;
        block8: {
            Connection connection = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                connection = this.dbService.getReadOnly(session.getContextId());
                long limit = AmountQuotas.getLimit((Session)session, (String)MODULE_ID, (ConfigViewFactory)this.viewFactory, (Connection)connection);
                if (-1L == limit) {
                    Quota quota2 = Quota.UNLIMITED_AMOUNT;
                    return quota2;
                }
                stmt = connection.prepareStatement("SELECT count(id) FROM prg_attachment WHERE cid=?");
                stmt.setInt(1, session.getContextId());
                rs = stmt.executeQuery();
                long usage = rs.next() ? rs.getLong(1) : 0L;
                quota = new Quota(QuotaType.AMOUNT, limit, usage);
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                if (null == connection) break block8;
            }
            catch (SQLException e) {
                throw QuotaExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            finally {
                Databases.closeSQLStuff(rs, stmt);
                if (null != connection) {
                    this.dbService.backReadOnly(session.getContextId(), connection);
                }
            }
            this.dbService.backReadOnly(session.getContextId(), connection);
        }
        return quota;
    }

    Quota getSizeQuota(Session session) throws OXException {
        Context context = this.contextService.getContext(session.getContextId());
        URI uri = FilestoreStorage.createURI(context);
        QuotaFileStorage quotaFileStorage = this.fsFactory.getQuotaFileStorage(context, uri);
        long limit = quotaFileStorage.getQuota();
        long usage = quotaFileStorage.getUsage();
        return new Quota(QuotaType.SIZE, limit, usage);
    }

    public AccountQuota getFor(Session session, String accountID) throws OXException {
        if ("0".equals(accountID)) {
            return new DefaultAccountQuota(accountID, this.getDisplayName()).addQuota(this.getAmountQuota(session)).addQuota(this.getSizeQuota(session));
        }
        throw QuotaExceptionCodes.UNKNOWN_ACCOUNT.create(new Object[]{accountID, MODULE_ID});
    }

    public List<AccountQuota> getFor(Session session) throws OXException {
        return Collections.singletonList(this.getFor(session, "0"));
    }
}

