/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal;

import com.openexchange.folderstorage.AltNameAwareFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExtension;
import com.openexchange.folderstorage.FolderField;
import com.openexchange.folderstorage.FolderProperty;
import com.openexchange.folderstorage.ParameterizedFolder;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.session.Session;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public final class UserizedFolderImpl
implements UserizedFolder {
    private static final long serialVersionUID = 5090343231211791986L;
    private final Session session;
    private final User user;
    private final Context context;
    private Folder folder;
    private Permission ownPermission;
    private Date lastModifiedUTC;
    private Date creationDateUTC;
    private Locale locale;
    private Boolean deefault;
    private Integer defaultType;
    private Type type;
    private Permission[] permissions;
    private String[] subfolderIds;
    private String parentId;
    private Date creationDate;
    private Date lastModified;
    private volatile Map<FolderField, FolderProperty> properties;
    private int[] totalAndUnread;
    private volatile ConcurrentMap<String, Object> parameters;
    private boolean altNames;

    public UserizedFolderImpl(Folder folder, Session session, User user, Context context) {
        if (null == folder) {
            throw new IllegalArgumentException("Folder is null.");
        }
        this.folder = folder;
        this.session = session;
        this.user = user;
        this.context = context;
    }

    @Override
    public void setParameters(ConcurrentMap<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public ConcurrentMap<String, Object> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return new StringBuilder(32).append("{ name=").append(this.folder.getName()).append(", id=").append(this.folder.getID()).append('}').toString();
    }

    @Override
    public Object clone() {
        try {
            UserizedFolderImpl clone = (UserizedFolderImpl)super.clone();
            clone.folder = (Folder)clone.folder.clone();
            clone.ownPermission = this.ownPermission == null ? null : (Permission)this.ownPermission.clone();
            clone.lastModifiedUTC = null == this.lastModifiedUTC ? null : new Date(this.lastModifiedUTC.getTime());
            clone.creationDateUTC = null == this.creationDateUTC ? null : new Date(this.creationDateUTC.getTime());
            clone.locale = (Locale)(null == this.locale ? null : this.locale.clone());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public int getBits() {
        return this.folder.getBits();
    }

    @Override
    public void setBits(int bits) {
        this.folder.setBits(bits);
    }

    @Override
    public int getCreatedBy() {
        return this.folder.getCreatedBy();
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate == null ? this.folder.getCreationDate() : this.creationDate;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified == null ? this.folder.getLastModified() : this.lastModified;
    }

    @Override
    public int getModifiedBy() {
        return this.folder.getModifiedBy();
    }

    @Override
    public void setCreatedBy(int createdBy) {
        this.folder.setCreatedBy(createdBy);
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate == null ? null : new Date(creationDate.getTime());
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified == null ? null : new Date(lastModified.getTime());
    }

    @Override
    public void setModifiedBy(int modifiedBy) {
        this.folder.setModifiedBy(modifiedBy);
    }

    @Override
    public ContentType getContentType() {
        return this.folder.getContentType();
    }

    @Override
    public String getID() {
        return this.folder.getID();
    }

    @Override
    public String getLocalizedName(Locale locale) {
        return this.folder.getLocalizedName(null == locale ? LocaleTools.DEFAULT_LOCALE : locale);
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    @Override
    public String getParentID() {
        return null == this.parentId ? this.folder.getParentID() : this.parentId;
    }

    @Override
    public Permission[] getPermissions() {
        return null == this.permissions ? this.folder.getPermissions() : this.permissions;
    }

    @Override
    public String[] getSubfolderIDs() {
        return this.subfolderIds == null ? this.folder.getSubfolderIDs() : this.subfolderIds;
    }

    @Override
    public String getTreeID() {
        return this.folder.getTreeID();
    }

    @Override
    public Type getType() {
        return null == this.type ? this.folder.getType() : this.type;
    }

    @Override
    public boolean isCacheable() {
        return this.folder.isCacheable();
    }

    @Override
    public boolean isGlobalID() {
        return this.folder.isGlobalID();
    }

    @Override
    public boolean isSubscribed() {
        return this.folder.isSubscribed();
    }

    @Override
    public boolean hasSubscribedSubfolders() {
        return this.folder.hasSubscribedSubfolders();
    }

    @Override
    public boolean isVirtual() {
        return this.folder.isVirtual();
    }

    @Override
    public void setContentType(ContentType contentType) {
        this.folder.setContentType(contentType);
    }

    @Override
    public void setID(String id) {
        this.folder.setID(id);
    }

    @Override
    public void setName(String name) {
        this.folder.setName(name);
    }

    @Override
    public void setParentID(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public void setPermissions(Permission[] permissions) {
        this.permissions = permissions;
    }

    @Override
    public void setSubfolderIDs(String[] subfolderIds) {
        this.subfolderIds = subfolderIds;
    }

    @Override
    public void setSubscribed(boolean subscribed) {
        this.folder.setSubscribed(subscribed);
    }

    @Override
    public void setSubscribedSubfolders(boolean subscribedSubfolders) {
        this.folder.setSubscribedSubfolders(subscribedSubfolders);
    }

    @Override
    public void setTreeID(String id) {
        this.folder.setTreeID(id);
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public Permission getOwnPermission() {
        return this.ownPermission;
    }

    @Override
    public void setOwnPermission(Permission ownPermission) {
        this.ownPermission = ownPermission;
    }

    @Override
    public Date getLastModifiedUTC() {
        return this.lastModifiedUTC == null ? null : new Date(this.lastModifiedUTC.getTime());
    }

    @Override
    public void setLastModifiedUTC(Date lastModifiedUTC) {
        this.lastModifiedUTC = lastModifiedUTC == null ? null : new Date(lastModifiedUTC.getTime());
    }

    @Override
    public Date getCreationDateUTC() {
        return this.creationDateUTC == null ? null : new Date(this.creationDateUTC.getTime());
    }

    @Override
    public void setCreationDateUTC(Date creationDateUTC) {
        this.creationDateUTC = creationDateUTC == null ? null : new Date(creationDateUTC.getTime());
    }

    @Override
    public int getCapabilities() {
        return this.folder.getCapabilities();
    }

    @Override
    public int getDeleted() {
        return this.folder.getDeleted();
    }

    @Override
    public int getNew() {
        return this.folder.getNew();
    }

    @Override
    public String getSummary() {
        return this.folder.getSummary();
    }

    @Override
    public int getTotal() {
        if (null == this.totalAndUnread) {
            if (this.folder instanceof FolderExtension) {
                this.totalAndUnread = ((FolderExtension)this.folder).getTotalAndUnread(this.parameters);
                if (null != this.totalAndUnread) {
                    return this.totalAndUnread[0];
                }
            }
        } else {
            return this.totalAndUnread[0];
        }
        return this.folder.getTotal();
    }

    @Override
    public int getUnread() {
        if (null == this.totalAndUnread) {
            if (this.folder instanceof FolderExtension) {
                this.totalAndUnread = ((FolderExtension)this.folder).getTotalAndUnread(this.parameters);
                if (null != this.totalAndUnread) {
                    return this.totalAndUnread[1];
                }
            }
        } else {
            return this.totalAndUnread[1];
        }
        return this.folder.getUnread();
    }

    @Override
    public boolean isDefault() {
        return null == this.deefault ? this.folder.isDefault() : this.deefault.booleanValue();
    }

    @Override
    public void setCapabilities(int capabilities) {
        this.folder.setCapabilities(capabilities);
    }

    @Override
    public void setDefault(boolean deefault) {
        this.deefault = deefault;
    }

    @Override
    public void setDeleted(int deleted) {
        this.folder.setDeleted(deleted);
    }

    @Override
    public void setDefaultType(int defaultType) {
        this.defaultType = defaultType;
    }

    @Override
    public int getDefaultType() {
        return null == this.defaultType ? this.folder.getDefaultType() : this.defaultType.intValue();
    }

    @Override
    public void setNew(int nu) {
        this.folder.setNew(nu);
    }

    @Override
    public void setSummary(String summary) {
        this.folder.setSummary(summary);
    }

    @Override
    public void setTotal(int total) {
        this.folder.setTotal(total);
    }

    @Override
    public void setUnread(int unread) {
        this.folder.setUnread(unread);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public String getNewID() {
        throw new UnsupportedOperationException("UserizedFolderImpl.getNewID()");
    }

    @Override
    public void setNewID(String newId) {
        throw new UnsupportedOperationException("UserizedFolderImpl.setNewID()");
    }

    @Override
    public void setProperty(FolderField name, Object value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<FolderField, FolderProperty> getProperties() {
        Map<FolderField, FolderProperty> map = this.properties;
        if (null == map) {
            UserizedFolderImpl userizedFolderImpl = this;
            synchronized (userizedFolderImpl) {
                map = this.properties;
                if (null == map) {
                    if (this.folder instanceof ParameterizedFolder) {
                        ParameterizedFolder parameterizedFolder = (ParameterizedFolder)this.folder;
                        map = parameterizedFolder.getProperties();
                    } else {
                        map = Collections.emptyMap();
                    }
                    this.properties = map;
                }
            }
        }
        return map;
    }

    @Override
    public Map<String, Object> getMeta() {
        return this.folder.getMeta();
    }

    @Override
    public void setMeta(Map<String, Object> meta) {
        this.folder.setMeta(meta);
    }

    @Override
    public Set<String> getSupportedCapabilities() {
        return this.folder.getSupportedCapabilities();
    }

    @Override
    public void setSupportedCapabilities(Set<String> capabilities) {
        this.folder.setSupportedCapabilities(capabilities);
    }

    @Override
    public boolean supportsAltName() {
        return this.folder instanceof AltNameAwareFolder && ((AltNameAwareFolder)this.folder).supportsAltName();
    }

    @Override
    public String getLocalizedName(Locale locale, boolean altName) {
        if (this.folder instanceof AltNameAwareFolder) {
            return ((AltNameAwareFolder)this.folder).getLocalizedName(locale, altName);
        }
        return this.getLocalizedName(locale);
    }

    @Override
    public boolean isAltNames() {
        return this.altNames;
    }

    @Override
    public void setAltNames(boolean altNames) {
        this.altNames = altNames;
    }
}

