/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.filestorage;

import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.CacheAware;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderType;
import com.openexchange.file.storage.FileStoragePermission;
import com.openexchange.file.storage.TypeAware;
import com.openexchange.folderstorage.AbstractFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SystemContentType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.database.getfolder.SystemInfostoreFolder;
import com.openexchange.folderstorage.filestorage.FileStoragePermissionImpl;
import com.openexchange.folderstorage.filestorage.contentType.FileStorageContentType;
import com.openexchange.folderstorage.filestorage.contentType.PublicContentType;
import com.openexchange.folderstorage.filestorage.contentType.TrashContentType;
import com.openexchange.folderstorage.type.FileStorageType;
import com.openexchange.folderstorage.type.SystemType;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.PutIfAbsent;
import com.openexchange.session.Session;
import java.util.List;
import org.slf4j.LoggerFactory;

public final class FileStorageFolderImpl
extends AbstractFolder {
    private static final long serialVersionUID = 6445442372690458946L;
    private static final String INFOSTORE = Integer.toString(9);
    private static final String INFOSTORE_USER = Integer.toString(10);
    private static final String INFOSTORE_PUBLIC = Integer.toString(15);
    private boolean cacheable;
    private final FileStorageDefaultFolderType defaultFolderType;
    private static final String PRIVATE_FOLDER_ID = String.valueOf(1);

    public FileStorageFolderImpl(FileStorageFolder fsFolder, Session session, boolean altNames) {
        this.id = fsFolder.getId();
        this.name = fsFolder.getName();
        if (fsFolder.isRootFolder()) {
            this.parent = PRIVATE_FOLDER_ID;
            this.defaultFolderType = FileStorageDefaultFolderType.NONE;
        } else {
            String parentId = null;
            if (fsFolder instanceof TypeAware) {
                FileStorageFolderType folderType = ((TypeAware)fsFolder).getType();
                if (FileStorageFolderType.HOME_DIRECTORY.equals((Object)folderType)) {
                    this.defaultFolderType = FileStorageDefaultFolderType.HOME_DIRECTORY;
                    parentId = FileStorageFolderImpl.showPersonalBelowInfoStore(session, altNames) ? INFOSTORE : INFOSTORE_USER;
                } else if (FileStorageFolderType.PUBLIC_FOLDER.equals((Object)folderType)) {
                    this.defaultFolderType = FileStorageDefaultFolderType.PUBLIC_FOLDER;
                    parentId = INFOSTORE_PUBLIC;
                } else {
                    this.defaultFolderType = FileStorageFolderType.TRASH_FOLDER.equals((Object)folderType) ? FileStorageDefaultFolderType.TRASH : FileStorageDefaultFolderType.NONE;
                }
            } else {
                this.defaultFolderType = FileStorageDefaultFolderType.NONE;
            }
            this.parent = null != parentId ? parentId : fsFolder.getParentId();
        }
        List fsPermissions = fsFolder.getPermissions();
        int size = fsPermissions.size();
        this.permissions = new Permission[size];
        for (int i = 0; i < size; ++i) {
            FileStoragePermissionImpl permissionImpl = new FileStoragePermissionImpl((FileStoragePermission)fsPermissions.get(i));
            if (permissionImpl.isAdmin() && !permissionImpl.isGroup()) {
                this.createdBy = permissionImpl.getEntity();
            }
            this.permissions[i] = permissionImpl;
        }
        this.type = SystemType.getInstance();
        this.subscribed = fsFolder.isSubscribed();
        this.subscribedSubfolders = fsFolder.hasSubscribedSubfolders();
        this.deefault = fsFolder.isDefaultFolder();
        this.total = fsFolder.getFileCount();
        int n = this.defaultType = this.deefault ? FileStorageContentType.getInstance().getModule() : 0;
        this.cacheable = fsFolder instanceof CacheAware ? !fsFolder.isDefaultFolder() && ((CacheAware)fsFolder).cacheable() : !fsFolder.isDefaultFolder();
        this.meta = fsFolder.getMeta();
        this.supportedCapabilities = fsFolder.getCapabilities();
    }

    private static boolean showPersonalBelowInfoStore(Session session, boolean altNames) {
        if (!altNames) {
            return false;
        }
        String paramName = "com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore";
        Boolean tmp = (Boolean)session.getParameter("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore");
        if (null != tmp) {
            return tmp;
        }
        ConfigViewFactory configViewFactory = ServerServiceRegistry.getInstance().getService(ConfigViewFactory.class);
        if (null == configViewFactory) {
            return false;
        }
        try {
            ConfigView view = configViewFactory.getView(session.getUserId(), session.getContextId());
            Boolean b = (Boolean)view.opt("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore", Boolean.TYPE, (Object)Boolean.FALSE);
            if (session instanceof PutIfAbsent) {
                ((PutIfAbsent)session).setParameterIfAbsent("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore", (Object)b);
            } else {
                session.setParameter("com.openexchange.folderstorage.outlook.showPersonalBelowInfoStore", (Object)b);
            }
            return b;
        }
        catch (OXException e) {
            LoggerFactory.getLogger(SystemInfostoreFolder.class).warn("", (Throwable)e);
            return false;
        }
    }

    @Override
    public Object clone() {
        FileStorageFolderImpl clone = (FileStorageFolderImpl)super.clone();
        clone.cacheable = this.cacheable;
        return clone;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public Type getType() {
        return FileStorageType.getInstance();
    }

    @Override
    public void setContentType(ContentType contentType) {
    }

    @Override
    public void setType(Type type) {
    }

    @Override
    public ContentType getContentType() {
        return this.defaultFolderType.getContentType();
    }

    @Override
    public int getDefaultType() {
        return this.defaultFolderType.getType();
    }

    @Override
    public void setDefaultType(int defaultType) {
    }

    @Override
    public boolean isGlobalID() {
        return false;
    }

    public static enum FileStorageDefaultFolderType {
        NONE(FileStorageContentType.getInstance(), 0),
        ROOT(SystemContentType.getInstance(), 0),
        HOME_DIRECTORY(FileStorageContentType.getInstance(), 8),
        PUBLIC_FOLDER(PublicContentType.getInstance(), 15),
        TRASH(TrashContentType.getInstance(), 16);

        private final ContentType contentType;
        private final int type;

        private FileStorageDefaultFolderType(ContentType contentType, int type) {
            this.contentType = contentType;
            this.type = type;
        }

        public ContentType getContentType() {
            return this.contentType;
        }

        public int getType() {
            return this.type;
        }
    }
}

