/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache.groupware;

import com.openexchange.ajax.requesthandler.converters.preview.cache.groupware.PreviewCacheCreateTableService;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class PreviewCacheCreateTableTask
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        int contextId = params.getContextId();
        Connection writeCon = dbService.getForUpdateTask(contextId);
        PreparedStatement stmt = null;
        boolean rollback = false;
        boolean restoreAutoCommit = false;
        try {
            writeCon.setAutoCommit(false);
            restoreAutoCommit = true;
            rollback = true;
            String[] tableNames = PreviewCacheCreateTableService.getTablesToCreate();
            String[] createStmts = PreviewCacheCreateTableService.getCreateStmts();
            for (int i = 0; i < tableNames.length; ++i) {
                try {
                    if (DBUtils.tableExists(writeCon, tableNames[i])) continue;
                    stmt = writeCon.prepareStatement(createStmts[i]);
                    stmt.executeUpdate();
                    continue;
                }
                catch (SQLException e) {
                    throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                }
            }
            writeCon.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(writeCon);
            }
            DBUtils.closeSQLStuff(stmt);
            if (restoreAutoCommit) {
                DBUtils.autocommit(writeCon);
            }
            dbService.backForUpdateTask(contextId, writeCon);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }
}

