/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.SessionUtility;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.annotation.NonNull;
import com.openexchange.annotation.Nullable;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.java.util.Pair;
import com.openexchange.log.LogProperties;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.server.services.SessionInspector;
import com.openexchange.session.Reply;
import com.openexchange.session.Session;
import com.openexchange.session.SessionResult;
import com.openexchange.session.SessionSecretChecker;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherServlet
extends SessionServlet {
    private static final long serialVersionUID = -8060034833311074781L;
    private static final Logger LOG = LoggerFactory.getLogger(DispatcherServlet.class);
    @NonNull
    private static final Session NO_SESSION = new SessionObject(Dispatcher.class.getSimpleName() + "-Fake-Session");
    private static final EnumSet<LogProperties.Name> PROPS_TO_IGNORE = EnumSet.of(LogProperties.Name.SESSION_CONTEXT_ID);
    private static final AtomicReference<Dispatcher> DISPATCHER = new AtomicReference();
    private static final AtomicReference<List<ResponseRenderer>> RESPONSE_RENDERERS = new AtomicReference(Collections.emptyList());
    protected final AJAXRequestDataTools defaultRequestDataTools = AJAXRequestDataTools.getInstance();
    protected final String lineSeparator = System.getProperty("line.separator");
    private static final Set<OXExceptionCode> IGNOREES = Collections.unmodifiableSet(new HashSet<OXExceptionCode>(Arrays.asList(new OXExceptionCode[]{OXFolderExceptionCode.NOT_EXISTS, MailExceptionCode.MAIL_NOT_FOUND})));

    public static void setDispatcher(Dispatcher dispatcher) {
        DISPATCHER.set(dispatcher);
    }

    public static Dispatcher getDispatcher() {
        return DISPATCHER.get();
    }

    public static void setPrefix(String prefix) {
        Dispatcher.PREFIX.set(prefix);
    }

    public static String getPrefix() {
        return Dispatcher.PREFIX.get();
    }

    protected AJAXRequestDataTools getAjaxRequestDataTools() {
        return this.defaultRequestDataTools;
    }

    public static void registerRenderer(ResponseRenderer renderer) {
        ArrayList<ResponseRenderer> update;
        List<ResponseRenderer> expect;
        do {
            expect = RESPONSE_RENDERERS.get();
            update = new ArrayList<ResponseRenderer>(expect);
            update.add(renderer);
            Collections.sort(update, new Comparator<ResponseRenderer>(){

                @Override
                public int compare(ResponseRenderer responseRenderer, ResponseRenderer anotherResponseRenderer) {
                    int anotherRanking;
                    int thisRanking = responseRenderer.getRanking();
                    return thisRanking < (anotherRanking = anotherResponseRenderer.getRanking()) ? 1 : (thisRanking == anotherRanking ? 0 : -1);
                }
            });
        } while (!RESPONSE_RENDERERS.compareAndSet(expect, update));
    }

    public static synchronized void unregisterRenderer(ResponseRenderer renderer) {
        ArrayList<ResponseRenderer> update;
        List<ResponseRenderer> expect;
        do {
            expect = RESPONSE_RENDERERS.get();
            update = new ArrayList<ResponseRenderer>(expect);
            update.remove(renderer);
            Collections.sort(update, new Comparator<ResponseRenderer>(){

                @Override
                public int compare(ResponseRenderer responseRenderer, ResponseRenderer anotherResponseRenderer) {
                    int anotherRanking;
                    int thisRanking = responseRenderer.getRanking();
                    return thisRanking < (anotherRanking = anotherResponseRenderer.getRanking()) ? 1 : (thisRanking == anotherRanking ? 0 : -1);
                }
            });
        } while (!RESPONSE_RENDERERS.compareAndSet(expect, update));
    }

    public static void clearRenderer() {
        RESPONSE_RENDERERS.set(Collections.emptyList());
    }

    @Override
    protected SessionResult<ServerSession> initializeSession(HttpServletRequest req, HttpServletResponse resp) throws OXException {
        ServerSession session = this.getSessionObject((ServletRequest)req, true);
        if (null != session) {
            return new SessionResult(Reply.CONTINUE, (Session)session);
        }
        SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (sessiondService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
        }
        String sessionId = req.getParameter("session");
        boolean sessionParamFound = sessionId != null && sessionId.length() > 0;
        Pair pair = null;
        boolean mayOmitSession = false;
        if (!SessionInspector.getInstance().getChain().isEmpty() && !sessionParamFound) {
            AJAXRequestDataTools requestDataTools = this.getAjaxRequestDataTools();
            String module = requestDataTools.getModule(Dispatcher.PREFIX.get(), req);
            String action = requestDataTools.getAction(req);
            pair = new Pair((Object)module, (Object)action);
            Dispatcher dispatcher = DISPATCHER.get();
            mayOmitSession = dispatcher.mayOmitSession(module, action);
            if (mayOmitSession) {
                return new SessionResult(Reply.CONTINUE, (Session)session);
            }
        }
        if (sessionParamFound) {
            SessionResult<ServerSession> result;
            try {
                result = SessionUtility.getSession(req, resp, sessionId, sessiondService);
            }
            catch (OXException e) {
                if (!SessionExceptionCodes.WRONG_SESSION_SECRET.equals(e)) {
                    throw e;
                }
                String wrongSecret = e.getProperty(SessionExceptionCodes.WRONG_SESSION_SECRET.name());
                if (!"null".equals(wrongSecret)) {
                    throw e;
                }
                result = SessionUtility.getSession(SessionUtility.getHashSource(), req, resp, sessionId, sessiondService, new NoSecretCallbackChecker(DISPATCHER.get(), e, this.getAjaxRequestDataTools()));
            }
            if (Reply.STOP == result.getReply()) {
                return result;
            }
            session = (ServerSession)result.getSession();
            if (null == session) {
                throw SessionExceptionCodes.SESSION_EXPIRED.create(new Object[]{sessionId});
            }
            SessionUtility.verifySession(req, sessiondService, sessionId, session);
            SessionUtility.rememberSession(req, session);
            SessionUtility.checkPublicSessionCookie(req, resp, session, sessiondService);
            sessionParamFound = true;
        }
        boolean mayUseFallbackSession = false;
        boolean mayPerformPublicSessionAuth = false;
        if (!sessionParamFound) {
            String action;
            String module;
            if (null == pair) {
                AJAXRequestDataTools requestDataTools = this.getAjaxRequestDataTools();
                module = requestDataTools.getModule(Dispatcher.PREFIX.get(), req);
                action = requestDataTools.getAction(req);
            } else {
                module = (String)pair.getFirst();
                action = (String)pair.getSecond();
            }
            Dispatcher dispatcher = DISPATCHER.get();
            mayOmitSession = dispatcher.mayOmitSession(module, action);
            mayUseFallbackSession = dispatcher.mayUseFallbackSession(module, action);
            mayPerformPublicSessionAuth = dispatcher.mayPerformPublicSessionAuth(module, action);
        }
        if (!mayOmitSession) {
            SessionUtility.findPublicSessionId(req, session, sessiondService, mayUseFallbackSession, mayPerformPublicSessionAuth);
        }
        return new SessionResult(Reply.CONTINUE, (Session)session);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, false);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, false);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, true);
    }

    private static boolean ignore(OXException e) {
        for (OXExceptionCode code : IGNOREES) {
            if (!code.equals(e)) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse, boolean preferStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleError(AJAXRequestResult result, HttpServletResponse httpServletResponse) throws IOException {
        int httpStatusCode = result.getHttpStatusCode();
        switch (httpStatusCode) {
            case 202: {
                httpServletResponse.setContentType(null);
                String retry_after = result.getHeader("Retry-After");
                if (Strings.isEmpty((String)retry_after)) break;
                httpServletResponse.addHeader("Retry-After", retry_after);
            }
        }
        httpServletResponse.sendError(result.getHttpStatusCode());
    }

    private void sendErrorAndPage(int statusCode, String statusMsg, HttpServletResponse httpResponse) throws IOException {
        try {
            httpResponse.setStatus(statusCode);
            this.writeErrorPage(statusCode, statusMsg, httpResponse);
        }
        catch (Exception x) {
            httpResponse.sendError(statusCode, null == statusMsg ? null : statusMsg.toString());
            this.flushSafe(httpResponse);
        }
    }

    private void logException(@Nullable Exception e) {
        this.logException(e, null, -1);
    }

    private void logException(@Nullable Exception e, @Nullable LogLevel logLevel) {
        this.logException(e, logLevel, -1);
    }

    private void logException(@Nullable Exception e, @Nullable LogLevel logLevel, int statusCode) {
        String msg;
        if (null == e) {
            return;
        }
        String string = msg = statusCode > 0 ? "Error processing request. Signaling HTTP error " + statusCode : "Error processing request.";
        if (null == logLevel) {
            LOG.error(msg, (Throwable)e);
            return;
        }
        switch (logLevel) {
            case TRACE: {
                LOG.trace(msg, (Throwable)e);
                break;
            }
            case DEBUG: {
                LOG.debug(msg, (Throwable)e);
                break;
            }
            case INFO: {
                LOG.info(msg, (Throwable)e);
                break;
            }
            case WARNING: {
                LOG.warn(msg, (Throwable)e);
                break;
            }
            default: {
                LOG.error(msg, (Throwable)e);
            }
        }
    }

    private ServerSession getSession(HttpServletRequest httpRequest, Dispatcher dispatcher, String module, String action) throws OXException {
        ServerSession session = SessionUtility.getSessionObject((ServletRequest)httpRequest, dispatcher.mayUseFallbackSession(module, action));
        if (session == null) {
            if (!dispatcher.mayOmitSession(module, action)) {
                if (dispatcher.mayUseFallbackSession(module, action)) {
                    String name = LoginServlet.getPublicSessionCookieName(httpRequest);
                    throw httpRequest.getCookies() == null ? AjaxExceptionCodes.MISSING_COOKIES.create(name) : AjaxExceptionCodes.MISSING_COOKIE.create(name);
                }
                throw AjaxExceptionCodes.MISSING_PARAMETER.create("session");
            }
            session = this.fakeSession();
        }
        return session;
    }

    private ServerSession fakeSession() {
        UserImpl user = new UserImpl();
        user.setAttributes(new HashMap<String, Set<String>>(1));
        return new ServerSessionAdapter(NO_SESSION, new ContextImpl(-1), user);
    }

    protected void sendResponse(AJAXRequestData requestData, AJAXRequestResult result, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        List<ResponseRenderer> responseRenderers = RESPONSE_RENDERERS.get();
        Iterator<ResponseRenderer> iter = responseRenderers.iterator();
        int i = responseRenderers.size();
        while (i-- > 0) {
            ResponseRenderer renderer = iter.next();
            if (!renderer.handles(requestData, result)) continue;
            renderer.write(requestData, result, httpRequest, httpResponse);
            return;
        }
        throw new IllegalStateException("No appropriate " + ResponseRenderer.class.getSimpleName() + " for request data/result pair.");
    }

    private void flushSafe(HttpServletResponse httpResponse) {
        try {
            try {
                Streams.flush((Flushable)httpResponse.getWriter());
            }
            catch (IllegalStateException e) {
                Streams.flush((Flushable)httpResponse.getOutputStream());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class NoSecretCallbackChecker
    implements SessionSecretChecker {
        private static final String PARAM_TOKEN = Session.PARAM_TOKEN;
        private final Dispatcher dispatcher;
        private final OXException e;
        private final AJAXRequestDataTools requestDataTools;

        protected NoSecretCallbackChecker(Dispatcher dispatcher, OXException e, AJAXRequestDataTools requestDataTools) {
            this.requestDataTools = requestDataTools;
            this.dispatcher = dispatcher;
            this.e = e;
        }

        public void checkSecret(Session session, HttpServletRequest req, String cookieHashSource) throws OXException {
            String action;
            String module = this.requestDataTools.getModule(Dispatcher.PREFIX.get(), req);
            boolean noSecretCallback = this.dispatcher.noSecretCallback(module, action = this.requestDataTools.getAction(req));
            if (!noSecretCallback) {
                throw this.e;
            }
            String paramToken = PARAM_TOKEN;
            String token = (String)session.getParameter(paramToken);
            session.setParameter(paramToken, null);
            if (null == token || !token.equals(req.getParameter(paramToken))) {
                throw this.e;
            }
        }
    }
}

