/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.SessionUtility;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.ajax.writer.LoginWriter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.user.UserService;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Tokens
implements LoginRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Tokens.class);
    private final LoginConfiguration conf;

    public Tokens(LoginConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.doTokens(req, resp);
        }
        catch (OXException e) {
            LoginServlet.logAndSendException(resp, e);
        }
    }

    private void doTokens(HttpServletRequest req, HttpServletResponse resp) throws OXException, IOException {
        Locale locale;
        String clientToken = LoginTools.parseParameter(req, "clientToken");
        String serverToken = LoginTools.parseParameter(req, "serverToken");
        String client = LoginTools.parseParameter(req, "client");
        String userAgent = req.getHeader("user-agent");
        ContextService contextService = ServerServiceRegistry.getInstance().getService(ContextService.class, false);
        UserService userService = ServerServiceRegistry.getInstance().getService(UserService.class, false);
        Session session = LoginPerformer.getInstance().lookupSessionWithTokens(clientToken, serverToken);
        if (!this.conf.isIpCheck()) {
            LoginTools.updateIPAddress(this.conf, req.getRemoteAddr(), session);
        } else {
            String newIP = req.getRemoteAddr();
            SessionUtility.checkIP(true, this.conf.getRanges(), session, newIP, this.conf.getIpCheckWhitelist());
            LoginTools.updateIPAddress(this.conf, newIP, session);
        }
        SessiondService service = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (null != service) {
            service.setClient(session.getSessionID(), client);
        }
        String hash = HashCalculator.getInstance().getHash(req, userAgent, client);
        if (null != service) {
            service.setHash(session.getSessionID(), hash);
        }
        if (null != contextService && null != userService) {
            Context context = contextService.getContext(session.getContextId());
            locale = userService.getUser(session.getUserId(), context).getLocale();
        } else {
            locale = Locale.US;
        }
        Response response = new Response();
        try {
            JSONObject json = new JSONObject();
            LoginWriter.write(session, json, locale);
            response.setData(json);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error("", (Throwable)oje);
            response.setException(oje);
        }
        Tools.disableCaching(resp);
        resp.setStatus(200);
        resp.setContentType("text/javascript; charset=UTF-8");
        LoginServlet.writeSecretCookie(req, resp, session, hash, req.isSecure(), req.getServerName(), this.conf);
        try {
            ResponseWriter.write(response, resp.getWriter(), locale);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
            resp.sendError(500);
        }
    }
}

