/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.exception.OXException;
import com.openexchange.tools.file.internal.AbstractHashingFileStorageTest;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;

public class HashingFileStorageTest
extends AbstractHashingFileStorageTest {
    public void testLifecycle() throws Exception {
        String data = "I am nice data";
        String fileId = this.fs.saveNewFile(this.IS(data));
        InputStream file = this.fs.getFile(fileId);
        InputStream compare = this.IS(data);
        int i = 0;
        while ((i = file.read()) != -1) {
            HashingFileStorageTest.assertEquals((int)i, (int)compare.read());
        }
        HashingFileStorageTest.assertEquals((int)-1, (int)compare.read());
        file.close();
        compare.close();
    }

    public void testListFiles() throws Exception {
        HashMap<String, Integer> files = new HashMap<String, Integer>();
        for (int i = 0; i < 10; ++i) {
            String data = "I am nice data in the file number " + i;
            String fileId = this.fs.saveNewFile(this.IS(data));
            files.put(fileId, i);
        }
        SortedSet fileList = this.fs.getFileList();
        HashingFileStorageTest.assertEquals((int)files.size(), (int)fileList.size());
        for (Map.Entry entry : files.entrySet()) {
            HashingFileStorageTest.assertTrue((String)((String)entry.getKey() + " missing in: " + fileList), (boolean)fileList.contains(entry.getKey()));
        }
    }

    public void testRemove() throws Exception {
        HashMap<String, Integer> files = new HashMap<String, Integer>();
        for (int i = 0; i < 10; ++i) {
            String data = "I am nice data in the file number " + i;
            String fileId = this.fs.saveNewFile(this.IS(data));
            files.put(fileId, i);
        }
        this.fs.remove();
        String[] list = this.tmpFile.list();
        HashingFileStorageTest.assertTrue((list == null || list.length == 0 ? 1 : 0) != 0);
    }

    public void testBug34249() throws Exception {
        ArrayList<String> files = new ArrayList<String>(100);
        for (int i = 1; i <= 100; ++i) {
            String content = "Content of file " + i;
            files.add(this.fs.saveNewFile(this.IS(content)));
        }
        for (String identifier : files) {
            this.fs.deleteFile(identifier);
        }
        String[] folders = this.fs.storage.list();
        HashingFileStorageTest.assertTrue((String)"Empty folders were not deleted", (folders.length == 0 ? 1 : 0) != 0);
    }

    public void testBug34249WithNonemptyFolders() throws Exception {
        ArrayList<String> files = new ArrayList<String>(100);
        for (int i = 1; i <= 100; ++i) {
            String content = "Content of file " + i;
            files.add(this.fs.saveNewFile(this.IS(content)));
        }
        int rnd = new Random(System.currentTimeMillis()).nextInt(99);
        String fileId = (String)files.get(rnd);
        File parent = new File(this.fs.storage.getAbsolutePath() + File.separatorChar + fileId);
        boolean tmpFile = new File(parent.getParent() + System.currentTimeMillis()).createNewFile();
        HashingFileStorageTest.assertTrue((String)"Could not create file", (boolean)tmpFile);
        for (String identifier : files) {
            this.fs.deleteFile(identifier);
        }
        String[] folders = this.fs.storage.list();
        HashingFileStorageTest.assertTrue((String)"Nonempty folders were deleted", (folders.length == 1 ? 1 : 0) != 0);
    }

    public void testReadUnknownID() {
        try {
            this.fs.getFile("fantasyName");
            HashingFileStorageTest.fail((String)"Could read unkown file");
        }
        catch (OXException oXException) {
            // empty catch block
        }
    }

    public void testDeleteUnknownID() throws Exception {
        HashingFileStorageTest.assertFalse((boolean)this.fs.deleteFile("fantasyName"));
    }

    public void testDeleteUnknownIDs() throws Exception {
        String data = "I am nice data";
        String fileId = this.fs.saveNewFile(this.IS(data));
        Set notDeleted = this.fs.deleteFiles(new String[]{"file1", fileId, "file2", "file3"});
        HashingFileStorageTest.assertEquals((int)3, (int)notDeleted.size());
        HashingFileStorageTest.assertTrue((boolean)notDeleted.contains("file1"));
        HashingFileStorageTest.assertTrue((boolean)notDeleted.contains("file2"));
        HashingFileStorageTest.assertTrue((boolean)notDeleted.contains("file3"));
    }
}

