/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login.internal;

import com.openexchange.authentication.Authenticated;
import com.openexchange.authentication.AuthenticationService;
import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.Header;
import com.openexchange.authentication.LoginInfo;
import com.openexchange.authentication.ResponseEnhancement;
import com.openexchange.authentication.ResultCode;
import com.openexchange.authentication.service.Authentication;
import com.openexchange.exception.OXException;
import com.openexchange.login.Interface;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginPerformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoginPerformerTest {
    private LoginPerformer performer;
    private TestAuthenticationService testAuthenticationService;
    Cookie testCookie;
    Header testHeader;
    private LoginRequest loginRequest;

    @Before
    public void setUp() {
        this.performer = LoginPerformer.getInstance();
        this.testAuthenticationService = new TestAuthenticationService();
        Authentication.setService((AuthenticationService)this.testAuthenticationService);
        this.testCookie = new Cookie(){

            public String getValue() {
                return "cookieValue";
            }

            public String getName() {
                return "cookieName";
            }
        };
        this.testHeader = new Header(){

            public String getValue() {
                return "headerValue";
            }

            public String getName() {
                return "headerName";
            }
        };
        this.loginRequest = new LoginRequest(){

            public boolean isTransient() {
                return false;
            }

            public boolean isSecure() {
                return false;
            }

            public String getVersion() {
                return null;
            }

            public String getUserAgent() {
                return null;
            }

            public int getServerPort() {
                return 0;
            }

            public String getServerName() {
                return null;
            }

            public String getPassword() {
                return null;
            }

            public String getLogin() {
                return null;
            }

            public Interface getInterface() {
                return Interface.HTTP_JSON;
            }

            public String getHttpSessionID() {
                return null;
            }

            public Map<String, List<String>> getHeaders() {
                return new HashMap<String, List<String>>(){
                    {
                        this.put(LoginPerformerTest.this.testHeader.getName(), new ArrayList<String>(){
                            {
                                this.add(LoginPerformerTest.this.testHeader.getValue());
                            }
                        });
                    }
                };
            }

            public String getHash() {
                return null;
            }

            public Cookie[] getCookies() {
                return new Cookie[]{LoginPerformerTest.this.testCookie};
            }

            public String getClientToken() {
                return null;
            }

            public String getClientIP() {
                return null;
            }

            public String getClient() {
                return null;
            }

            public String getAuthId() {
                return null;
            }
        };
    }

    @After
    public void tearDown() {
        this.loginRequest = null;
        this.testHeader = null;
        this.testCookie = null;
        Authentication.dropService((AuthenticationService)this.testAuthenticationService);
        this.testAuthenticationService = null;
        this.performer = null;
    }

    @Test
    public void testAutoLoginProperties() throws OXException {
        LoginResult result = this.performer.doAutoLogin(this.loginRequest);
        Cookie[] cookies = result.getCookies();
        Assert.assertNotNull((String)"Cookies should be passed through", (Object)cookies);
        Assert.assertEquals((String)"Exactly one cookie should be passed through", (long)1L, (long)cookies.length);
        Assert.assertEquals((String)"The same cookie should be passed through", (Object)this.testCookie, (Object)cookies[0]);
        Header[] headers = result.getHeaders();
        Assert.assertNotNull((String)"Headers should be passed through", (Object)headers);
        Assert.assertEquals((String)"Exactly one header should be passed through", (long)1L, (long)headers.length);
        Assert.assertEquals((String)"The same header should be passed through", (Object)this.testHeader.getName(), (Object)headers[0].getName());
        Assert.assertEquals((String)"The same header should be passed through", (Object)this.testHeader.getValue(), (Object)headers[0].getValue());
    }

    @Test
    public void testLoginProperties() throws OXException {
        LoginResult result = this.performer.doLogin(this.loginRequest);
        Cookie[] cookies = result.getCookies();
        Assert.assertNotNull((String)"Cookies should be passed through", (Object)cookies);
        Assert.assertEquals((String)"Exactly one cookie should be passed through", (long)1L, (long)cookies.length);
        Assert.assertEquals((String)"The same cookie should be passed through", (Object)this.testCookie, (Object)cookies[0]);
        Header[] headers = result.getHeaders();
        Assert.assertNotNull((String)"Headers should be passed through", (Object)headers);
        Assert.assertEquals((String)"Exactly one header should be passed through", (long)1L, (long)headers.length);
        Assert.assertEquals((String)"The same header should be passed through", (Object)this.testHeader.getName(), (Object)headers[0].getName());
        Assert.assertEquals((String)"The same header should be passed through", (Object)this.testHeader.getValue(), (Object)headers[0].getValue());
    }

    private static class TestAuthenticated
    implements Authenticated,
    ResponseEnhancement {
        private final Cookie[] cookies;
        private final List<Header> headers;

        public TestAuthenticated(Cookie[] cookies, List<Header> headers) {
            this.cookies = cookies;
            this.headers = headers;
        }

        public ResultCode getCode() {
            return ResultCode.REDIRECT;
        }

        public Header[] getHeaders() {
            return this.headers.toArray(new Header[this.headers.size()]);
        }

        public Cookie[] getCookies() {
            return this.cookies;
        }

        public String getRedirect() {
            return null;
        }

        public String getContextInfo() {
            return null;
        }

        public String getUserInfo() {
            return null;
        }
    }

    private static class TestAuthenticationService
    implements AuthenticationService {
        public Authenticated handleLoginInfo(LoginInfo loginInfo) {
            return this.handleAutoLoginInfo(loginInfo);
        }

        public Authenticated handleAutoLoginInfo(LoginInfo loginInfo) {
            Map properties = loginInfo.getProperties();
            Cookie[] cookies = (Cookie[])properties.get("cookies");
            Map headersMap = (Map)properties.get("headers");
            ArrayList<Header> headers = new ArrayList<Header>();
            for (final Map.Entry entry : headersMap.entrySet()) {
                headers.add(new Header(){

                    public String getName() {
                        return (String)entry.getKey();
                    }

                    public String getValue() {
                        return (String)((List)entry.getValue()).get(0);
                    }
                });
            }
            return new TestAuthenticated(cookies, headers);
        }
    }
}

