/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.MailAttachment;
import com.openexchange.mail.attachment.AttachmentToken;
import com.openexchange.mail.attachment.AttachmentTokenRegistry;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={AttachmentTokenRegistry.class, AttachmentToken.class})
public class MailAttachmentTest
extends TestCase {
    public MailAttachmentTest() {
    }

    public MailAttachmentTest(String name) {
        super(name);
    }

    public void testDoGet() {
        try {
            PowerMockito.mockStatic(AttachmentTokenRegistry.class, (Class[])new Class[0]);
            HttpServletRequest mockRequest = (HttpServletRequest)PowerMockito.mock(HttpServletRequest.class);
            HttpServletResponse mockResponse = (HttpServletResponse)PowerMockito.mock(HttpServletResponse.class);
            final ByteArrayOutputStream bout = new ByteArrayOutputStream(256);
            ServletOutputStream out = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    bout.write(b);
                }
            };
            PowerMockito.when((Object)mockResponse.getOutputStream()).thenReturn((Object)out);
            final AtomicReference cts = new AtomicReference();
            ((HttpServletResponse)PowerMockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    if ("content-type".equalsIgnoreCase((String)invocation.getArguments()[0])) {
                        cts.set((String)invocation.getArguments()[1]);
                    }
                    return null;
                }
            }).when((Object)mockResponse)).setHeader(Mockito.anyString(), Mockito.anyString());
            ((HttpServletResponse)PowerMockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    cts.set((String)invocation.getArguments()[0]);
                    return null;
                }
            }).when((Object)mockResponse)).setContentType(Mockito.anyString());
            final AtomicReference cds = new AtomicReference();
            ((HttpServletResponse)PowerMockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    if ("Content-Disposition".equalsIgnoreCase((String)invocation.getArguments()[0])) {
                        cds.set((String)invocation.getArguments()[1]);
                    }
                    return null;
                }
            }).when((Object)mockResponse)).setHeader(Mockito.anyString(), Mockito.anyString());
            PowerMockito.when((Object)mockRequest.getParameter("id")).thenReturn((Object)"123");
            PowerMockito.when((Object)mockRequest.getParameter("save")).thenReturn((Object)"1");
            PowerMockito.when((Object)mockRequest.getParameter("filter")).thenReturn(null);
            AttachmentTokenRegistry mockAttachmentTokenRegistry = (AttachmentTokenRegistry)PowerMockito.mock(AttachmentTokenRegistry.class);
            PowerMockito.when((Object)AttachmentTokenRegistry.getInstance()).thenReturn((Object)mockAttachmentTokenRegistry);
            AttachmentToken mockAttachmentToken = (AttachmentToken)PowerMockito.mock(AttachmentToken.class);
            PowerMockito.when((Object)mockAttachmentTokenRegistry.getToken("123")).thenReturn((Object)mockAttachmentToken);
            PowerMockito.when((Object)mockAttachmentToken.isCheckIp()).thenReturn((Object)Boolean.FALSE);
            PowerMockito.when((Object)mockAttachmentToken.isOneTime()).thenReturn((Object)Boolean.FALSE);
            MailPart mockMailPart = (MailPart)PowerMockito.mock(MailPart.class);
            PowerMockito.when((Object)mockAttachmentToken.getAttachment()).thenReturn((Object)mockMailPart);
            PowerMockito.when((Object)mockMailPart.getContentType()).thenReturn((Object)new ContentType("application/zip; name=archive.zip"));
            PowerMockito.when((Object)mockMailPart.getContentDisposition()).thenReturn((Object)new ContentDisposition("attachment; filename=archive.zip"));
            PowerMockito.when((Object)mockMailPart.getFileName()).thenReturn((Object)"archive.zip");
            PowerMockito.when((Object)mockMailPart.containsContentType()).thenReturn((Object)true);
            byte[] bytes = new byte[127];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)i;
            }
            PowerMockito.when((Object)mockMailPart.getInputStream()).thenReturn((Object)new ByteArrayInputStream(bytes));
            new MailAttachment().doGet(mockRequest, mockResponse);
            byte[] byteArray = bout.toByteArray();
            int length = byteArray.length;
            MailAttachmentTest.assertEquals((String)"Unexpected number of bytes written to ServletOutputStream.", (int)127, (int)length);
            for (int i = 0; i < length; ++i) {
                MailAttachmentTest.assertEquals((String)"Unexpected byte written to ServletOutputStream.", (byte)((byte)i), (byte)byteArray[i]);
            }
            MailAttachmentTest.assertEquals((String)"Unexpected Content-Type.", (String)"application/zip", (String)((String)cts.get()));
            MailAttachmentTest.assertTrue((String)"Unexpected Content-Disposition.", (null != cds.get() && ((String)cds.get()).startsWith("attachment") ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            MailAttachmentTest.fail((String)e.getMessage());
        }
    }
}

