/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.internal;

import com.openexchange.context.ContextService;
import com.openexchange.crypto.CryptoService;
import com.openexchange.database.DatabaseService;
import com.openexchange.datatypes.genericonf.storage.GenericConfigurationStorageService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.java.Strings;
import com.openexchange.messaging.MessagingAccount;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.messaging.MessagingService;
import com.openexchange.messaging.generic.DefaultMessagingAccount;
import com.openexchange.messaging.generic.internal.CachingMessagingAccountStorage;
import com.openexchange.messaging.generic.internal.GenericProperty;
import com.openexchange.messaging.generic.internal.MessagingAccountStorage;
import com.openexchange.messaging.generic.internal.Modifier;
import com.openexchange.messaging.generic.services.MessagingGenericServiceRegistry;
import com.openexchange.messaging.registry.MessagingServiceRegistry;
import com.openexchange.secret.SecretEncryptionFactoryService;
import com.openexchange.secret.SecretEncryptionService;
import com.openexchange.secret.SecretEncryptionStrategy;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RdbMessagingAccountStorage
implements MessagingAccountStorage,
SecretEncryptionStrategy<GenericProperty> {
    private static final Class<DatabaseService> CLAZZ_DB = DatabaseService.class;
    private static final Class<GenericConfigurationStorageService> CLAZZ_GEN_CONF = GenericConfigurationStorageService.class;
    private static final RdbMessagingAccountStorage INSTANCE = new RdbMessagingAccountStorage();
    private static final String SQL_SELECT = "SELECT confId, displayName FROM messagingAccount WHERE cid = ? AND user = ? AND serviceId = ? AND account = ?";
    private static final String SQL_SELECT_CONFIDS_FOR_USER = "SELECT confId, account FROM messagingAccount WHERE cid = ? AND user = ? AND serviceId = ?";
    private static final String SQL_SELECT_ACCOUNTS = "SELECT account, confId, displayName FROM messagingAccount WHERE cid = ? AND user = ? AND serviceId = ?";
    private static final String SQL_INSERT = "INSERT INTO messagingAccount (cid, user, account, confId, serviceId, displayName) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String SQL_DELETE = "DELETE FROM messagingAccount WHERE cid = ? AND user = ? AND serviceId = ? AND account = ?";
    private static final String SQL_UPDATE = "UPDATE messagingAccount SET displayName = ? WHERE cid = ? AND user = ? AND serviceId = ? AND account = ?";
    private static final String ACCOUNT_EXISTS = "SELECT 1 FROM messagingAccount WHERE cid = ? AND user = ? LIMIT 1";

    public static RdbMessagingAccountStorage getInstance() {
        return INSTANCE;
    }

    private RdbMessagingAccountStorage() {
    }

    @Override
    public MessagingAccount getAccount(String serviceId, int id, Session session, Modifier modifier) throws OXException {
        MessagingAccount messagingAccount;
        DatabaseService databaseService = RdbMessagingAccountStorage.getService(CLAZZ_DB);
        int contextId = session.getContextId();
        Connection rc = databaseService.getReadOnly(contextId);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = rc.prepareStatement(SQL_SELECT);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, session.getUserId());
            stmt.setString(pos++, serviceId);
            stmt.setInt(pos, id);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw MessagingExceptionCodes.ACCOUNT_NOT_FOUND.create(new Object[]{id, serviceId, session.getUserId(), contextId});
            }
            MessagingServiceRegistry registry = RdbMessagingAccountStorage.getService(MessagingServiceRegistry.class);
            if (null == registry) {
                throw MessagingExceptionCodes.ACCOUNT_NOT_FOUND.create(new Object[]{id, serviceId, session.getUserId(), contextId});
            }
            MessagingService messagingService = registry.getMessagingService(serviceId, session.getUserId(), session.getContextId());
            DefaultMessagingAccount account = new DefaultMessagingAccount();
            account.setId(id);
            account.setMessagingService(messagingService);
            account.setDisplayName(rs.getString(2));
            GenericConfigurationStorageService genericConfStorageService = RdbMessagingAccountStorage.getService(CLAZZ_GEN_CONF);
            HashMap<String, Object> configuration = new HashMap<String, Object>();
            int confId = rs.getInt(1);
            genericConfStorageService.fill(rc, RdbMessagingAccountStorage.getContext(session), confId, configuration);
            Set secretPropNames = messagingService.getSecretProperties();
            if (!secretPropNames.isEmpty()) {
                for (String passwordElementName : secretPropNames) {
                    String toDecrypt = (String)configuration.get(passwordElementName);
                    if (null == toDecrypt) continue;
                    try {
                        String decrypted = this.decrypt(toDecrypt, serviceId, id, session, confId, passwordElementName);
                        configuration.put(passwordElementName, decrypted);
                    }
                    catch (OXException x) {
                        configuration.put(passwordElementName, "");
                    }
                }
            }
            account.setConfiguration(configuration);
            messagingAccount = modifier.modifyOutgoing(account);
        }
        catch (SQLException e) {
            try {
                throw MessagingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, (Statement)stmt);
                databaseService.backReadOnly(contextId, rc);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        databaseService.backReadOnly(contextId, rc);
        return messagingAccount;
    }

    @Override
    public List<MessagingAccount> getAccounts(String serviceId, Session session, Modifier modifier) throws OXException {
        List<MessagingAccount> list;
        DatabaseService databaseService = RdbMessagingAccountStorage.getService(CLAZZ_DB);
        int contextId = session.getContextId();
        Connection rc = databaseService.getReadOnly(contextId);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            List<MessagingAccount> accounts;
            stmt = rc.prepareStatement(SQL_SELECT_ACCOUNTS);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, session.getUserId());
            stmt.setString(pos, serviceId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                accounts = new ArrayList(4);
                GenericConfigurationStorageService genericConfStorageService = RdbMessagingAccountStorage.getService(CLAZZ_GEN_CONF);
                MessagingServiceRegistry registry = RdbMessagingAccountStorage.getService(MessagingServiceRegistry.class);
                MessagingService messagingService = registry.getMessagingService(serviceId, session.getUserId(), session.getContextId());
                do {
                    DefaultMessagingAccount account = new DefaultMessagingAccount();
                    account.setDisplayName(rs.getString(3));
                    HashMap<String, Object> configuration = new HashMap<String, Object>();
                    genericConfStorageService.fill(rc, RdbMessagingAccountStorage.getContext(session), rs.getInt(2), configuration);
                    account.setConfiguration(configuration);
                    account.setId(rs.getInt(1));
                    account.setMessagingService(messagingService);
                    accounts.add(modifier.modifyOutgoing(account));
                } while (rs.next());
            } else {
                accounts = Collections.emptyList();
            }
            list = accounts;
        }
        catch (SQLException e) {
            try {
                throw MessagingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, (Statement)stmt);
                databaseService.backReadOnly(contextId, rc);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        databaseService.backReadOnly(contextId, rc);
        return list;
    }

    public TIntArrayList getAccountIDs(String serviceId, Session session) throws OXException {
        TIntArrayList tIntArrayList;
        DatabaseService databaseService = RdbMessagingAccountStorage.getService(CLAZZ_DB);
        if (null == databaseService) {
            throw ServiceExceptionCode.serviceUnavailable(CLAZZ_DB);
        }
        int contextId = session.getContextId();
        Connection rc = databaseService.getReadOnly(contextId);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            TIntArrayList accounts;
            stmt = rc.prepareStatement("SELECT account FROM messagingAccount WHERE cid = ? AND user = ? AND serviceId = ?");
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, session.getUserId());
            stmt.setString(pos, serviceId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                accounts = new TIntArrayList(4);
                do {
                    accounts.add(rs.getInt(1));
                } while (rs.next());
            } else {
                accounts = new TIntArrayList(0);
            }
            tIntArrayList = accounts;
        }
        catch (SQLException e) {
            try {
                throw MessagingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, (Statement)stmt);
                databaseService.backReadOnly(contextId, rc);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        databaseService.backReadOnly(contextId, rc);
        return tIntArrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int addAccount(String serviceId, MessagingAccount account, Session session, Modifier modifier) throws OXException {
        int n;
        Connection wc;
        DatabaseService databaseService = RdbMessagingAccountStorage.getService(CLAZZ_DB);
        int contextId = session.getContextId();
        try {
            wc = databaseService.getWritable(contextId);
            wc.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw MessagingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        PreparedStatement stmt = null;
        try {
            modifier.modifyIncoming(account);
            GenericConfigurationStorageService genericConfStorageService = RdbMessagingAccountStorage.getService(CLAZZ_GEN_CONF);
            HashMap<String, String> configuration = new HashMap<String, String>(account.getConfiguration());
            MessagingService messagingService = RdbMessagingAccountStorage.getService(MessagingServiceRegistry.class).getMessagingService(serviceId, session.getUserId(), session.getContextId());
            Set secretPropNames = messagingService.getSecretProperties();
            if (!secretPropNames.isEmpty()) {
                for (String passwordElementName : secretPropNames) {
                    String toCrypt = (String)configuration.get(passwordElementName);
                    if (null == toCrypt) continue;
                    String encrypted = this.encrypt(toCrypt, session);
                    configuration.put(passwordElementName, encrypted);
                }
            }
            int genericConfId = genericConfStorageService.save(wc, RdbMessagingAccountStorage.getContext(session), configuration);
            stmt = wc.prepareStatement(SQL_INSERT);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, session.getUserId());
            stmt.setInt(pos++, genericConfId);
            stmt.setInt(pos++, genericConfId);
            stmt.setString(pos++, serviceId);
            stmt.setString(pos, account.getDisplayName());
            stmt.executeUpdate();
            wc.commit();
            n = genericConfId;
        }
        catch (OXException e) {
            try {
                DBUtils.rollback((Connection)wc);
                throw e;
                catch (SQLException e2) {
                    DBUtils.rollback((Connection)wc);
                    throw MessagingExceptionCodes.SQL_ERROR.create((Throwable)e2, new Object[]{e2.getMessage()});
                }
                catch (RuntimeException e3) {
                    DBUtils.rollback((Connection)wc);
                    throw MessagingExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e3, new Object[]{e3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                DBUtils.autocommit((Connection)wc);
                databaseService.backWritable(contextId, wc);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff((Statement)stmt);
        DBUtils.autocommit((Connection)wc);
        databaseService.backWritable(contextId, wc);
        return n;
    }

    public void update(String recrypted, GenericProperty prop) throws OXException {
        HashMap<String, String> update = new HashMap<String, String>();
        update.put(prop.propertyName, recrypted);
        GenericConfigurationStorageService genericConfStorageService = RdbMessagingAccountStorage.getService(CLAZZ_GEN_CONF);
        Session session = prop.session;
        genericConfStorageService.update(RdbMessagingAccountStorage.getContext(session), prop.confId, update);
        try {
            CachingMessagingAccountStorage.getInstance().invalidate(prop.serviceId, prop.id, session.getUserId(), session.getContextId());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private String encrypt(String toCrypt, Session session) throws OXException {
        SecretEncryptionService encryptionService = RdbMessagingAccountStorage.getService(SecretEncryptionFactoryService.class).createService((SecretEncryptionStrategy)this);
        return encryptionService.encrypt(session, toCrypt);
    }

    private String decrypt(String toDecrypt, String serviceId, int id, Session session, int confId, String propertyName) throws OXException {
        SecretEncryptionService encryptionService = RdbMessagingAccountStorage.getService(SecretEncryptionFactoryService.class).createService((SecretEncryptionStrategy)this);
        return encryptionService.decrypt(session, toDecrypt, (Object)new GenericProperty(confId, propertyName, serviceId, id, session));
    }

    @Override
    public void deleteAccount(String serviceId, MessagingAccount account, Session session, Modifier modifier) throws OXException {
        this.deleteAccounts(serviceId, new MessagingAccount[]{account}, new int[]{0}, session, modifier);
    }

    public void deleteAccounts(String serviceId, MessagingAccount[] accounts, int[] genericConfIds, Session session, Modifier optModifier) throws OXException {
        Connection wc;
        DatabaseService databaseService = RdbMessagingAccountStorage.getService(CLAZZ_DB);
        int contextId = session.getContextId();
        try {
            wc = databaseService.getWritable(contextId);
            wc.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw MessagingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        boolean committed = false;
        try {
            for (int i = 0; i < accounts.length; ++i) {
                MessagingAccount account = accounts[i];
                if (null != optModifier) {
                    optModifier.modifyIncoming(account);
                }
                int accountId = account.getId();
                GenericConfigurationStorageService genericConfStorageService = RdbMessagingAccountStorage.getService(CLAZZ_GEN_CONF);
                int genericConfId = genericConfIds[i];
                if (genericConfId <= 0) {
                    genericConfId = RdbMessagingAccountStorage.getGenericConfId(contextId, session.getUserId(), serviceId, accountId, wc);
                }
                genericConfStorageService.delete(wc, RdbMessagingAccountStorage.getContext(session), genericConfId);
                PreparedStatement stmt = null;
                try {
                    stmt = wc.prepareStatement(SQL_DELETE);
                    int pos = 1;
                    stmt.setInt(pos++, contextId);
                    stmt.setInt(pos++, session.getUserId());
                    stmt.setString(pos++, serviceId);
                    stmt.setInt(pos, accountId);
                    stmt.executeUpdate();
                    continue;
                }
                catch (SQLException e) {
                    throw MessagingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                finally {
                    DBUtils.closeSQLStuff((Statement)stmt);
                }
            }
            wc.commit();
            committed = true;
        }
        catch (SQLException e) {
            throw MessagingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (RuntimeException e) {
            throw MessagingExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            if (!committed) {
                DBUtils.rollback((Connection)wc);
            }
            DBUtils.autocommit((Connection)wc);
            databaseService.backWritable(contextId, wc);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateAccount(String serviceId, MessagingAccount account, Session session, Modifier modifier) throws OXException {
        Connection wc;
        DatabaseService databaseService = RdbMessagingAccountStorage.getService(CLAZZ_DB);
        int contextId = session.getContextId();
        try {
            wc = databaseService.getWritable(contextId);
            wc.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw MessagingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        PreparedStatement stmt = null;
        try {
            String displayName;
            modifier.modifyIncoming(account);
            HashMap<String, String> configuration = account.getConfiguration();
            if (null != configuration) {
                configuration = new HashMap<String, String>(configuration);
                GenericConfigurationStorageService genericConfStorageService = RdbMessagingAccountStorage.getService(CLAZZ_GEN_CONF);
                int genericConfId = RdbMessagingAccountStorage.getGenericConfId(contextId, session.getUserId(), serviceId, account.getId(), wc);
                MessagingService messagingService = RdbMessagingAccountStorage.getService(MessagingServiceRegistry.class).getMessagingService(serviceId, session.getUserId(), session.getContextId());
                Set secretPropNames = messagingService.getSecretProperties();
                if (!secretPropNames.isEmpty()) {
                    for (String passwordElementName : secretPropNames) {
                        String toCrypt = (String)configuration.get(passwordElementName);
                        if (null == toCrypt) continue;
                        String encrypted = this.encrypt(toCrypt, session);
                        configuration.put(passwordElementName, encrypted);
                    }
                }
                genericConfStorageService.update(wc, RdbMessagingAccountStorage.getContext(session), genericConfId, configuration);
            }
            if (null != (displayName = account.getDisplayName())) {
                stmt = wc.prepareStatement(SQL_UPDATE);
                int pos = 1;
                stmt.setString(pos++, displayName);
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, session.getUserId());
                stmt.setString(pos++, serviceId);
                stmt.setInt(pos, account.getId());
                stmt.executeUpdate();
            }
            wc.commit();
        }
        catch (OXException e) {
            try {
                DBUtils.rollback((Connection)wc);
                throw e;
                catch (SQLException e2) {
                    DBUtils.rollback((Connection)wc);
                    throw MessagingExceptionCodes.SQL_ERROR.create((Throwable)e2, new Object[]{e2.getMessage()});
                }
                catch (RuntimeException e3) {
                    DBUtils.rollback((Connection)wc);
                    throw MessagingExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e3, new Object[]{e3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                DBUtils.autocommit((Connection)wc);
                databaseService.backWritable(contextId, wc);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff((Statement)stmt);
        DBUtils.autocommit((Connection)wc);
        databaseService.backWritable(contextId, wc);
    }

    private static <S> S getService(Class<? extends S> clazz) throws OXException {
        try {
            return MessagingGenericServiceRegistry.getService(clazz);
        }
        catch (RuntimeException e) {
            throw new OXException((Throwable)e);
        }
    }

    private static Context getContext(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getContext();
        }
        return RdbMessagingAccountStorage.getService(ContextService.class).getContext(session.getContextId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getGenericConfId(int contextId, int userId, String serviceId, int accountId, Connection con) throws OXException, SQLException {
        int n;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(SQL_SELECT);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setString(pos++, serviceId);
            stmt.setInt(pos, accountId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw MessagingExceptionCodes.ACCOUNT_NOT_FOUND.create(new Object[]{accountId, serviceId, userId, contextId});
            }
            n = rs.getInt(1);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, (Statement)stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return n;
    }

    public String checkSecretCanDecryptStrings(MessagingService parentService, Session session, String secret) throws OXException {
        Set secretProperties = parentService.getSecretProperties();
        if (secretProperties.isEmpty()) {
            return null;
        }
        TIntList confIds = this.getConfIdsForUser(session.getContextId(), session.getUserId(), parentService.getId());
        GenericConfigurationStorageService genericConfStorageService = RdbMessagingAccountStorage.getService(CLAZZ_GEN_CONF);
        CryptoService cryptoService = RdbMessagingAccountStorage.getService(CryptoService.class);
        Context ctx = RdbMessagingAccountStorage.getContext(session);
        HashMap content = new HashMap();
        int confId = -1;
        int size = confIds.size();
        for (int i = 0; i < size; ++i) {
            confId = confIds.get(i);
            content.clear();
            genericConfStorageService.fill(ctx, confId, content);
            for (String field : secretProperties) {
                String encrypted = (String)content.get(field);
                if (encrypted == null) continue;
                cryptoService.decrypt(encrypted, secret);
            }
        }
        return null;
    }

    private TIntIntMap getConfIdToAccountMappingForUser(int contextId, int userId, String serviceId) throws OXException {
        TIntIntHashMap tIntIntHashMap;
        DatabaseService databaseService = RdbMessagingAccountStorage.getService(CLAZZ_DB);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = databaseService.getReadOnly(contextId);
            stmt = con.prepareStatement(SQL_SELECT_CONFIDS_FOR_USER);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setString(pos++, serviceId);
            rs = stmt.executeQuery();
            TIntIntHashMap ret = new TIntIntHashMap(16);
            while (rs.next()) {
                ret.put(rs.getInt(1), rs.getInt(2));
            }
            tIntIntHashMap = ret;
        }
        catch (SQLException e) {
            try {
                throw MessagingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (con != null) {
                    databaseService.backReadOnly(contextId, con);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        if (con != null) {
            databaseService.backReadOnly(contextId, con);
        }
        return tIntIntHashMap;
    }

    private TIntList getConfIdsForUser(int contextId, int userId, String serviceId) throws OXException {
        TIntArrayList tIntArrayList;
        DatabaseService databaseService = RdbMessagingAccountStorage.getService(CLAZZ_DB);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = databaseService.getReadOnly(contextId);
            stmt = con.prepareStatement(SQL_SELECT_CONFIDS_FOR_USER);
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setString(pos++, serviceId);
            rs = stmt.executeQuery();
            TIntArrayList ret = new TIntArrayList(16);
            while (rs.next()) {
                ret.add(rs.getInt(1));
            }
            tIntArrayList = ret;
        }
        catch (SQLException e) {
            try {
                throw MessagingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (con != null) {
                    databaseService.backReadOnly(contextId, con);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        if (con != null) {
            databaseService.backReadOnly(contextId, con);
        }
        return tIntArrayList;
    }

    public void migrateToNewSecret(MessagingService parentService, String oldSecret, String newSecret, Session session) throws OXException {
        Set secretProperties = parentService.getSecretProperties();
        if (secretProperties.isEmpty()) {
            return;
        }
        TIntList confIds = this.getConfIdsForUser(session.getContextId(), session.getUserId(), parentService.getId());
        GenericConfigurationStorageService genericConfStorageService = RdbMessagingAccountStorage.getService(CLAZZ_GEN_CONF);
        CryptoService cryptoService = RdbMessagingAccountStorage.getService(CryptoService.class);
        Context ctx = RdbMessagingAccountStorage.getContext(session);
        HashMap content = new HashMap();
        HashMap<String, String> update = new HashMap<String, String>();
        int size = confIds.size();
        for (int i = 0; i < size; ++i) {
            int confId = confIds.get(i);
            content.clear();
            genericConfStorageService.fill(ctx, confId, content);
            update.clear();
            for (String field : secretProperties) {
                String encrypted = (String)content.get(field);
                if (RdbMessagingAccountStorage.isEmpty(encrypted)) continue;
                try {
                    cryptoService.decrypt(encrypted, newSecret);
                }
                catch (OXException x) {
                    String transcripted = cryptoService.encrypt(cryptoService.decrypt(encrypted, oldSecret), newSecret);
                    update.put(field, transcripted);
                }
            }
            if (update.isEmpty()) continue;
            genericConfStorageService.update(ctx, confId, update);
        }
    }

    public boolean hasAccount(MessagingService parentService, Session session) throws OXException {
        boolean bl;
        Set secretProperties = parentService.getSecretProperties();
        if (secretProperties.isEmpty()) {
            return false;
        }
        DatabaseService databaseService = RdbMessagingAccountStorage.getService(CLAZZ_DB);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = databaseService.getReadOnly(session.getContextId());
            stmt = con.prepareStatement(ACCOUNT_EXISTS);
            int pos = 1;
            stmt.setInt(pos++, session.getContextId());
            stmt.setInt(pos++, session.getUserId());
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw MessagingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (con != null) {
                    databaseService.backReadOnly(session.getContextId(), con);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        if (con != null) {
            databaseService.backReadOnly(session.getContextId(), con);
        }
        return bl;
    }

    public void cleanUp(MessagingService parentService, String secret, Session session) throws OXException {
        Set secretProperties = parentService.getSecretProperties();
        if (secretProperties.isEmpty()) {
            return;
        }
        String serviceId = parentService.getId();
        TIntIntMap confId2AccountMap = this.getConfIdToAccountMappingForUser(session.getContextId(), session.getUserId(), serviceId);
        GenericConfigurationStorageService genericConfStorageService = RdbMessagingAccountStorage.getService(CLAZZ_GEN_CONF);
        CryptoService cryptoService = RdbMessagingAccountStorage.getService(CryptoService.class);
        Context ctx = RdbMessagingAccountStorage.getContext(session);
        HashMap content = new HashMap();
        HashMap<String, String> update = new HashMap<String, String>();
        for (int confId : confId2AccountMap.keys()) {
            content.clear();
            genericConfStorageService.fill(ctx, confId, content);
            update.clear();
            for (Map.Entry entry : content.entrySet()) {
                String encrypted;
                String field = (String)entry.getKey();
                if (!secretProperties.contains(field) || RdbMessagingAccountStorage.isEmpty(encrypted = entry.getValue().toString())) continue;
                try {
                    cryptoService.decrypt(encrypted, secret);
                }
                catch (OXException x) {
                    update.put(field, "");
                }
            }
            if (update.isEmpty()) continue;
            genericConfStorageService.update(ctx, confId, update);
        }
    }

    public void removeUnrecoverableItems(MessagingService parentService, String secret, Session session) throws OXException {
        Set secretProperties = parentService.getSecretProperties();
        if (secretProperties.isEmpty()) {
            return;
        }
        String serviceId = parentService.getId();
        TIntIntMap confId2AccountMap = this.getConfIdToAccountMappingForUser(session.getContextId(), session.getUserId(), serviceId);
        GenericConfigurationStorageService genericConfStorageService = RdbMessagingAccountStorage.getService(CLAZZ_GEN_CONF);
        CryptoService cryptoService = RdbMessagingAccountStorage.getService(CryptoService.class);
        Context ctx = RdbMessagingAccountStorage.getContext(session);
        HashMap content = new HashMap();
        ArrayList<DefaultMessagingAccount> accountsToDelete = new ArrayList<DefaultMessagingAccount>(confId2AccountMap.size());
        TIntArrayList confIdsToDelete = new TIntArrayList(confId2AccountMap.size());
        for (int confId : confId2AccountMap.keys()) {
            content.clear();
            genericConfStorageService.fill(ctx, confId, content);
            for (Map.Entry entry : content.entrySet()) {
                String encrypted;
                String field = (String)entry.getKey();
                if (!secretProperties.contains(field) || RdbMessagingAccountStorage.isEmpty(encrypted = entry.getValue().toString())) continue;
                try {
                    cryptoService.decrypt(encrypted, secret);
                }
                catch (OXException x) {
                    if (confIdsToDelete.contains(confId)) continue;
                    confIdsToDelete.add(confId);
                    DefaultMessagingAccount account = new DefaultMessagingAccount();
                    account.setId(confId2AccountMap.get(confId));
                    account.setServiceId(serviceId);
                    account.setMessagingService(parentService);
                    accountsToDelete.add(account);
                }
            }
        }
        this.deleteAccounts(serviceId, accountsToDelete.toArray(new MessagingAccount[accountsToDelete.size()]), confIdsToDelete.toArray(), session, null);
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }
}

