/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log;

import ch.qos.logback.classic.util.LogbackMDCAdapter;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.log.Props;
import com.openexchange.session.Session;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

public final class LogProperties {
    private static final ConcurrentMap<Class<? extends MDCAdapter>, Field> FIELD_CACHE = new ConcurrentHashMap<Class<? extends MDCAdapter>, Field>(4);

    private LogProperties() {
    }

    private static InheritableThreadLocal<Map<String, String>> getPropertiesMap(MDCAdapter mdcAdapter) throws OXException {
        try {
            Class<?> clazz = mdcAdapter.getClass();
            Field field = (Field)FIELD_CACHE.get(clazz);
            if (null == field) {
                for (Field f : clazz.getDeclaredFields()) {
                    Class<?> fieldClazz = f.getType();
                    if (!InheritableThreadLocal.class.isAssignableFrom(fieldClazz)) continue;
                    field = f;
                    break;
                }
                if (null == field) {
                    throw new NoSuchFieldException("InheritableThreadLocal");
                }
            }
            return (InheritableThreadLocal)field.get(mdcAdapter);
        }
        catch (SecurityException e) {
            throw OXException.general(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw OXException.general(e.getMessage(), e);
        }
        catch (NoSuchFieldException e) {
            throw OXException.general(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw OXException.general(e.getMessage(), e);
        }
    }

    public static Map<String, String> getPropertyMap() {
        try {
            MDCAdapter mdcAdapter = MDC.getMDCAdapter();
            if (mdcAdapter instanceof LogbackMDCAdapter) {
                return ((LogbackMDCAdapter)mdcAdapter).getPropertyMap();
            }
            Logger logger = LoggerFactory.getLogger(LogProperties.class);
            logger.warn("Unexpected MDC adapter: {}", (Object)mdcAdapter.getClass().getName());
            return Collections.unmodifiableMap((Map)LogProperties.getPropertiesMap(mdcAdapter).get());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void removeLogProperties() {
        MDC.clear();
    }

    public static void putProperties(Object ... args) {
        if (null == args) {
            return;
        }
        int length = args.length;
        if (length % 2 != 0) {
            return;
        }
        for (int i = 0; i < length; i += 2) {
            Name name = (Name)((Object)args[i]);
            Object arg = args[i + 1];
            if (null == arg) continue;
            MDC.put((String)name.getName(), (String)arg.toString());
        }
    }

    public static void putSessionProperties(Session session) {
        if (null == session) {
            return;
        }
        MDC.put((String)Name.SESSION_SESSION_ID.getName(), (String)LogProperties.getLoggableString(session.getSessionID()));
        MDC.put((String)Name.SESSION_AUTH_ID.getName(), (String)LogProperties.getLoggableString(session.getAuthId()));
        MDC.put((String)Name.SESSION_USER_ID.getName(), (String)Integer.toString(session.getUserId()));
        MDC.put((String)Name.SESSION_USER_NAME.getName(), (String)LogProperties.getLoggableString(session.getLogin()));
        MDC.put((String)Name.SESSION_LOGIN_NAME.getName(), (String)LogProperties.getLoggableString(session.getLoginName()));
        MDC.put((String)Name.SESSION_CONTEXT_ID.getName(), (String)Integer.toString(session.getContextId()));
        String client = session.getClient();
        MDC.put((String)Name.SESSION_CLIENT_ID.getName(), (String)(client == null ? "unknown" : client));
    }

    public static void removeSessionProperties() {
        MDC.remove((String)Name.SESSION_SESSION_ID.getName());
        MDC.remove((String)Name.SESSION_AUTH_ID.getName());
        MDC.remove((String)Name.SESSION_USER_ID.getName());
        MDC.remove((String)Name.SESSION_USER_NAME.getName());
        MDC.remove((String)Name.SESSION_LOGIN_NAME.getName());
        MDC.remove((String)Name.SESSION_CONTEXT_ID.getName());
        MDC.remove((String)Name.SESSION_CLIENT_ID.getName());
    }

    private static String getLoggableString(String str) {
        return null == str ? "" : str;
    }

    public static String get(Name name) {
        return LogProperties.getLogProperty(name);
    }

    public static String getLogProperty(Name name) {
        if (null == name) {
            return null;
        }
        return MDC.get((String)name.getName());
    }

    public static String[] getTempFileProperty() {
        String str = MDC.get((String)Name.TEMP_FILE.getName());
        return null == str ? null : Strings.splitByComma((String)str);
    }

    public static void appendTempFileProperty(File tempFile) {
        if (null == tempFile) {
            return;
        }
        LogProperties.appendTempFileProperty(tempFile.getPath());
    }

    public static void appendTempFileProperty(String tempFilePath) {
        if (null == tempFilePath) {
            return;
        }
        String prev = MDC.get((String)Name.TEMP_FILE.getName());
        MDC.put((String)Name.TEMP_FILE.getName(), (String)(null == prev ? tempFilePath : new StringBuffer(prev).append(',').append(tempFilePath).toString()));
    }

    public static void append(Name name, String value) {
        if (null == name || null == value) {
            return;
        }
        String prev = MDC.get((String)name.getName());
        MDC.put((String)name.getName(), (String)(null == prev ? value : new StringBuffer(prev).append(',').append(value).toString()));
    }

    public static void remove(Name name) {
        LogProperties.removeProperty(name);
    }

    public static void removeTempFileProperty() {
        MDC.remove((String)Name.TEMP_FILE.getName());
    }

    public static void removeProperty(Name name) {
        if (null != name) {
            MDC.remove((String)name.getName());
        }
    }

    public static void removeProperties(Name ... names) {
        if (null != names) {
            for (Name name : names) {
                MDC.remove((String)name.getName());
            }
        }
    }

    public static void removeProperties(Collection<Name> names) {
        if (null != names) {
            for (Name name : names) {
                MDC.remove((String)name.getName());
            }
        }
    }

    public static void put(Name name, Object value) {
        LogProperties.putProperty(name, value);
    }

    public static void putProperty(Name name, Object value) {
        if (null == name) {
            return;
        }
        if (null == value) {
            MDC.remove((String)name.getName());
        } else {
            MDC.put((String)name.getName(), (String)value.toString());
        }
    }

    public static String getAndPrettyPrint() {
        return LogProperties.getAndPrettyPrint(Collections.<Name>emptySet());
    }

    public static String getAndPrettyPrint(Name nonMatching) {
        return LogProperties.getAndPrettyPrint(EnumSet.of(nonMatching));
    }

    public static String getAndPrettyPrint(Name ... nonMatching) {
        return LogProperties.getAndPrettyPrint(EnumSet.copyOf(Arrays.asList(nonMatching)));
    }

    public static String getAndPrettyPrint(Collection<Name> nonMatching) {
        HashSet<String> nonMatchingNames;
        if (null == nonMatching) {
            nonMatchingNames = null;
        } else {
            nonMatchingNames = new HashSet<String>(nonMatching.size());
            for (Name name : nonMatching) {
                nonMatchingNames.add(name.getName());
            }
        }
        StringBuilder logBuilder = new StringBuilder(1024);
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        String sep = System.getProperty("line.separator");
        for (Map.Entry<String, String> entry : LogProperties.getPropertyMap().entrySet()) {
            String value;
            String propertyName = entry.getKey();
            if (null != nonMatchingNames && nonMatchingNames.contains(propertyName) || null == (value = entry.getValue())) continue;
            sorted.put(propertyName, value);
        }
        for (Map.Entry<String, String> entry : sorted.entrySet()) {
            logBuilder.append(entry.getKey()).append('=').append(entry.getValue()).append(sep);
        }
        return logBuilder.toString();
    }

    @Deprecated
    public static boolean isEnabled() {
        return true;
    }

    @Deprecated
    public static Props getLogProperties() {
        return new Props();
    }

    public static enum Name {
        AJAX_REQUEST_NUMBER("com.openexchange.ajax.requestNumber"),
        AJAX_ACTION("com.openexchange.ajax.action"),
        AJAX_MODULE("com.openexchange.ajax.module"),
        THREAD_ID("__threadId"),
        AJP_REQUEST_URI("com.openexchange.ajpv13.requestURI"),
        AJP_SERVLET_PATH("com.openexchange.ajpv13.servletPath"),
        AJP_PATH_INFO("com.openexchange.ajpv13.pathInfo"),
        AJP_REQUEST_IP("com.openexchange.ajpv13.requestIp"),
        AJP_REQUEST_ID("com.openexchange.ajpv13.requestId"),
        AJP_SERVER_NAME("com.openexchange.ajpv13.serverName"),
        AJP_THREAD_NAME("com.openexchange.ajpv13.threadName"),
        AJP_REMOTE_PORT("com.openexchange.ajpv13.remotePort"),
        AJP_REMOTE_ADDRESS("com.openexchange.ajpv13.remoteAddress"),
        AJP_HTTP_SESSION("com.openexchange.ajp13.httpSession"),
        AJP_USER_AGENT("com.openexchange.ajp13.userAgent"),
        SESSION_AUTH_ID("com.openexchange.session.authId"),
        SESSION_SESSION_ID("com.openexchange.session.sessionId"),
        SESSION_USER_ID("com.openexchange.session.userId"),
        SESSION_USER_NAME("com.openexchange.session.userName"),
        SESSION_CONTEXT_ID("com.openexchange.session.contextId"),
        SESSION_CLIENT_ID("com.openexchange.session.clientId"),
        SESSION_SESSION("com.openexchange.session.session"),
        SESSION_LOGIN_NAME("com.openexchange.session.loginName"),
        GRIZZLY_REQUEST_URI("com.openexchange.grizzly.requestURI"),
        GRIZZLY_SERVLET_PATH("com.openexchange.grizzly.servletPath"),
        GRIZZLY_PATH_INFO("com.openexchange.grizzly.pathInfo"),
        GRIZZLY_REQUEST_IP("com.openexchange.grizzly.requestIp"),
        GRIZZLY_SERVER_NAME("com.openexchange.grizzly.serverName"),
        GRIZZLY_THREAD_NAME("com.openexchange.grizzly.threadName"),
        GRIZZLY_REMOTE_PORT("com.openexchange.grizzly.remotePort"),
        GRIZZLY_REMOTE_ADDRESS("com.openexchange.grizzly.remoteAddress"),
        GRIZZLY_HTTP_SESSION("com.openexchange.grizzly.session"),
        GRIZZLY_USER_AGENT("com.openexchange.grizzly.userAgent"),
        REQUEST_TRACKING_ID("com.openexchange.request.trackingId"),
        SERVLET_SERVLET_PATH("javax.servlet.servletPath"),
        SERVLET_PATH_INFO("javax.servlet.pathInfo"),
        SERVLET_QUERY_STRING("javax.servlet.queryString"),
        FILE_STORAGE_ACCOUNT_ID("com.openexchange.file.storage.accountId"),
        FILE_STORAGE_CONFIGURATION("com.openexchange.file.storage.configuration"),
        FILE_STORAGE_SERVICE_ID("com.openexchange.file.storage.serviceId"),
        MAIL_HOST("com.openexchange.mail.host"),
        MAIL_FULL_NAME("com.openexchange.mail.fullName"),
        MAIL_MAIL_ID("com.openexchange.mail.mailId"),
        MAIL_ACCOUNT_ID("com.openexchange.mail.accountId"),
        MAIL_LOGIN("com.openexchange.mail.login"),
        DATABASE_SCHEMA("com.openexchange.database.schema"),
        LOGIN_LOGIN("com.openexchange.login.login"),
        LOGIN_CLIENT_IP("com.openexchange.login.clientIp"),
        LOGIN_USER_AGENT("com.openexchange.login.userAgent"),
        LOGIN_AUTH_ID("com.openexchange.login.authId"),
        LOGIN_CLIENT("com.openexchange.login.client"),
        LOGIN_VERSION("com.openexchange.login.version"),
        TEMP_FILE("com.openexchange.system.tempfile");

        private final String name;
        private static final Map<String, Name> STRING2NAME;

        private Name(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Name nameFor(String sName) {
            return null == sName ? null : STRING2NAME.get(sName);
        }

        static {
            Name[] values = Name.values();
            HashMap<String, Name> m = new HashMap<String, Name>(values.length);
            for (Name name : values) {
                m.put(name.getName(), name);
            }
            STRING2NAME = m;
        }
    }
}

