/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception;

import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionConstants;
import java.io.IOError;
import java.io.IOException;
import java.net.SocketException;

public final class OXExceptions {
    public static boolean containsCommunicationError(OXException e) {
        if (null == e) {
            return false;
        }
        return OXExceptions.containsCommunicationError0(e.getCause());
    }

    private static boolean containsCommunicationError0(Throwable t) {
        if (null == t) {
            return false;
        }
        if (t instanceof IOError || t instanceof IOException || t instanceof SocketException) {
            return true;
        }
        return OXExceptions.containsCommunicationError0(t.getCause());
    }

    public static OXException general(String logMessage) {
        return new OXException(9999, "An error occurred inside the server which prevented it from fulfilling the request.", new Object[0]).setLogMessage(logMessage).setCategory(OXExceptionConstants.CATEGORY_ERROR).setPrefix("OX");
    }

    public static OXException general(String logMessage, Throwable cause) {
        return new OXException(9999, "An error occurred inside the server which prevented it from fulfilling the request.", cause, new Object[0]).setLogMessage(logMessage).setCategory(OXExceptionConstants.CATEGORY_ERROR).setPrefix("OX");
    }

    public static OXException notFound(String id) {
        return new OXException(1, "Object not found. %1$s", id).setCategory(OXExceptionConstants.CATEGORY_USER_INPUT).setPrefix("OX").setGeneric(OXException.Generic.NOT_FOUND);
    }

    public static OXException noPermissionForModule(String module) {
        return new OXException(1, "No permission for module: %1$s.", module).setCategory(OXExceptionConstants.CATEGORY_USER_INPUT).setPrefix("OX").setGeneric(OXException.Generic.NO_PERMISSION);
    }

    public static OXException noPermissionForFolder() {
        return new OXException(1, "No folder permission.", new Object[0]).setCategory(OXExceptionConstants.CATEGORY_PERMISSION_DENIED).setPrefix("OX").setGeneric(OXException.Generic.NO_PERMISSION);
    }

    public static OXException mandatoryField(String name) {
        return new OXException(9999, "Missing field: %s", name).setCategory(OXExceptionConstants.CATEGORY_ERROR).setPrefix("OX").setGeneric(OXException.Generic.MANDATORY_FIELD);
    }

    public static OXException mandatoryField(int code, String name) {
        return new OXException(code, "Missing field: %s", name).setCategory(OXExceptionConstants.CATEGORY_ERROR).setPrefix("OX").setGeneric(OXException.Generic.MANDATORY_FIELD);
    }

    public static OXException conflict() {
        return new OXException(1, "The object has been changed in the meantime.", new Object[0]).setCategory(OXExceptionConstants.CATEGORY_CONFLICT).setPrefix("OX").setGeneric(OXException.Generic.CONFLICT);
    }
}

