/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.meta;

import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileFieldHandler;
import com.openexchange.file.storage.FileFieldSwitcher;
import com.openexchange.file.storage.meta.FileFieldGet;
import com.openexchange.file.storage.meta.FileFieldSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileFieldHandling {
    public static FileFieldHandler toHandler(FileFieldSwitcher switcher) {
        return new SwitcherHandler(switcher);
    }

    public static FileFieldSwitcher toSwitcher(FileFieldHandler handler) {
        return new HandlerSwitcher(handler);
    }

    public static void copy(File orig, File dest, File.Field ... fields) {
        FileFieldGet get = new FileFieldGet();
        FileFieldSet set = new FileFieldSet();
        for (File.Field field : fields) {
            field.doSwitch(set, dest, field.doSwitch(get, orig));
        }
    }

    public static void copy(File orig, File dest) {
        FileFieldHandling.copy(orig, dest, File.Field.values());
    }

    public static File dup(File orig) {
        DefaultFile copy = new DefaultFile();
        FileFieldHandling.copy(orig, copy);
        return copy;
    }

    public static Map<String, Object> toMap(File file, File.Field ... fields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FileFieldGet get = new FileFieldGet();
        for (File.Field field : fields) {
            Object value = field.doSwitch(get, file);
            map.put(field.getName(), value);
        }
        return map;
    }

    public static Map<String, Object> toMap(File file) {
        return FileFieldHandling.toMap(file, File.Field.values());
    }

    public static String toString(File file) {
        return FileFieldHandling.toMap(file).toString();
    }

    public static void fromMap(Map<String, Object> map, File file, List<File.Field> foundFields) {
        FileFieldSet set = new FileFieldSet();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            File.Field field = File.Field.get(entry.getKey());
            foundFields.add(field);
            field.doSwitch(set, file, entry.getValue());
        }
    }

    public static void fromMap(Map<String, Object> map, File file) {
        FileFieldHandling.fromMap(map, file, new ArrayList<File.Field>(map.size()));
    }

    public static List<Object> toList(File file, File.Field ... fields) {
        FileFieldGet get = new FileFieldGet();
        ArrayList<Object> list = new ArrayList<Object>(fields.length);
        for (File.Field field : fields) {
            list.add(field.doSwitch(get, file));
        }
        return list;
    }

    private static class HandlerSwitcher
    implements FileFieldSwitcher {
        private final FileFieldHandler handler;

        public HandlerSwitcher(FileFieldHandler handler) {
            this.handler = handler;
        }

        @Override
        public Object categories(Object ... args) {
            return this.handler.handle(File.Field.CATEGORIES, args);
        }

        @Override
        public Object colorLabel(Object ... args) {
            return this.handler.handle(File.Field.COLOR_LABEL, args);
        }

        @Override
        public Object content(Object ... args) {
            return this.handler.handle(File.Field.CONTENT, args);
        }

        @Override
        public Object created(Object ... args) {
            return this.handler.handle(File.Field.CREATED, args);
        }

        @Override
        public Object createdBy(Object ... args) {
            return this.handler.handle(File.Field.CREATED_BY, args);
        }

        @Override
        public Object currentVersion(Object ... args) {
            return this.handler.handle(File.Field.CURRENT_VERSION, args);
        }

        @Override
        public Object description(Object ... args) {
            return this.handler.handle(File.Field.DESCRIPTION, args);
        }

        @Override
        public Object fileMd5sum(Object ... args) {
            return this.handler.handle(File.Field.FILE_MD5SUM, args);
        }

        @Override
        public Object fileMimetype(Object ... args) {
            return this.handler.handle(File.Field.FILE_MIMETYPE, args);
        }

        @Override
        public Object fileSize(Object ... args) {
            return this.handler.handle(File.Field.FILE_SIZE, args);
        }

        @Override
        public Object filename(Object ... args) {
            return this.handler.handle(File.Field.FILENAME, args);
        }

        @Override
        public Object folderId(Object ... args) {
            return this.handler.handle(File.Field.FOLDER_ID, args);
        }

        @Override
        public Object id(Object ... args) {
            return this.handler.handle(File.Field.ID, args);
        }

        @Override
        public Object lastModified(Object ... args) {
            return this.handler.handle(File.Field.LAST_MODIFIED, args);
        }

        @Override
        public Object lastModifiedUtc(Object ... args) {
            return this.handler.handle(File.Field.LAST_MODIFIED_UTC, args);
        }

        @Override
        public Object lockedUntil(Object ... args) {
            return this.handler.handle(File.Field.LOCKED_UNTIL, args);
        }

        @Override
        public Object modifiedBy(Object ... args) {
            return this.handler.handle(File.Field.MODIFIED_BY, args);
        }

        @Override
        public Object numberOfVersions(Object ... args) {
            return this.handler.handle(File.Field.NUMBER_OF_VERSIONS, args);
        }

        @Override
        public Object sequenceNumber(Object ... args) {
            return this.handler.handle(File.Field.SEQUENCE_NUMBER, args);
        }

        @Override
        public Object title(Object ... args) {
            return this.handler.handle(File.Field.TITLE, args);
        }

        @Override
        public Object url(Object ... args) {
            return this.handler.handle(File.Field.URL, args);
        }

        @Override
        public Object version(Object ... args) {
            return this.handler.handle(File.Field.VERSION, args);
        }

        @Override
        public Object versionComment(Object ... args) {
            return this.handler.handle(File.Field.VERSION_COMMENT, args);
        }

        @Override
        public Object meta(Object ... args) {
            return this.handler.handle(File.Field.META, args);
        }
    }

    private static class SwitcherHandler
    implements FileFieldHandler {
        private final FileFieldSwitcher switcher;

        public SwitcherHandler(FileFieldSwitcher switcher) {
            this.switcher = switcher;
        }

        @Override
        public Object handle(File.Field field, Object ... args) {
            return field.doSwitch(this.switcher, args);
        }
    }
}

