/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderAccess;
import com.openexchange.file.storage.Quota;
import com.openexchange.file.storage.infostore.Services;
import com.openexchange.file.storage.infostore.folder.FolderParser;
import com.openexchange.file.storage.infostore.folder.FolderWriter;
import com.openexchange.file.storage.infostore.folder.ParsedFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderResponse;
import com.openexchange.folderstorage.FolderService;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.type.TrashType;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;

public class InfostoreFolderAccess
implements FileStorageFolderAccess {
    private static final String INFOSTORE_FOLDER_ID = "9";
    private static final String REAL_TREE_ID = FolderStorage.REAL_TREE_ID;
    private final ServerSession session;
    private final InfostoreFacade infostore;

    public InfostoreFolderAccess(ServerSession session, InfostoreFacade infostore) {
        this.session = session;
        this.infostore = infostore;
    }

    public void clearFolder(String folderId) throws OXException {
        FolderService service = Services.getService(FolderService.class);
        service.clearFolder(REAL_TREE_ID, folderId, (Session)this.session);
    }

    public void clearFolder(String folderId, boolean hardDelete) throws OXException {
        FolderService service = Services.getService(FolderService.class);
        service.clearFolder(REAL_TREE_ID, folderId, (Session)this.session);
    }

    public String createFolder(FileStorageFolder toCreate) throws OXException {
        FolderService service = Services.getService(FolderService.class);
        FolderResponse response = service.createFolder(FolderParser.parseFolder(toCreate), (Session)this.session, null);
        return (String)response.getResponse();
    }

    public String deleteFolder(String folderId) throws OXException {
        return this.deleteFolder(folderId, false);
    }

    public String deleteFolder(String folderId, boolean hardDelete) throws OXException {
        Services.getService(FolderService.class).deleteFolder(REAL_TREE_ID, folderId, null, (Session)this.session, new FolderServiceDecorator().put("hardDelete", (Object)String.valueOf(hardDelete)));
        return folderId;
    }

    public boolean exists(String folderId) throws OXException {
        try {
            FolderService service = Services.getService(FolderService.class);
            service.getFolder(REAL_TREE_ID, folderId, (Session)this.session, null);
            return true;
        }
        catch (OXException e) {
            return false;
        }
    }

    public FileStorageFolder getFolder(String folderId) throws OXException {
        FolderService service = Services.getService(FolderService.class);
        return FolderWriter.writeFolder(service.getFolder(REAL_TREE_ID, folderId, (Session)this.session, null));
    }

    public FileStorageFolder getPersonalFolder() throws OXException {
        FolderService service = Services.getService(FolderService.class);
        return FolderWriter.writeFolder(service.getDefaultFolder(this.session.getUser(), REAL_TREE_ID, (ContentType)InfostoreContentType.getInstance(), (Session)this.session, null));
    }

    public FileStorageFolder getTrashFolder() throws OXException {
        FolderService service = Services.getService(FolderService.class);
        try {
            return FolderWriter.writeFolder(service.getDefaultFolder(this.session.getUser(), REAL_TREE_ID, (ContentType)InfostoreContentType.getInstance(), (Type)TrashType.getInstance(), (Session)this.session, null));
        }
        catch (OXException e) {
            if (FolderExceptionErrorMessage.NO_DEFAULT_FOLDER.equals(e)) {
                throw FileStorageExceptionCodes.NO_SUCH_FOLDER.create((Throwable)e, new Object[0]);
            }
            throw e;
        }
    }

    public FileStorageFolder[] getPublicFolders() throws OXException {
        FolderService service = Services.getService(FolderService.class);
        UserizedFolder[] subfolders = (UserizedFolder[])service.getSubfolders(REAL_TREE_ID, "15", true, (Session)this.session, null).getResponse();
        FileStorageFolder[] ret = new FileStorageFolder[subfolders.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = FolderWriter.writeFolder(subfolders[i]);
        }
        return ret;
    }

    public FileStorageFolder[] getPath2DefaultFolder(String folderId) throws OXException {
        FolderService service = Services.getService(FolderService.class);
        UserizedFolder[] folders = (UserizedFolder[])service.getPath(REAL_TREE_ID, folderId, (Session)this.session, null).getResponse();
        FileStorageFolder[] ret = new FileStorageFolder[folders.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = FolderWriter.writeFolder(folders[i]);
        }
        return ret;
    }

    public Quota getFileQuota(String folderId) throws OXException {
        return this.infostore.getFileQuota(this.session);
    }

    public Quota getStorageQuota(String folderId) throws OXException {
        return this.infostore.getStorageQuota(this.session);
    }

    public Quota[] getQuotas(String folder, Quota.Type[] types) throws OXException {
        if (null == types) {
            return null;
        }
        Quota[] quotas = new Quota[types.length];
        block4: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case FILE: {
                    quotas[i] = this.getFileQuota(folder);
                    continue block4;
                }
                case STORAGE: {
                    quotas[i] = this.getStorageQuota(folder);
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException("unknown type: " + types[i]);
                }
            }
        }
        return quotas;
    }

    public FileStorageFolder getRootFolder() throws OXException {
        try {
            return this.getFolder(INFOSTORE_FOLDER_ID);
        }
        catch (OXException e) {
            if (FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.equals(e)) {
                return null;
            }
            throw e;
        }
    }

    public FileStorageFolder[] getSubfolders(String parentIdentifier, boolean all) throws OXException {
        FolderService service = Services.getService(FolderService.class);
        UserizedFolder[] subfolders = (UserizedFolder[])service.getSubfolders(REAL_TREE_ID, parentIdentifier, all, (Session)this.session, null).getResponse();
        FileStorageFolder[] ret = new FileStorageFolder[subfolders.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = FolderWriter.writeFolder(subfolders[i]);
        }
        return ret;
    }

    public String moveFolder(String folderId, String newParentId) throws OXException {
        return this.moveFolder(folderId, newParentId, null);
    }

    public String moveFolder(String folderId, String newParentId, String newName) throws OXException {
        return this.moveFolder(folderId, newParentId, newName, null);
    }

    public String renameFolder(String folderId, String newName) throws OXException {
        return this.moveFolder(folderId, null, newName, null);
    }

    public String updateFolder(String identifier, FileStorageFolder toUpdate) throws OXException {
        FolderService service = Services.getService(FolderService.class);
        Folder parsedFolder = FolderParser.parseFolder(toUpdate);
        service.updateFolder(parsedFolder, null, (Session)this.session, null);
        return parsedFolder.getNewID();
    }

    private String moveFolder(String folderId, String newParentId, String newName, FolderServiceDecorator decorator) throws OXException {
        FolderService service = Services.getService(FolderService.class);
        ParsedFolder folder = new ParsedFolder();
        folder.setTreeID(REAL_TREE_ID);
        folder.setID(folderId);
        if (null != newParentId) {
            folder.setParentID(newParentId);
        }
        if (null != newName) {
            folder.setName(newName);
        }
        service.updateFolder((Folder)folder, null, (Session)this.session, decorator);
        return null == folder.getNewID() ? folderId : folder.getNewID();
    }
}

