/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.infostore.InfostoreAccountAccess;
import com.openexchange.file.storage.infostore.InfostoreDefaultAccountManager;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreSearchEngine;
import com.openexchange.session.Session;
import java.util.Collections;
import java.util.Set;

public class InfostoreFileStorageService
implements FileStorageService {
    private InfostoreFacade infostore;
    private InfostoreSearchEngine search;

    public FileStorageAccountAccess getAccountAccess(String accountId, Session session) throws OXException {
        if (!accountId.equals("infostore")) {
            throw FileStorageExceptionCodes.ACCOUNT_NOT_FOUND.create(new Object[]{accountId, this.getId(), session.getUserId(), session.getContextId()});
        }
        return new InfostoreAccountAccess(session, this);
    }

    public FileStorageAccountManager getAccountManager() {
        return new InfostoreDefaultAccountManager(this);
    }

    public String getDisplayName() {
        return "Standard Infostore";
    }

    public String getId() {
        return "com.openexchange.infostore";
    }

    public Set<String> getSecretProperties() {
        return Collections.emptySet();
    }

    public DynamicFormDescription getFormDescription() {
        return new DynamicFormDescription();
    }

    public InfostoreFacade getInfostore() {
        return this.infostore;
    }

    public void setInfostore(InfostoreFacade infostore) {
        this.infostore = infostore;
    }

    public InfostoreSearchEngine getSearch() {
        return this.search;
    }

    public void setSearch(InfostoreSearchEngine search) {
        this.search = search;
    }
}

