/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.AppointmentTest;
import com.openexchange.webdav.xml.FolderTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bug4395Test
extends AppointmentTest {
    private static final Logger LOG = LoggerFactory.getLogger(Bug4395Test.class);

    public Bug4395Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBug4395() throws Exception {
        FolderObject sharedFolderObject = FolderTest.getAppointmentDefaultFolder(this.getSecondWebConversation(), "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
        int secondUserId = sharedFolderObject.getCreatedBy();
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testBug4395" + System.currentTimeMillis());
        folderObj.setModule(2);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(secondUserId, false, 128, 128, 128, 128, true)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getSecondWebConversation(), folderObj, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
        permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 128, 128, 128, 128, false), FolderTest.createPermission(secondUserId, false, 4, 128, 128, 128, true)};
        folderObj.setPermissionsAsArray(permission);
        folderObj.setObjectID(parentFolderId);
        FolderTest.updateFolder(this.getSecondWebConversation(), folderObj, this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testBug4395");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(parentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int appointmentObjectId = Bug4395Test.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(appointmentObjectId);
        Appointment loadAppointment = Bug4395Test.loadAppointment(this.getWebConversation(), appointmentObjectId, parentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug4395Test.compareObject(appointmentObj, loadAppointment);
        FolderTest.deleteFolder(this.getSecondWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
    }
}

