/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import com.openexchange.test.fixtures.SimpleCredentials;
import com.openexchange.test.fixtures.transformators.BooleanTransformator;
import com.openexchange.test.fixtures.transformators.EMailFlagsTransformator;
import com.openexchange.test.fixtures.transformators.InternetAddressTransformator;
import com.openexchange.test.fixtures.transformators.JChronicDateTransformator;
import com.openexchange.test.fixtures.transformators.Transformator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

public class EMailFixtureFactory
implements FixtureFactory<MailMessage> {
    private final File datapath;
    private final FixtureLoader fixtureLoader;

    public EMailFixtureFactory(File datapath, FixtureLoader fixtureLoader) {
        this.datapath = datapath;
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Fixtures<MailMessage> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        return new EMailFixture(fixtureName, entries, this.datapath, this.fixtureLoader);
    }

    private class EMailFixture
    extends DefaultFixtures<MailMessage>
    implements Fixtures<MailMessage> {
        private final File dataPath;
        final Map<String, Fixture<MailMessage>> mails;
        private final Map<String, Map<String, String>> entries;

        public EMailFixture(String fixtureName, Map<String, Map<String, String>> entries, File datapath, FixtureLoader fixtureLoader) {
            super(MailMessage.class, entries, fixtureLoader);
            this.mails = new HashMap<String, Fixture<MailMessage>>();
            this.entries = entries;
            this.dataPath = datapath;
            this.addTransformator((Transformator)new InternetAddressTransformator(fixtureLoader), "from");
            this.addTransformator((Transformator)new InternetAddressTransformator(fixtureLoader), "to");
            this.addTransformator((Transformator)new InternetAddressTransformator(fixtureLoader), "cc");
            this.addTransformator((Transformator)new InternetAddressTransformator(fixtureLoader), "bcc");
            this.addTransformator((Transformator)new JChronicDateTransformator(fixtureLoader), "received_date");
            this.addTransformator((Transformator)new JChronicDateTransformator(fixtureLoader), "sent_date");
            this.addTransformator((Transformator)new EMailFlagsTransformator(), "flags");
            this.addTransformator((Transformator)new BooleanTransformator(), "append_v_card");
            this.addTransformator((Transformator)new BooleanTransformator(), "prev_seen");
        }

        @Override
        public Fixture<MailMessage> getEntry(String entryName) throws OXException {
            MailMessage mail;
            if (this.mails.containsKey(entryName)) {
                return this.mails.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (values == null) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            if (!values.containsKey("eml")) {
                throw new FixtureException("Mandatory value \"eml\" missing in entry " + entryName);
            }
            File mailpath = new File(new File(this.dataPath, "emails"), values.get("eml"));
            if (values.containsKey("append_v_card") && "true".equals(String.valueOf(values.get("append_v_card")))) {
                String emlAsString;
                try {
                    emlAsString = this.readFileAsString(mailpath);
                }
                catch (IOException e) {
                    throw new FixtureException(e);
                }
                String from = values.get("from").substring(values.get("from").indexOf(":") + 1);
                Contact contact = EMailFixtureFactory.this.fixtureLoader.getFixtures("users", SimpleCredentials.class).getEntry(from).getEntry().asContact();
                String displayName = contact.containsDisplayName() ? contact.getDisplayName() : contact.getGivenName() + contact.getSurName();
                mail = this.getMessage(emlAsString.replace("TobiasFriedrich.vcf", displayName.replace(" ", "") + ".vcf").replace("FN:Tobias Friedrich", "FN:" + displayName).replace("N:Friedrich;Tobias", "N:" + contact.getSurName() + ";" + contact.getGivenName()).replace("EMAIL:tfriedrich@oxhemail.open-xchange.com", "EMAIL:" + contact.getEmail1()));
            } else {
                mail = this.getMessage(mailpath);
            }
            if (values.containsKey("to")) {
                mail.removeTo();
            }
            if (values.containsKey("cc")) {
                mail.removeCc();
            }
            if (values.containsKey("bcc")) {
                mail.removeBcc();
            }
            if (values.containsKey("from")) {
                mail.removeFrom();
                mail.removeHeader("Return-Path");
                mail.removeHeader("Reply-To");
            }
            if (values.containsKey("sent_date")) {
                mail.removeSentDate();
            }
            if (values.containsKey("received_date")) {
                mail.removeReceivedDate();
                mail.removeHeader("Received");
            }
            this.apply(mail, values);
            Fixture<MailMessage> fixture = new Fixture<MailMessage>(mail, values.keySet().toArray(new String[values.size()]), values);
            this.mails.put(entryName, fixture);
            return fixture;
        }

        private String readFileAsString(File file) throws IOException {
            StringBuffer fileData = new StringBuffer();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                fileData.append(buf, 0, numRead);
            }
            reader.close();
            return fileData.toString();
        }

        private MailMessage getMessage(File fdir) throws OXException {
            MailMessage retval;
            MimeMessage msg;
            Session session = Session.getInstance((Properties)this.getDefaultSessionProperties());
            FileInputStream in = null;
            try {
                in = new FileInputStream(fdir);
                msg = new MimeMessage(session, (InputStream)in);
            }
            catch (FileNotFoundException e) {
                throw new FixtureException("File not found: " + fdir.getAbsolutePath(), e);
            }
            catch (MessagingException e) {
                throw new FixtureException(e);
            }
            finally {
                if (null != in) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                retval = MimeMessageConverter.convertMessage((MimeMessage)msg);
            }
            catch (OXException e) {
                throw new FixtureException(e);
            }
            return retval;
        }

        private MailMessage getMessage(String string) throws OXException {
            MailMessage retval;
            MimeMessage msg;
            Session session = Session.getInstance((Properties)this.getDefaultSessionProperties());
            ByteArrayInputStream in = null;
            try {
                in = new ByteArrayInputStream(string.getBytes());
                msg = new MimeMessage(session, (InputStream)in);
            }
            catch (MessagingException e) {
                throw new FixtureException(e);
            }
            finally {
                if (null != in) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                retval = MimeMessageConverter.convertMessage((MimeMessage)msg);
            }
            catch (OXException e) {
                throw new FixtureException(e);
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final Properties getDefaultSessionProperties() {
            Properties sessionProperties = null;
            String STR_TRUE = "true";
            String STR_FALSE = "false";
            Class<EMailFixture> clazz = EMailFixture.class;
            synchronized (EMailFixture.class) {
                if (sessionProperties == null) {
                    System.getProperties().put("mail.mime.base64.ignoreerrors", "true");
                    System.getProperties().put("mail.imap.allowreadonlyselect", "true");
                    System.getProperties().put("mail.mime.encodeeol.strict", "true");
                    System.getProperties().put("mail.mime.decodetext.strict", "false");
                    System.getProperties().put("mail.mime.charset", "UTF-8");
                    sessionProperties = (Properties)System.getProperties().clone();
                    sessionProperties.put("mail.imap.connectionpoolsize", "1");
                    sessionProperties.put("mail.imap.connectionpooltimeout", "1000");
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return sessionProperties;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return sessionProperties;
            }
        }
    }
}

