/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.AppointmentUpdatesResponse;
import com.openexchange.ajax.appointment.action.ConfirmRequest;
import com.openexchange.ajax.appointment.action.ConfirmResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetChangeExceptionsRequest;
import com.openexchange.ajax.appointment.action.GetChangeExceptionsResponse;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.HasRequest;
import com.openexchange.ajax.appointment.action.HasResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.appointment.action.NewAppointmentSearchRequest;
import com.openexchange.ajax.appointment.action.NewAppointmentSearchResponse;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.appointment.action.UpdatesRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.parser.ParticipantParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;
import com.openexchange.java.Autoboxing;
import com.openexchange.test.TestManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import junit.framework.Assert;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class CalendarTestManager
implements TestManager {
    private AJAXClient client;
    private final List<Appointment> createdEntities = new ArrayList<Appointment>();
    private TimeZone timezone;
    private AbstractAJAXResponse lastResponse;
    private boolean failOnError;
    private Exception lastException;
    private Date lastModification;

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalendarTestManager(AJAXClient client) {
        this.setClient(client);
        try {
            this.timezone = client.getValues().getTimeZone();
        }
        catch (OXException e) {
        }
        catch (IOException e) {
        }
        catch (JSONException jSONException) {
        }
        finally {
            if (this.timezone == null) {
                this.timezone = TimeZone.getTimeZone("Europe/Berlin");
            }
        }
    }

    public void setClient(AJAXClient client) {
        this.client = client;
    }

    public AJAXClient getClient() {
        return this.client;
    }

    public void setLastResponse(AbstractAJAXResponse lastResponse) {
        this.lastResponse = lastResponse;
    }

    @Override
    public AbstractAJAXResponse getLastResponse() {
        return this.lastResponse;
    }

    @Override
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    public boolean getFailOnError() {
        return this.failOnError;
    }

    @Override
    public boolean doesFailOnError() {
        return this.getFailOnError();
    }

    public void setLastException(Exception lastException) {
        lastException.printStackTrace();
        this.lastException = lastException;
    }

    @Override
    public Exception getLastException() {
        return this.lastException;
    }

    @Override
    public boolean hasLastException() {
        return this.lastException != null;
    }

    public void setLastModification(Date lastModification) {
        this.lastModification = lastModification;
    }

    public Date getLastModification() {
        return this.lastModification;
    }

    public int getPrivateFolder() throws OXException, IOException, SAXException, JSONException {
        return this.getClient().getValues().getPrivateAppointmentFolder();
    }

    @Override
    public void cleanUp() {
        boolean old = this.getFailOnError();
        this.setFailOnError(false);
        for (Appointment appointment : new ArrayList<Appointment>(this.createdEntities)) {
            this.delete(appointment);
        }
        this.setFailOnError(old);
    }

    private <T extends AbstractAJAXResponse> T execute(AJAXRequest<T> request) {
        block6: {
            try {
                return this.getClient().execute(request);
            }
            catch (OXException e) {
                this.setLastException((Exception)((Object)e));
                if (this.failOnError) {
                    Assert.fail((String)("AjaxException during task creation: " + e.getLocalizedMessage()));
                }
            }
            catch (IOException e) {
                this.setLastException(e);
                if (this.failOnError) {
                    Assert.fail((String)("IOException during task creation: " + e.getLocalizedMessage()));
                }
            }
            catch (JSONException e) {
                this.setLastException((Exception)((Object)e));
                if (!this.failOnError) break block6;
                Assert.fail((String)("JsonException during task creation: " + e.getLocalizedMessage()));
            }
        }
        return null;
    }

    public Appointment insert(Appointment appointment) {
        InsertRequest insertRequest = new InsertRequest(appointment, this.timezone, this.getFailOnError());
        AppointmentInsertResponse insertResponse = this.execute(insertRequest);
        this.extractInfo(insertResponse);
        insertResponse.fillAppointment(appointment);
        if (this.doesFailOnError() || appointment.getObjectID() != 0) {
            this.createdEntities.add(appointment);
        }
        return appointment;
    }

    public Appointment get(int parentFolderID, int objectID) throws OXException {
        GetRequest get = new GetRequest(parentFolderID, objectID, this.getFailOnError());
        GetResponse response = this.execute(get);
        this.extractInfo(response);
        return response.getAppointment(this.timezone);
    }

    public Appointment get(Appointment appointment) throws OXException {
        try {
            GetRequest get = new GetRequest(appointment, this.getFailOnError());
            GetResponse response = this.execute(get);
            this.extractInfo(response);
            return response.getAppointment(this.timezone);
        }
        catch (OXException e) {
            if (this.failOnError) {
                throw e;
            }
            return null;
        }
    }

    public Appointment get(int parentFolderID, int objectID, boolean pleaseFailOnError) throws OXException {
        try {
            GetRequest get = new GetRequest(parentFolderID, objectID, pleaseFailOnError);
            GetResponse response = this.execute(get);
            this.extractInfo(response);
            return response.getAppointment(this.timezone);
        }
        catch (OXException e) {
            if (this.failOnError) {
                throw e;
            }
            return null;
        }
    }

    public Appointment get(int parentFolderID, int objectID, int recurrencePos) throws OXException {
        try {
            GetRequest get = new GetRequest(parentFolderID, objectID, recurrencePos, this.getFailOnError());
            GetResponse response = this.execute(get);
            this.extractInfo(response);
            return response.getAppointment(this.timezone);
        }
        catch (OXException e) {
            if (this.failOnError) {
                throw e;
            }
            return null;
        }
    }

    public void confirm(Appointment app, int status, String message, int occurrence) {
        ConfirmRequest confirmRequest = new ConfirmRequest(app.getParentFolderID(), app.getObjectID(), occurrence, status, message, 0, app.getLastModified(), this.getFailOnError());
        ConfirmResponse resp = this.execute(confirmRequest);
        this.setLastResponse(resp);
        this.setLastModification(resp.getTimestamp());
    }

    public void confirm(Appointment app, int status, String message) {
        ConfirmRequest confirmRequest = new ConfirmRequest(app.getParentFolderID(), app.getObjectID(), status, message, app.getLastModified(), this.getFailOnError());
        ConfirmResponse resp = this.execute(confirmRequest);
        this.setLastResponse(resp);
        this.setLastModification(resp.getTimestamp());
    }

    public void confirm(Appointment app, int user, int status, String message) {
        ConfirmRequest confirmRequest = new ConfirmRequest(app.getParentFolderID(), app.getObjectID(), status, message, user, app.getLastModified(), this.getFailOnError());
        ConfirmResponse resp = this.execute(confirmRequest);
        this.setLastResponse(resp);
        this.setLastModification(resp.getTimestamp());
    }

    public void confirmExternal(Appointment app, String mail, int status, String message, int occurrence) {
        ConfirmRequest confirmRequest = new ConfirmRequest(app.getParentFolderID(), app.getObjectID(), occurrence, status, message, mail, app.getLastModified(), this.getFailOnError());
        ConfirmResponse resp = this.execute(confirmRequest);
        this.setLastResponse(resp);
        this.setLastModification(resp.getTimestamp());
    }

    public void confirmExternal(Appointment app, String mail, int status, String message) {
        ConfirmRequest confirmRequest = new ConfirmRequest(app.getParentFolderID(), app.getObjectID(), status, message, mail, app.getLastModified(), this.getFailOnError());
        ConfirmResponse resp = this.execute(confirmRequest);
        this.setLastResponse(resp);
        this.setLastModification(resp.getTimestamp());
    }

    public List<Appointment> updates(int folderId, Date timestamp, boolean recurrenceMaster) {
        return this.updates(folderId, Appointment.ALL_COLUMNS, timestamp, recurrenceMaster);
    }

    public List<Appointment> updates(int folderId, int[] columns, Date timestamp, boolean recurrenceMaster) {
        UpdatesRequest req = new UpdatesRequest(folderId, columns, timestamp, recurrenceMaster);
        AppointmentUpdatesResponse resp = this.execute(req);
        this.extractInfo(resp);
        try {
            return resp.getAppointments(this.timezone);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Appointment> getChangeExceptions(int folderId, int objectId, int[] columns) {
        GetChangeExceptionsRequest request = new GetChangeExceptionsRequest(folderId, objectId, columns);
        GetChangeExceptionsResponse response = this.execute(request);
        this.extractInfo(response);
        try {
            return response.getAppointments(this.timezone);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void update(Appointment updatedAppointment) {
        UpdateRequest updateRequest = new UpdateRequest(updatedAppointment, this.timezone, this.getFailOnError());
        UpdateResponse updateResponse = this.execute(updateRequest);
        this.extractInfo(updateResponse);
        updatedAppointment.setLastModified(updateResponse.getTimestamp());
        if (updateResponse.getId() != 0) {
            updatedAppointment.setObjectID(updateResponse.getId());
        }
        for (Appointment createdAppoinment : this.createdEntities) {
            if (createdAppoinment.getObjectID() != updatedAppointment.getObjectID()) continue;
            createdAppoinment.setLastModified(updatedAppointment.getLastModified());
        }
    }

    public List<Appointment> list(ListIDs foldersAndIds, int[] columns) {
        ListRequest req = new ListRequest(foldersAndIds, this.addNecessaryColumns(columns), this.getFailOnError());
        CommonListResponse resp = this.execute(req);
        this.extractInfo(resp);
        return this.extractAppointments(resp);
    }

    public List<Appointment> extractAppointments(CommonListResponse resp) {
        Object[][] arr;
        LinkedList<Appointment> list = new LinkedList<Appointment>();
        int[] cols = resp.getColumns();
        for (Object[] values : arr = resp.getArray()) {
            Appointment temp = new Appointment();
            list.add(temp);
            for (int i = 0; i < cols.length; ++i) {
                if (values[i] != null) {
                    temp.set(cols[i], this.conv(cols[i], values[i]));
                    continue;
                }
                temp.remove(cols[i]);
            }
            this.fixDates(temp);
        }
        return list;
    }

    public List<Appointment> newappointments(Date start, Date end, int limit, int[] columns) {
        NewAppointmentSearchRequest req = new NewAppointmentSearchRequest(start, end, limit, this.timezone, columns);
        NewAppointmentSearchResponse resp = this.execute(req);
        this.extractInfo(resp);
        try {
            return Arrays.asList(resp.getAppointments());
        }
        catch (Exception e) {
            this.lastException = e;
            return null;
        }
    }

    private void fixDates(Appointment temp) {
        if (temp.getFullTime()) {
            return;
        }
        if (temp.containsStartDate()) {
            temp.setStartDate(this.moveOffset(temp.getStartDate()));
        }
        if (temp.containsEndDate()) {
            temp.setEndDate(this.moveOffset(temp.getEndDate()));
        }
    }

    private Date moveOffset(Date value) {
        int offset = this.timezone.getOffset(value.getTime());
        return new Date(value.getTime() - (long)offset);
    }

    private Object conv(int i, Object object) {
        Object value = object;
        switch (i) {
            case 201: 
            case 202: 
            case 216: {
                if (object instanceof Date) break;
                value = new Date((Long)object);
            }
        }
        return value;
    }

    private int[] addNecessaryColumns(int[] columns) {
        LinkedList<Integer> cols = new LinkedList<Integer>(Arrays.asList(Autoboxing.i2I((int[])columns)));
        if (!cols.contains(Autoboxing.I((int)20))) {
            cols.add(Autoboxing.I((int)20));
        }
        if (!cols.contains(Autoboxing.I((int)1))) {
            cols.add(Autoboxing.I((int)1));
        }
        return Autoboxing.I2i(cols);
    }

    public Appointment[] all(int parentFolderID, Date start, Date end, int[] columns, boolean recurrenceMaster) {
        AllRequest request = new AllRequest(parentFolderID, columns, start, end, this.timezone, recurrenceMaster);
        CommonAllResponse response = this.execute(request);
        this.extractInfo(response);
        ArrayList<Appointment> appointments = new ArrayList<Appointment>();
        int[] actualColumns = response.getColumns();
        for (Object[] row : response.getArray()) {
            Appointment app = new Appointment();
            appointments.add(app);
            for (int i = 0; i < row.length; ++i) {
                if (row[i] == null || actualColumns[i] == 6) continue;
                if (actualColumns[i] == 226) {
                    this.parseConfirmations((JSONArray)row[i], app);
                    continue;
                }
                if (actualColumns[i] == 221) {
                    this.parseUsers((JSONArray)row[i], app);
                    continue;
                }
                try {
                    app.set(actualColumns[i], row[i]);
                    continue;
                }
                catch (ClassCastException x) {
                    if (!x.getMessage().equals("java.lang.Long") || this.tryDate(app, actualColumns[i], (Long)row[i])) continue;
                    this.tryInteger(app, actualColumns[i], (Long)row[i]);
                }
            }
        }
        return appointments.toArray(new Appointment[appointments.size()]);
    }

    private void parseUsers(JSONArray jUsers, Appointment app) {
        ArrayList<UserParticipant> users = new ArrayList<UserParticipant>();
        try {
            for (int i = 0; i < jUsers.length(); ++i) {
                JSONObject jUser = jUsers.getJSONObject(i);
                UserParticipant user = new UserParticipant(jUser.getInt("id"));
                if (jUser.has("confirmation")) {
                    user.setConfirm(jUser.getInt("confirmation"));
                }
                if (jUser.has("confirmmessage")) {
                    user.setConfirmMessage(jUser.getString("confirmmessage"));
                }
                if (jUser.has("alarm")) {
                    user.setAlarmDate(new Date(jUser.getLong("alarm")));
                }
                users.add(user);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        app.setUsers(users);
    }

    private void parseConfirmations(JSONArray confirmations, Appointment app) {
        ParticipantParser parser = new ParticipantParser();
        ArrayList<ConfirmableParticipant> confirmableParticipants = new ArrayList<ConfirmableParticipant>();
        for (int j = 0; j < confirmations.length(); ++j) {
            try {
                JSONObject confirmation = confirmations.getJSONObject(j);
                confirmableParticipants.add(parser.parseConfirmation(true, confirmation));
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        app.setConfirmations(confirmableParticipants);
    }

    public Appointment[] all(int parentFolderID, Date start, Date end, int[] columns) {
        return this.all(parentFolderID, start, end, columns, true);
    }

    public Appointment[] all(int parentFolderID, Date start, Date end) {
        AllRequest request = new AllRequest(parentFolderID, Appointment.ALL_COLUMNS, start, end, this.timezone);
        CommonAllResponse response = this.execute(request);
        this.extractInfo(response);
        ArrayList<Appointment> appointments = new ArrayList<Appointment>();
        for (Object[] row : response.getArray()) {
            Appointment app = new Appointment();
            appointments.add(app);
            for (int i = 0; i < row.length; ++i) {
                if (row[i] == null || Appointment.ALL_COLUMNS[i] == 6) continue;
                try {
                    app.set(Appointment.ALL_COLUMNS[i], row[i]);
                    continue;
                }
                catch (ClassCastException x) {
                    if (!x.getMessage().equals("java.lang.Long") || this.tryDate(app, Appointment.ALL_COLUMNS[i], (Long)row[i])) continue;
                    this.tryInteger(app, Appointment.ALL_COLUMNS[i], (Long)row[i]);
                }
            }
        }
        return appointments.toArray(new Appointment[appointments.size()]);
    }

    public void delete(Appointment appointment, boolean failOnErrorOverride) {
        this.createdEntities.remove(appointment);
        DeleteRequest deleteRequest = appointment.containsRecurrencePosition() ? new DeleteRequest(appointment.getObjectID(), appointment.getParentFolderID(), appointment.getRecurrencePosition(), new Date(Long.MAX_VALUE), failOnErrorOverride) : new DeleteRequest(appointment.getObjectID(), appointment.getParentFolderID(), new Date(Long.MAX_VALUE), failOnErrorOverride);
        CommonDeleteResponse response = this.execute(deleteRequest);
        if (response != null) {
            this.extractInfo(response);
        }
    }

    public void delete(Appointment appointment) {
        this.delete(appointment, this.getFailOnError());
    }

    public void createDeleteException(int folder, int seriesId, int recurrencePos) {
        DeleteRequest deleteRequest = new DeleteRequest(seriesId, folder, recurrencePos, new Date(Long.MAX_VALUE), this.getFailOnError());
        this.extractInfo(this.execute(deleteRequest));
    }

    public void createDeleteException(Appointment master, int recurrencePos) {
        this.createDeleteException(master.getParentFolderID(), master.getObjectID(), recurrencePos);
        master.setLastModified(this.getLastModification());
    }

    public boolean[] has(Date startInclusive, Date endExclusive) {
        HasResponse response = this.execute(new HasRequest(startInclusive, endExclusive, this.getTimezone()));
        this.lastResponse = response;
        try {
            return response.getValues();
        }
        catch (JSONException e) {
            this.lastException = e;
            return null;
        }
    }

    public List<Appointment> getCreatedEntities() {
        return this.createdEntities;
    }

    public Appointment createIdentifyingCopy(Appointment appointment) {
        Appointment copy = new Appointment();
        copy.setObjectID(appointment.getObjectID());
        copy.setParentFolderID(appointment.getParentFolderID());
        copy.setLastModified(appointment.getLastModified());
        return copy;
    }

    private boolean tryInteger(Appointment app, int field, Long value) {
        try {
            app.set(field, (Object)new Integer(value.intValue()));
            return true;
        }
        catch (ClassCastException x) {
            return false;
        }
    }

    private boolean tryDate(Appointment app, int field, Long value) {
        try {
            app.set(field, (Object)new Date(value));
            return true;
        }
        catch (ClassCastException x) {
            return false;
        }
    }

    public void clearFolder(int folderId, Date start, Date end) {
        for (Appointment app : this.all(folderId, start, end)) {
            this.delete(app);
        }
    }

    protected void extractInfo(AbstractAJAXResponse response) {
        this.setLastResponse(response);
        this.setLastModification(response.getTimestamp());
        if (response.hasError()) {
            this.setLastException((Exception)((Object)response.getException()));
        }
    }
}

