/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server;

import com.openexchange.groupware.contexts.Context;
import com.openexchange.server.impl.DBPool;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PoolRunner
implements Runnable {
    private final Context c;
    private final boolean close_connections;
    private Thread run;
    private int current_run = 0;
    public static final int TEST_RUNS = 200;
    public static final int WAIT_TIME = 10;
    public static final String TEST_QUERY = "SELECT 1 as test";
    private boolean isrunning = true;
    private int modrunner = 0;

    public PoolRunner(Context c, boolean close_connections) {
        this.c = c;
        this.close_connections = close_connections;
        this.start();
    }

    public void start() {
        this.run = new Thread((Runnable)this, "PoolRunner");
        this.run.start();
    }

    @Override
    public void run() {
        while (this.current_run < 200) {
            try {
                Connection con = DBPool.pickup((Context)this.c);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.close_connections) {
                    if (this.modrunner % 8 == 0) {
                        con.close();
                    } else if (this.modrunner % 9 == 0) {
                        con.close();
                    }
                }
                ++this.modrunner;
                this.simpleAction(con);
                DBPool.push((Context)this.c, (Connection)con);
                ++this.current_run;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isrunning = false;
        this.run.interrupt();
    }

    private void simpleAction(Connection con) throws SQLException {
        if (con != null && !con.isClosed()) {
            ResultSet rs = con.createStatement().executeQuery(TEST_QUERY);
            while (rs.next()) {
            }
        }
    }

    boolean isTestDone() {
        return this.isrunning;
    }

    Thread getRunnerThread() {
        return this.run;
    }
}

