/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder;

import com.openexchange.api2.ReminderService;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.Date;
import java.util.Properties;
import junit.framework.TestCase;

public class ReminderTest
extends TestCase {
    private ReminderService reminderSql = null;
    protected Properties reminderProps = null;
    private static boolean isInit = false;
    private final int userId = -1;
    private Context context = null;

    public void init() throws Exception {
        if (isInit) {
            return;
        }
        Init.startServer();
        isInit = true;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.init();
        int contextId = ContextStorage.getInstance().getContextId("defaultcontext");
        this.context = ContextStorage.getInstance().getContext(contextId);
        this.reminderSql = new ReminderHandler(this.context);
    }

    protected void tearDown() throws Exception {
        if (isInit) {
            Init.stopServer();
        }
        super.tearDown();
    }

    public void testInsert() throws Exception {
        int targetId = IDGenerator.getId((Context)this.context, (int)55);
        ReminderObject reminderObj = this.createReminderObject(targetId, 1);
        reminderObj.setDate(new Date(System.currentTimeMillis() - 3600000L));
        this.reminderSql.insertReminder(reminderObj);
    }

    public void testUpdate() throws Exception {
        int targetId = IDGenerator.getId((Context)this.context, (int)55);
        ReminderObject reminderObj = this.createReminderObject(targetId, 4);
        reminderObj.setDate(new Date(System.currentTimeMillis() - 3600000L));
        this.reminderSql.insertReminder(reminderObj);
        reminderObj = this.createReminderObject(targetId, 4);
        this.reminderSql.updateReminder(reminderObj);
    }

    public void testDelete() throws Exception {
        int targetId = IDGenerator.getId((Context)this.context, (int)55);
        ReminderObject reminderObj = this.createReminderObject(targetId, 1);
        reminderObj.setDate(new Date(System.currentTimeMillis() - 3600000L));
        this.reminderSql.insertReminder(reminderObj);
        this.reminderSql.deleteReminder(targetId, -1, reminderObj.getModule());
    }

    public void testDeleteAllReminders() throws Exception {
        int targetId = IDGenerator.getId((Context)this.context, (int)55);
        ReminderObject reminderObj = this.createReminderObject(targetId, 4);
        reminderObj.setDate(new Date(System.currentTimeMillis() - 3600000L));
        this.reminderSql.insertReminder(reminderObj);
        this.reminderSql.deleteReminder(targetId, 4);
    }

    public void testLoad() throws Exception {
        int targetId = IDGenerator.getId((Context)this.context, (int)55);
        Date alarm = new Date(System.currentTimeMillis() - 3600000L);
        ReminderObject reminderObj = this.createReminderObject(targetId, 7);
        reminderObj.setDate(alarm);
        int objectId = this.reminderSql.insertReminder(reminderObj);
        ReminderTest.assertTrue((String)"object_id is not > 0", (objectId > 0 ? 1 : 0) != 0);
        reminderObj = this.reminderSql.loadReminder(targetId, -1, 7);
        ReminderTest.assertNotNull((String)"is reminder object not null", (Object)reminderObj);
        ReminderTest.assertEquals((String)"targetId", (int)targetId, (int)reminderObj.getTargetId());
        ReminderTest.assertEquals((String)"module", (int)7, (int)reminderObj.getModule());
        ReminderTest.assertNotNull((String)"date", (Object)reminderObj.getDate());
        ReminderTest.assertEquals((String)"userId", (int)-1, (int)reminderObj.getUser());
    }

    public void testListReminderByTargetId() throws Exception {
        int targetId = IDGenerator.getId((Context)this.context, (int)55);
        ReminderObject reminderObj = this.createReminderObject(targetId, 1);
        reminderObj.setDate(new Date(System.currentTimeMillis() - 3600000L));
        this.reminderSql.insertReminder(reminderObj);
        int counter = 0;
        SearchIterator it = this.reminderSql.listReminder(1, targetId);
        while (it.hasNext()) {
            ReminderObject r = (ReminderObject)it.next();
            ReminderTest.assertNotNull((String)"check reminder objects in iterator", (Object)r);
            ++counter;
        }
        ReminderTest.assertTrue((String)"result > 0", (counter >= 1 ? 1 : 0) != 0);
    }

    public void testListReminderBetweenByUserId() throws Exception {
        int targetId = IDGenerator.getId((Context)this.context, (int)55);
        ReminderObject reminderObj = this.createReminderObject(targetId, 1);
        reminderObj.setDate(new Date(System.currentTimeMillis() - 3600000L));
        this.reminderSql.insertReminder(reminderObj);
        int counter = 0;
        SearchIterator it = this.reminderSql.listModifiedReminder(-1, new Date());
        while (it.hasNext()) {
            ReminderObject r = (ReminderObject)it.next();
            ReminderTest.assertNotNull((String)"check reminder objects in iterator", (Object)r);
            ++counter;
        }
        ReminderTest.assertTrue((String)"result > 0", (counter >= 1 ? 1 : 0) != 0);
    }

    public void testListLastModifiedReminderUserId() throws Exception {
        int targetId = IDGenerator.getId((Context)this.context, (int)55);
        ReminderObject reminderObj = this.createReminderObject(targetId, 1);
        reminderObj.setDate(new Date(System.currentTimeMillis() - 3600000L));
        this.reminderSql.insertReminder(reminderObj);
        int counter = 0;
        SearchIterator it = this.reminderSql.listModifiedReminder(-1, new Date(0L));
        while (it.hasNext()) {
            ReminderObject r = (ReminderObject)it.next();
            ReminderTest.assertNotNull((String)"check reminder objects in iterator", (Object)r);
            ++counter;
        }
        ReminderTest.assertTrue((String)"result > 0", (counter >= 1 ? 1 : 0) != 0);
    }

    public void testExistsReminder() throws Exception {
        int targetId = IDGenerator.getId((Context)this.context, (int)55);
        ReminderObject reminderObj = this.createReminderObject(targetId, 1);
        reminderObj.setDate(new Date());
        this.reminderSql.insertReminder(reminderObj);
        ReminderTest.assertTrue((String)"reminder does not exists!", (boolean)this.reminderSql.existsReminder(targetId, -1, 1));
        ReminderTest.assertFalse((String)"find invalid reminder!", (boolean)this.reminderSql.existsReminder(targetId + 1, -1, 1));
    }

    protected ReminderObject createReminderObject(int targetId, int module) {
        ReminderObject reminderObj = new ReminderObject();
        reminderObj.setUser(-1);
        reminderObj.setModule(module);
        reminderObj.setTargetId(targetId);
        reminderObj.setDate(new Date());
        return reminderObj;
    }
}

