/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.event.CommonEvent;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.util.TimeZones;
import com.openexchange.tools.events.TestEventAdmin;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.osgi.service.event.Event;

public class Bug16540Test
extends CalendarSqlTest {
    public void testShouldTriggerEventOnUpdateToAlarmFlag() throws OXException {
        Calendar c = TimeTools.createCalendar(TimeZones.UTC);
        c.add(5, 1);
        c.set(10, 10);
        Date start = c.getTime();
        c.add(10, 2);
        Date end = c.getTime();
        CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
        appointment.setAlarm(15);
        appointment.setAlarmFlag(true);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        CalendarDataObject update = this.appointments.createIdentifyingCopy(appointment);
        update.setAlarmFlag(false);
        update.setAlarm(-1);
        TestEventAdmin eventAdmin = TestEventAdmin.getInstance();
        eventAdmin.clearEvents();
        this.appointments.save(update);
        List<Event> events = eventAdmin.getEvents();
        Event event = events.get(0);
        Bug16540Test.assertEquals((String)"Wrong topic", (String)"com/openexchange/groupware/appointment/update", (String)event.getTopic());
        CommonEvent commonEvent = (CommonEvent)event.getProperty("OX_EVENT");
        Bug16540Test.assertEquals((String)"Wrong action", (int)2, (int)commonEvent.getAction());
        Bug16540Test.assertEquals((String)"Wrong object identifier", (int)appointment.getObjectID(), (int)((DataObject)commonEvent.getActionObj()).getObjectID());
        Bug16540Test.assertEquals((String)"Wrong context", (int)this.appointments.getSession().getContextId(), (int)commonEvent.getContextId());
        Bug16540Test.assertEquals((String)"Wrong module", (int)1, (int)commonEvent.getModule());
        Bug16540Test.assertEquals((String)"Wrong folder", (int)this.appointments.getPrivateFolder(), (int)((FolderObject)commonEvent.getSourceFolder()).getObjectID());
        Bug16540Test.assertEquals((String)"Wrong user", (int)this.appointments.getSession().getUserId(), (int)commonEvent.getUserId());
    }
}

