/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.mdimension.jchronic.Chronic;
import com.mdimension.jchronic.utils.Span;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class TimeTools {
    private static final String[] patterns = new String[]{"dd/MM/yyyy HH:mm", "dd.MM.yyyy HH:mm", "yyyy-MM-dd HH:mm"};

    private TimeTools() {
    }

    @Deprecated
    public static long getHour(int diff) {
        return (System.currentTimeMillis() / 3600000L + (long)diff) * 3600000L;
    }

    public static long getHour(int diff, TimeZone tz) {
        GregorianCalendar calendar = new GregorianCalendar(tz);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        ((Calendar)calendar).add(11, diff);
        return calendar.getTimeInMillis();
    }

    public static Calendar createCalendar(TimeZone tz) {
        GregorianCalendar calendar = new GregorianCalendar(tz);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar createCalendar(TimeZone tz, int year, int month, int day, int hour) {
        GregorianCalendar calendar = new GregorianCalendar(tz);
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Date D(String value, TimeZone timeZone) {
        for (String fallbackPattern : patterns) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(fallbackPattern);
                if (null != timeZone) {
                    sdf.setTimeZone(timeZone);
                }
                return sdf.parse(value);
            }
            catch (ParseException e) {
            }
        }
        Date date = null;
        Span span = Chronic.parse((String)value);
        if (null == span) {
            return null;
        }
        date = span.getBeginCalendar().getTime();
        if (null != timeZone) {
            date = TimeTools.applyTimeZone(timeZone, date);
        }
        return date;
    }

    public static Date D(String date) {
        return TimeTools.D(date, TimeZone.getTimeZone("UTC"));
    }

    public static Date applyTimeZone(TimeZone timeZone, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        String dateString = sdf.format(date);
        sdf.setTimeZone(timeZone);
        try {
            return sdf.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date removeMilliseconds(Date roundme) {
        long timestamp = roundme.getTime();
        timestamp /= 1000L;
        return new Date(timestamp *= 1000L);
    }
}

