/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.tests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.java.util.TimeZones;
import com.openexchange.test.CalendarTestManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ConfirmationTest
extends CalDAVTest {
    private CalendarTestManager manager2;

    public ConfirmationTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager2 = new CalendarTestManager(new AJAXClient(AJAXClient.User.User2));
        this.manager2.setFailOnError(true);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.manager2) {
            this.manager2.cleanUp();
            if (null != this.manager2.getClient()) {
                this.manager2.getClient().logout();
            }
        }
        super.tearDown();
    }

    public void testConfirmSeriesOnClient() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = ConfirmationTest.randomUID();
        String summary = "serie";
        String location = "test";
        Date start = TimeTools.D("next friday at 11:30");
        Date end = TimeTools.D("next friday at 12:45");
        Appointment appointment = ConfirmationTest.generateAppointment(start, end, uid, summary, location);
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        ArrayList<UserParticipant> participants = new ArrayList<UserParticipant>();
        participants.add(new UserParticipant(this.getClient().getValues().getUserId()));
        participants.add(new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        appointment.setParticipants(participants);
        appointment.setParentFolderID(this.manager2.getPrivateFolder());
        appointment.setIgnoreConflicts(true);
        this.manager2.insert(appointment);
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ConfirmationTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = ConfirmationTest.assertContains(uid, calendarData);
        ConfirmationTest.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        SimpleICal.Property attendee = iCalResource.getVEvent().getAttendee(this.getClient().getValues().getDefaultAddress());
        ConfirmationTest.assertNotNull((String)"Attendee not found in iCal", (Object)attendee);
        ConfirmationTest.assertTrue((String)"PARTSTAT wrong", (null == attendee.getAttribute("PARTSTAT") || "NEEDS-ACTION".equals(attendee.getAttribute("PARTSTAT")) ? 1 : 0) != 0);
        attendee.getAttributes().put("PARTSTAT", "ACCEPTED");
        ConfirmationTest.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(uid);
        ConfirmationTest.assertNotNull((String)"appointment not found on server", (Object)appointment);
        ConfirmationTest.assertNotNull((String)"no users found in apointment", (Object)appointment.getUsers());
        UserParticipant user = null;
        for (UserParticipant participant : appointment.getUsers()) {
            if (this.client.getValues().getUserId() != participant.getIdentifier()) continue;
            user = participant;
            break;
        }
        ConfirmationTest.assertNotNull((String)"User not found", user);
        ConfirmationTest.assertEquals((String)"Confirm status wrong", (int)1, (int)user.getConfirm());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ConfirmationTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        calendarData = super.calendarMultiget(eTags.keySet());
        iCalResource = ConfirmationTest.assertContains(uid, calendarData);
        ConfirmationTest.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        attendee = iCalResource.getVEvent().getAttendee(this.getClient().getValues().getDefaultAddress());
        ConfirmationTest.assertNotNull((String)"Attendee not found in iCal", (Object)attendee);
        ConfirmationTest.assertEquals((String)"PARTSTAT wrong", (String)"ACCEPTED", (String)attendee.getAttribute("PARTSTAT"));
    }

    public void testConfirmSeriesOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = ConfirmationTest.randomUID();
        String summary = "serie";
        String location = "test";
        Date start = TimeTools.D("next friday at 11:30");
        Date end = TimeTools.D("next friday at 12:45");
        Appointment appointment = ConfirmationTest.generateAppointment(start, end, uid, summary, location);
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        ArrayList<UserParticipant> participants = new ArrayList<UserParticipant>();
        participants.add(new UserParticipant(this.getClient().getValues().getUserId()));
        participants.add(new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        appointment.setParticipants(participants);
        appointment.setParentFolderID(this.manager2.getPrivateFolder());
        appointment.setIgnoreConflicts(true);
        this.manager2.insert(appointment);
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ConfirmationTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = ConfirmationTest.assertContains(uid, calendarData);
        ConfirmationTest.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        SimpleICal.Property attendee = iCalResource.getVEvent().getAttendee(this.getClient().getValues().getDefaultAddress());
        ConfirmationTest.assertNotNull((String)"Attendee not found in iCal", (Object)attendee);
        ConfirmationTest.assertTrue((String)"PARTSTAT wrong", (null == attendee.getAttribute("PARTSTAT") || "NEEDS-ACTION".equals(attendee.getAttribute("PARTSTAT")) ? 1 : 0) != 0);
        this.getManager().confirm(appointment, 1, "ok");
        appointment = super.getAppointment(uid);
        ConfirmationTest.assertNotNull((String)"appointment not found on server", (Object)appointment);
        ConfirmationTest.assertNotNull((String)"no users found in apointment", (Object)appointment.getUsers());
        UserParticipant user = null;
        for (UserParticipant participant : appointment.getUsers()) {
            if (this.client.getValues().getUserId() != participant.getIdentifier()) continue;
            user = participant;
            break;
        }
        ConfirmationTest.assertNotNull((String)"User not found", user);
        ConfirmationTest.assertEquals((String)"Confirm status wrong", (int)1, (int)user.getConfirm());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ConfirmationTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        calendarData = super.calendarMultiget(eTags.keySet());
        iCalResource = ConfirmationTest.assertContains(uid, calendarData);
        ConfirmationTest.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        attendee = iCalResource.getVEvent().getAttendee(this.getClient().getValues().getDefaultAddress());
        ConfirmationTest.assertNotNull((String)"Attendee not found in iCal", (Object)attendee);
        ConfirmationTest.assertEquals((String)"PARTSTAT wrong", (String)"ACCEPTED", (String)attendee.getAttribute("PARTSTAT"));
    }

    public void testConfirmOccurrenceOnClient() throws Exception {
        SimpleICal.Component exceptionVEvent;
        SimpleICal.Component seriesVEvent;
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = ConfirmationTest.randomUID();
        String summary = "serie";
        String location = "test";
        Date start = TimeTools.D("next friday at 11:30");
        Date end = TimeTools.D("next friday at 12:45");
        Appointment appointment = ConfirmationTest.generateAppointment(start, end, uid, summary, location);
        appointment.setTimezone("Europe/Berlin");
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        ArrayList<UserParticipant> participants = new ArrayList<UserParticipant>();
        participants.add(new UserParticipant(this.getClient().getValues().getUserId()));
        participants.add(new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        appointment.setParticipants(participants);
        appointment.setParentFolderID(this.manager2.getPrivateFolder());
        appointment.setIgnoreConflicts(true);
        this.manager2.insert(appointment);
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ConfirmationTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = ConfirmationTest.assertContains(uid, calendarData);
        ConfirmationTest.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        SimpleICal.Property attendee = iCalResource.getVEvent().getAttendee(this.getClient().getValues().getDefaultAddress());
        ConfirmationTest.assertNotNull((String)"Attendee not found in iCal", (Object)attendee);
        ConfirmationTest.assertTrue((String)"PARTSTAT of series wrong", (null == attendee.getAttribute("PARTSTAT") || "NEEDS-ACTION".equals(attendee.getAttribute("PARTSTAT")) ? 1 : 0) != 0);
        SimpleICal.Component exception = new SimpleICal.Component("VEVENT");
        for (SimpleICal.Property property : iCalResource.getVEvent().getProperties()) {
            exception.getProperties().add(new SimpleICal.Property(property.toString()));
        }
        attendee = exception.getAttendee(this.getClient().getValues().getDefaultAddress());
        attendee.getAttributes().put("PARTSTAT", "ACCEPTED");
        Calendar calendar = Calendar.getInstance(TimeZones.UTC);
        calendar.setTime(appointment.getStartDate());
        calendar.add(6, 5);
        Date exceptionStartDate = calendar.getTime();
        calendar.setTime(appointment.getEndDate());
        calendar.add(6, 5);
        Date exceptionEndDate = calendar.getTime();
        exception.getProperties().add(new SimpleICal.Property("RECURRENCE-ID;TZID=" + appointment.getTimezone() + ":" + ConfirmationTest.format(exceptionStartDate, appointment.getTimezone())));
        iCalResource.addComponent(exception);
        exception.setDTStart(exceptionStartDate);
        exception.setDTEnd(exceptionEndDate);
        ConfirmationTest.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(uid);
        ConfirmationTest.assertNotNull((String)"appointment not found on server", (Object)appointment);
        ConfirmationTest.assertNotNull((String)"no users found in apointment", (Object)appointment.getUsers());
        UserParticipant user = null;
        for (UserParticipant participant : appointment.getUsers()) {
            if (this.client.getValues().getUserId() != participant.getIdentifier()) continue;
            user = participant;
            break;
        }
        ConfirmationTest.assertNotNull((String)"User not found", user);
        ConfirmationTest.assertEquals((String)"Confirm status of series wrong", (int)0, (int)user.getConfirm());
        ConfirmationTest.assertNotNull((String)"No change exceptions found", (Object)appointment.getChangeException());
        ConfirmationTest.assertEquals((String)"Invalid number of change exceptions found", (int)1, (int)appointment.getChangeException().length);
        List<Appointment> changeExceptions = this.getManager().getChangeExceptions(appointment.getParentFolderID(), appointment.getObjectID(), Appointment.ALL_COLUMNS);
        ConfirmationTest.assertNotNull((String)"no change exceptions found", changeExceptions);
        ConfirmationTest.assertEquals((String)"Invalid number of change exceptions found", (int)1, (int)changeExceptions.size());
        Appointment changeException = this.getManager().get(appointment.getParentFolderID(), changeExceptions.get(0).getObjectID());
        ConfirmationTest.assertNotNull((String)"change exception not found", (Object)changeException);
        ConfirmationTest.assertEquals((String)"Invalid start date of change exception", (Object)exceptionStartDate, (Object)changeException.getStartDate());
        ConfirmationTest.assertNotNull((String)"no users found in apointment", (Object)changeException.getUsers());
        user = null;
        for (UserParticipant participant : changeException.getUsers()) {
            if (this.client.getValues().getUserId() != participant.getIdentifier()) continue;
            user = participant;
            break;
        }
        ConfirmationTest.assertNotNull((String)"User not found", (Object)user);
        ConfirmationTest.assertEquals((String)"Confirm status of change exception wrong", (int)1, (int)user.getConfirm());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ConfirmationTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        calendarData = super.calendarMultiget(eTags.keySet());
        ConfirmationTest.assertEquals((String)"no exception found in iCal", (int)2, (int)iCalResource.getVEvents().size());
        if (null == iCalResource.getVEvents().get(0).getProperty("RECURRENCE-ID")) {
            seriesVEvent = iCalResource.getVEvents().get(0);
            exceptionVEvent = iCalResource.getVEvents().get(1);
        } else {
            seriesVEvent = iCalResource.getVEvents().get(1);
            exceptionVEvent = iCalResource.getVEvents().get(0);
        }
        ConfirmationTest.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        attendee = seriesVEvent.getAttendee(this.getClient().getValues().getDefaultAddress());
        ConfirmationTest.assertNotNull((String)"Attendee not found in series iCal", (Object)attendee);
        ConfirmationTest.assertTrue((String)"PARTSTAT of series wrong", (null == attendee.getAttribute("PARTSTAT") || "NEEDS-ACTION".equals(attendee.getAttribute("PARTSTAT")) ? 1 : 0) != 0);
        attendee = exceptionVEvent.getAttendee(this.getClient().getValues().getDefaultAddress());
        ConfirmationTest.assertNotNull((String)"Attendee not found in exception iCal", (Object)attendee);
        ConfirmationTest.assertEquals((String)"PARTSTAT wrong", (String)"ACCEPTED", (String)attendee.getAttribute("PARTSTAT"));
    }

    public void testConfirmOccurrenceOnServer() throws Exception {
        SimpleICal.Component exceptionVEvent;
        SimpleICal.Component seriesVEvent;
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = ConfirmationTest.randomUID();
        String summary = "serie";
        String location = "test";
        Date start = TimeTools.D("next friday at 11:30");
        Date end = TimeTools.D("next friday at 12:45");
        Appointment appointment = ConfirmationTest.generateAppointment(start, end, uid, summary, location);
        appointment.setTimezone("Europe/Berlin");
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        ArrayList<UserParticipant> participants = new ArrayList<UserParticipant>();
        participants.add(new UserParticipant(this.getClient().getValues().getUserId()));
        participants.add(new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        appointment.setParticipants(participants);
        appointment.setParentFolderID(this.manager2.getPrivateFolder());
        appointment.setIgnoreConflicts(true);
        this.manager2.insert(appointment);
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ConfirmationTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = ConfirmationTest.assertContains(uid, calendarData);
        ConfirmationTest.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        SimpleICal.Property attendee = iCalResource.getVEvent().getAttendee(this.getClient().getValues().getDefaultAddress());
        ConfirmationTest.assertNotNull((String)"Attendee not found in iCal", (Object)attendee);
        ConfirmationTest.assertTrue((String)"PARTSTAT of series wrong", (null == attendee.getAttribute("PARTSTAT") || "NEEDS-ACTION".equals(attendee.getAttribute("PARTSTAT")) ? 1 : 0) != 0);
        Calendar calendar = Calendar.getInstance(TimeZones.UTC);
        calendar.setTime(appointment.getStartDate());
        calendar.add(6, 5);
        Date exceptionStartDate = calendar.getTime();
        appointment.setParentFolderID(this.getManager().getPrivateFolder());
        this.getManager().confirm(appointment, 1, "ok", 6);
        appointment = super.getAppointment(uid);
        ConfirmationTest.assertNotNull((String)"appointment not found on server", (Object)appointment);
        ConfirmationTest.assertNotNull((String)"no users found in apointment", (Object)appointment.getUsers());
        UserParticipant user = null;
        for (UserParticipant participant : appointment.getUsers()) {
            if (this.client.getValues().getUserId() != participant.getIdentifier()) continue;
            user = participant;
            break;
        }
        ConfirmationTest.assertNotNull((String)"User not found", user);
        ConfirmationTest.assertEquals((String)"Confirm status of series wrong", (int)0, (int)user.getConfirm());
        ConfirmationTest.assertNotNull((String)"No change exceptions found", (Object)appointment.getChangeException());
        ConfirmationTest.assertEquals((String)"Invalid number of change exceptions found", (int)1, (int)appointment.getChangeException().length);
        List<Appointment> changeExceptions = this.getManager().getChangeExceptions(appointment.getParentFolderID(), appointment.getObjectID(), Appointment.ALL_COLUMNS);
        ConfirmationTest.assertNotNull((String)"no change exceptions found", changeExceptions);
        ConfirmationTest.assertEquals((String)"Invalid number of change exceptions found", (int)1, (int)changeExceptions.size());
        Appointment changeException = this.getManager().get(appointment.getParentFolderID(), changeExceptions.get(0).getObjectID());
        ConfirmationTest.assertNotNull((String)"change exception not found", (Object)changeException);
        ConfirmationTest.assertEquals((String)"Invalid start date of change exception", (Object)exceptionStartDate, (Object)changeException.getStartDate());
        ConfirmationTest.assertNotNull((String)"no users found in apointment", (Object)changeException.getUsers());
        user = null;
        for (UserParticipant participant : changeException.getUsers()) {
            if (this.client.getValues().getUserId() != participant.getIdentifier()) continue;
            user = participant;
            break;
        }
        ConfirmationTest.assertNotNull((String)"User not found", (Object)user);
        ConfirmationTest.assertEquals((String)"Confirm status of change exception wrong", (int)1, (int)user.getConfirm());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        ConfirmationTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        calendarData = super.calendarMultiget(eTags.keySet());
        iCalResource = ConfirmationTest.assertContains(uid, calendarData);
        ConfirmationTest.assertEquals((String)"no exception found in iCal", (int)2, (int)iCalResource.getVEvents().size());
        if (null == iCalResource.getVEvents().get(0).getProperty("RECURRENCE-ID")) {
            seriesVEvent = iCalResource.getVEvents().get(0);
            exceptionVEvent = iCalResource.getVEvents().get(1);
        } else {
            seriesVEvent = iCalResource.getVEvents().get(1);
            exceptionVEvent = iCalResource.getVEvents().get(0);
        }
        ConfirmationTest.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        attendee = seriesVEvent.getAttendee(this.getClient().getValues().getDefaultAddress());
        ConfirmationTest.assertNotNull((String)"Attendee not found in series iCal", (Object)attendee);
        ConfirmationTest.assertTrue((String)"PARTSTAT of series wrong", (null == attendee.getAttribute("PARTSTAT") || "NEEDS-ACTION".equals(attendee.getAttribute("PARTSTAT")) ? 1 : 0) != 0);
        attendee = exceptionVEvent.getAttendee(this.getClient().getValues().getDefaultAddress());
        ConfirmationTest.assertNotNull((String)"Attendee not found in exception iCal", (Object)attendee);
        ConfirmationTest.assertEquals((String)"PARTSTAT wrong", (String)"ACCEPTED", (String)attendee.getAttribute("PARTSTAT"));
    }
}

