/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.ListRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.TimeZone;
import org.json.JSONException;

public class Bug10071Test
extends AbstractTaskTest {
    private static final int[] ATTRIBUTE_IDS = new int[]{308, 303, 307, 302};
    private AJAXClient client;
    private int folderId;
    private TimeZone tz;
    private Task task;

    public Bug10071Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.folderId = this.client.getValues().getPrivateTaskFolder();
        this.tz = this.client.getValues().getTimeZone();
        this.task = Create.createWithDefaults(this.folderId, "Bug 10071 test task");
        for (int attributeId : ATTRIBUTE_IDS) {
            this.setToZero(Mapping.getMapping((int)attributeId));
        }
        InsertResponse insertR = this.client.execute(new InsertRequest(this.task, this.tz));
        insertR.fillTask(this.task);
    }

    private void setToZero(Mapper mapper) {
        for (Object value : new Object[]{Autoboxing.L((long)0L), new BigDecimal(0)}) {
            try {
                mapper.set(this.task, value);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.task));
        super.tearDown();
    }

    public void testDurationAndCostsSetToZero() throws OXException, IOException, JSONException, OXException {
        GetRequest request = new GetRequest(this.task);
        GetResponse response = this.client.execute(request);
        Task toTest = response.getTask(this.tz);
        ListIDs ids = ListIDs.l(new int[][]{{this.task.getParentFolderID(), this.task.getObjectID()}});
        ListRequest request2 = new ListRequest(ids, ATTRIBUTE_IDS);
        CommonListResponse response2 = this.client.execute(request2);
        for (int attributeId : ATTRIBUTE_IDS) {
            Mapper mapper = Mapping.getMapping((int)attributeId);
            Bug10071Test.assertTrue((String)("Attribute " + mapper.getDBColumnName() + " is missing in GET."), (boolean)mapper.isSet(toTest));
            Bug10071Test.assertEquals((String)("Attribute " + mapper.getDBColumnName() + " has wrong value in GET."), (Object)mapper.get(this.task), (Object)mapper.get(toTest));
            Object value = response2.getValue(0, attributeId);
            if (Long.class.equals(mapper.get(toTest).getClass())) {
                value = Long.valueOf((String)value);
            } else if (BigDecimal.class.equals(mapper.get(toTest).getClass())) {
                value = new BigDecimal(value.toString());
            }
            Bug10071Test.assertNotNull((String)("Attribute " + mapper.getDBColumnName() + " is missing in LIST."), (Object)value);
            Bug10071Test.assertEquals((String)("Attribute " + mapper.getDBColumnName() + " has wrong value in LIST."), (Object)mapper.get(this.task), (Object)value);
        }
    }
}

