/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.importexport.actions.VCardExportRequest;
import com.openexchange.ajax.importexport.actions.VCardExportResponse;
import com.openexchange.ajax.importexport.actions.VCardImportRequest;
import com.openexchange.ajax.importexport.actions.VCardImportResponse;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Strings;
import com.openexchange.test.ContactTestManager;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug18094Test_VCardRoundtrip
extends AbstractManagedContactTest {
    private Contact contact;

    public Bug18094Test_VCardRoundtrip(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.contact = ContactTestManager.generateFullContact(this.folderID);
        this.manager.newAction(this.contact);
    }

    public void testFullVCardRoundtrip() throws Exception {
        VCardExportRequest exportRequest = new VCardExportRequest(this.folderID, false);
        VCardExportResponse exportResponse = this.manager.getClient().execute(exportRequest);
        String vcard = exportResponse.getVCard();
        this.manager.deleteAction(this.contact);
        VCardImportRequest importRequest = new VCardImportRequest(this.folderID, new ByteArrayInputStream(vcard.getBytes()));
        VCardImportResponse importResponse = this.manager.getClient().execute(importRequest);
        JSONArray response = (JSONArray)importResponse.getData();
        Bug18094Test_VCardRoundtrip.assertEquals((String)"Precondition: Should only find one contact in there", (int)1, (int)response.length());
        JSONObject jsonObject = response.getJSONObject(0);
        Contact actual = this.manager.getAction(jsonObject.getInt("folder_id"), jsonObject.getInt("id"));
        HashSet<ContactField> excluded = new HashSet<ContactField>(){
            {
                this.add(ContactField.FOLDER_ID);
                this.add(ContactField.OBJECT_ID);
                this.add(ContactField.LAST_MODIFIED);
                this.add(ContactField.MODIFIED_BY);
                this.add(ContactField.CREATION_DATE);
                this.add(ContactField.CREATED_BY);
                this.add(ContactField.INTERNAL_USERID);
                this.add(ContactField.MARK_AS_DISTRIBUTIONLIST);
                this.add(ContactField.NUMBER_OF_ATTACHMENTS);
                this.add(ContactField.NUMBER_OF_DISTRIBUTIONLIST);
                this.add(ContactField.IMAGE1_URL);
            }
        };
        LinkedList<ContactField> mismatches = new LinkedList<ContactField>();
        for (ContactField field : ContactField.values()) {
            if (excluded.contains(field)) continue;
            int number = field.getNumber();
            Object actualValue = actual.get(number);
            Object expectedValue = this.contact.get(number);
            if (expectedValue == null && actualValue == null || expectedValue != null && expectedValue.equals(actualValue)) continue;
            mismatches.add(field);
        }
        Collections.sort(mismatches, new Comparator<ContactField>(){

            @Override
            public int compare(ContactField o1, ContactField o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        String fields = Strings.join(mismatches, (String)" ");
        Bug18094Test_VCardRoundtrip.assertTrue((String)("Too many (" + mismatches.size() + ") fields not surviving the roundtrip: \n" + fields), (mismatches.size() < 58 ? 1 : 0) != 0);
    }
}

